## ----global_options, include=FALSE-----------------------------------------
knitr::opts_chunk$set(fig.width=6, fig.height=6, fig.path='figures/')

## ----loading, message = FALSE----------------------------------------------
library(biosigner)

## ----diaplasma-------------------------------------------------------------
data(diaplasma)

## ----diaplasma_strF--------------------------------------------------------
attach(diaplasma)
library(ropls)
strF(dataMatrix)
strF(sampleMetadata)
strF(variableMetadata)

## ----diaplasma_plot--------------------------------------------------------
with(sampleMetadata,
plot(age, bmi, cex = 1.5, col = ifelse(type == "T1", "blue", "red"), pch = 16))
legend("topleft", cex = 1.5, legend = paste0("T", 1:2),
text.col = c("blue", "red"))

## ----select----------------------------------------------------------------
featureSelVl <- variableMetadata[, "mzmed"] >= 450 &
variableMetadata[, "mzmed"] < 500
sum(featureSelVl)
dataMatrix <- dataMatrix[, featureSelVl]
variableMetadata <- variableMetadata[featureSelVl, ]

## ----biosign---------------------------------------------------------------
set.seed(123)
diaSign <- biosign(dataMatrix, sampleMetadata[, "type"], bootI = 5)
set.seed(NULL)

## ----boxplot---------------------------------------------------------------
plot(diaSign, typeC = "boxplot")

## ----signature-------------------------------------------------------------
variableMetadata[getSignatureLs(diaSign)[["complete"]], ]

## ----train-----------------------------------------------------------------
trainVi <- 1:floor(0.8 * nrow(dataMatrix))
testVi <- setdiff(1:nrow(dataMatrix), trainVi)

## ----biosign_train, warning = FALSE----------------------------------------
set.seed(123)
diaTrain <- biosign(dataMatrix[trainVi, ], sampleMetadata[trainVi, "type"],
bootI = 5)
set.seed(NULL)

## ----predict---------------------------------------------------------------
diaFitDF <- predict(diaTrain)

## ----confusion-------------------------------------------------------------
lapply(diaFitDF, function(predFc) table(actual = sampleMetadata[trainVi,
"type"], predicted = predFc))

## ----accuracy--------------------------------------------------------------
sapply(diaFitDF, function(predFc) {
conf <- table(sampleMetadata[trainVi, "type"], predFc)
conf <- sweep(conf, 1, rowSums(conf), "/")
round(mean(diag(conf)), 3)
})

## ----getAccuracy-----------------------------------------------------------
round(getAccuracyMN(diaTrain)["S", ], 3)

## ----performance-----------------------------------------------------------
diaTestDF <- predict(diaTrain, newdata = dataMatrix[testVi, ])
sapply(diaTestDF, function(predFc) {
conf <- table(sampleMetadata[testVi, "type"], predFc)
conf <- sweep(conf, 1, rowSums(conf), "/")
round(mean(diag(conf)), 3)
})

## ----expressionset_code, eval = FALSE, message = FALSE, warning = FALSE----
#  library(Biobase)
#  diaSet <- ExpressionSet(assayData = t(dataMatrix),
#  phenoData = new("AnnotatedDataFrame", data = sampleMetadata))
#  set.seed(123)
#  biosign(diaSet, "type", bootI = 5)
#  set.seed(NULL)

## ----detach----------------------------------------------------------------
detach(diaplasma)

## ----sacurine--------------------------------------------------------------
data(sacurine)
set.seed(123) ##
sacSign <- biosign(sacurine[["dataMatrix"]],
sacurine[["sampleMetadata"]][, "gender"],
methodVc = "plsda")
set.seed(NULL)

## ----biomark, warning = FALSE, message = FALSE-----------------------------
library(BioMark)
data(SpikePos)
group1Vi <- which(SpikePos[["classes"]] %in% c("control", "group1"))
appleMN <- SpikePos[["data"]][group1Vi, ]
spikeFc <- factor(SpikePos[["classes"]][group1Vi])
annotDF <- SpikePos[["annotation"]]
rownames(annotDF) <- colnames(appleMN)

## ----biomark_pca-----------------------------------------------------------
biomark.pca <- ropls::opls(appleMN, fig.pdfC = NULL)
plot(biomark.pca, parAsColFcVn = spikeFc)

## ----biomark_pls-----------------------------------------------------------
biomark.pls <- ropls::opls(appleMN, spikeFc)

## ----apple_biosign, warning = FALSE----------------------------------------
set.seed(123)
appleSign <- biosign(appleMN, spikeFc)
set.seed(NULL)

## ----annotation------------------------------------------------------------
annotDF <- SpikePos[["annotation"]]
rownames(annotDF) <- colnames(appleMN)
annotDF[getSignatureLs(appleSign)[["complete"]], c("adduct", "found.in.standards")]

## ----golub_false, warning = FALSE, message = FALSE-------------------------
library(golubEsets)
data(Golub_Merge)
golubMN <- t(exprs(Golub_Merge))
leukemiaFc <- pData(Golub_Merge)[["ALL.AML"]]
table(leukemiaFc)
varSubVi <- 1501:2000
set.seed(123)
golubSign <- biosign(golubMN[, varSubVi], leukemiaFc, methodVc = "svm")
set.seed(NULL)

## ----hu6800, warning = FALSE, message = FALSE------------------------------
library(hu6800.db)
sapply(getSignatureLs(golubSign)[["complete"]],
       function(probeC)
       get(probeC, env = hu6800GENENAME))

## ----empty, echo = FALSE---------------------------------------------------
rm(list = ls())

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

