## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(dpi = 300)
knitr::opts_chunk$set(cache=FALSE)

## ---- echo = FALSE,hide=TRUE, message=FALSE,warning=FALSE----------------
devtools::load_all(".")

## ----message=FALSE, warning=FALSE, include=FALSE-------------------------
library(SummarizedExperiment)
library(dplyr)
library(DT)

## ----message=FALSE, warning=FALSE----------------------------------------
subtypes <- PanCancerAtlas_subtypes()
DT::datatable(subtypes,
             filter = 'top',
             options = list(scrollX = TRUE, keys = TRUE, pageLength = 5),
             rownames = FALSE)

## ---- eval = FALSE-------------------------------------------------------
#  lgg.gbm.subtype <- TCGAquery_subtype(tumor = "lgg")

## ---- eval = TRUE, echo = FALSE------------------------------------------
datatable(lgg.gbm.subtype[1:10,],
          caption = "Table with LGG molecular subtypes from TCGAquery_subtype",
          filter = 'top',
          options = list(scrollX = TRUE, keys = TRUE, pageLength = 5), 
          rownames = FALSE)

## ----sessionInfo---------------------------------------------------------
sessionInfo()

