### R code from vignette source 'Repitools_vignette.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: loadPkg
###################################################
options(prompt = " ", continue = " ")
set.seed(4)
library(Repitools)


###################################################
### code chunk number 2: findClusters
###################################################
stats.table <- data.frame(chr = "chr1", pos = 1:500, t.stat = rnorm(500))
stats.table[100:104, "t.stat"] <- rnorm(5, 5)
stats.table[200:204, "t.stat"] <- rnorm(5, -5)
stats.clustered <- findClusters(stats.table, score.col = 3, w.size = 5, n.med = 2, n.consec = 3, cut.samps = seq(-2, -10, -2), maxFDR = 0.05, trend = "down", n.perm = 10)
cluster.1 <- which(stats.clustered$cluster == 1)
stats.clustered[cluster.1, ]


###################################################
### code chunk number 3: genomeBlocks
###################################################
chrs <- c(50000, 10000)
names(chrs) <- c("chr1", "chr2") 
genomeBlocks(chrs, width = 5000)


