/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.lang.reflect.Field;
import net.sf.picard.PicardException;
import net.sf.picard.util.FormatUtil;

public class MetricBase {
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        for (Field f : this.getClass().getFields()) {
            try {
                Object lhs = f.get(this);
                Object rhs = f.get(o);
                if (lhs == null) {
                    if (rhs == null || rhs == null) continue;
                    return false;
                }
                if (lhs.equals(rhs)) continue;
                return false;
            }
            catch (IllegalAccessException iae) {
                throw new PicardException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Field f : this.getClass().getFields()) {
            try {
                result = 31 * result + f.get(this).hashCode();
            }
            catch (IllegalAccessException e) {
                throw new PicardException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        FormatUtil formatter = new FormatUtil();
        for (Field f : this.getClass().getFields()) {
            try {
                buffer.append(f.getName());
                buffer.append("\t");
                buffer.append(formatter.format(f.get(this)));
                buffer.append("\n");
            }
            catch (IllegalAccessException iae) {
                throw new PicardException("Could not read field " + f.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return buffer.toString();
    }
}

