## ---- echo = FALSE---------------------------------------------------------
suppressPackageStartupMessages({
    library(RaggedExperiment)
    library(GenomicRanges)
})

## ---- eval = FALSE---------------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install("RaggedExperiment")

## ---- eval = FALSE---------------------------------------------------------
#  library(RaggedExperiment)

## --------------------------------------------------------------------------
sample1 <- GRanges(
    c(A = "chr1:1-10:-", B = "chr1:8-14:+", C = "chr2:15-18:+"),
    score = 3:5)
sample2 <- GRanges(
    c(D = "chr1:1-10:-", E = "chr2:11-18:+"),
    score = 1:2)

## --------------------------------------------------------------------------
colDat <- DataFrame(id = 1:2)

## --------------------------------------------------------------------------
ragexp <- RaggedExperiment(sample1 = sample1,
                           sample2 = sample2,
                           colData = colDat)
ragexp

## --------------------------------------------------------------------------
grl <- GRangesList(sample1 = sample1, sample2 = sample2)
RaggedExperiment(grl, colData = colDat)

## --------------------------------------------------------------------------
rangeList <- list(sample1 = sample1, sample2 = sample2)
RaggedExperiment(rangeList, colData = colDat)

## --------------------------------------------------------------------------
grList <- List(sample1 = sample1, sample2 = sample2)
mcols(grList) <- colDat
RaggedExperiment(grList)

## --------------------------------------------------------------------------
rowRanges(ragexp)

## --------------------------------------------------------------------------
dimnames(ragexp)

## --------------------------------------------------------------------------
colData(ragexp)

## --------------------------------------------------------------------------
dim(ragexp)
Reduce(`*`, dim(ragexp))
sparseAssay(ragexp)
length(sparseAssay(ragexp))

## --------------------------------------------------------------------------
compactAssay(ragexp)

## --------------------------------------------------------------------------
disjoinAssay(ragexp, simplifyDisjoin = mean)

## --------------------------------------------------------------------------
unlist(grl, use.names = FALSE)

## --------------------------------------------------------------------------
rowRanges(ragexp)
assay(ragexp, "score")

## --------------------------------------------------------------------------
(query <- GRanges(c("chr1:1-14:-", "chr2:11-18:+")))

## --------------------------------------------------------------------------
weightedmean <- function(scores, ranges, qranges)
{
    isects <- pintersect(ranges, qranges)
    sum(scores * width(isects)) / sum(width(isects))
}

## --------------------------------------------------------------------------
qreduceAssay(ragexp, query, simplifyReduce = weightedmean)

## ---- echo = FALSE, fig.cap = "RaggedExperiment object schematic. Rows and columns represent genomic ranges and samples, respectively. Assay operations can be performed with (from left to right) compactAssay, qreduceAssay, and sparseAssay.", out.width = "\\maxwidth"----
download.file("https://docs.google.com/feeds/download/drawings/Export?id=1l__7EzJSMKuee8ss4BcS_LKclmJXYhzoWhzpupCLbZI&exportFormat=svg", "RaggedExperiment.svg")
knitr::include_graphics("RaggedExperiment.svg")

## --------------------------------------------------------------------------
sessionInfo()

