


##--------------------------------------------------------
##---------------------------------------------------------

output$checkGOPanel <- renderUI({
  rv$pageGO
  color <- rep("lightgrey",NUM_PAGES_GO)
  
  ##Step 1
  if (rv$pageGO >= 1){
    res <- TRUE
    ifelse(res, color[1] <- "green", color[1] <- "red")
  }
  
  ##Step 2: Choose data ID
  
  if (rv$pageGO >= 2){
    res <- TRUE
    ifelse(res, color[2] <- "green", color[2] <- "red")
    
  }
  
  ## Step 3: Choose quantitative data
  if (rv$pageGO >= 3){
    res <- TRUE
    
    ifelse(res, color[3] <- "green", color[3] <- "red")
    
  }
  
  if (rv$pageGO >= 4){
    res <- TRUE
    ifelse(res, color[4] <- "green", color[4] <- "red")
  }
  
  
  txt <- c("GO setup", "GO classification", "GO enrichment", "Parameter summary")
  buildTable(txt, color)
})

NUM_PAGES_GO <- 4

observe({
  toggleState(id = "prevBtnGO", condition = rv$pageGO > 1)
  toggleState(id = "nextBtnGO", condition = rv$pageGO < NUM_PAGES_GO)
  hide(selector = ".page")
})

navPageGO <- function(direction) {
  rv$pageGO <- rv$pageGO + direction
}

observeEvent(input$prevBtnGO, navPageGO(-1))
observeEvent(input$nextBtnGO, navPageGO(1))

##--------------------------------------------------------
##---------------------------------------------------------



output$GOAnalysisMenu <- renderUI({
    req(rv$current.obj)
   isolate({
    
    # tagList(
    #   uiOutput("GO_setup"),
    #   uiOutput("GO_classif"),
    #   uiOutput("GO_enrich"),
    #   uiOutput("GO_Summary")
    # )
     
     tabsetPanel(
       id = "tabsetPanel_GO",
       tabPanel("GO Setup",uiOutput("GO_setup")),
       tabPanel("GO Classification",uiOutput("GO_classif")),     
       tabPanel("GO Enrichment",uiOutput("GO_enrich")),       
       tabPanel("Parameter summary",uiOutput("GO_Summary"))
     )
                
    
  })
  
})


output$GO_setup <- renderUI({
  #if (rv$pageGO != 1){return()}
  
  tagList(
    tags$div(
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
                radioButtons("sourceOfProtID", "Source of protein ID",
               choices = G_sourceOfProtID_Choices)),
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
                uiOutput("chooseSourceForProtID")),
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
              selectInput("idFrom", "Id From", choices = c("UNIPROT", "ENTREZID")), width="200px"),
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
              modulePopoverUI("modulePopover_GenomeWide"),
              selectInput("Organism", NULL, choices = GetListInstalledOrgdDB()), width="200px"),
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
              selectInput("Ontology", "Ontology",choices = G_ontology_Choices), width="150px")
    ),
  actionButton("mapProtein.GO.button","Map proteins IDs", class = actionBtnClass),
  uiOutput("warnDifferentSizeID"),
  tags$hr(),
  uiOutput("infoIDProt_NA"),
  br(), br(),
  uiOutput("GeneMappedRatio"),
  br(), br(),
  DT::dataTableOutput("nonIdentifiedProteins", width = "80%")
  
)

})

output$GO_classif <- renderUI({
  #if (rv$pageGO != 2){return()}
  
  tagList(
  tags$div(
    tags$div( style="display:inline-block; vertical-align: middle;",
              modulePopoverUI("modulePopover_GOlevel"),
              checkboxGroupInput("GO_level", NULL,choices =c(2:4), selected=2)),
    tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
              actionButton("group.GO.perform.button","Perform GO grouping", class = actionBtnClass))
  ),
  tags$hr(),

  highchartOutput("GOplotGroup_level2",  width = "80%") %>% withSpinner(type=spinnerType),
  highchartOutput("GOplotGroup_level3",  width = "80%") %>% withSpinner(type=spinnerType),
  highchartOutput("GOplotGroup_level4",  width = "80%") %>% withSpinner(type=spinnerType)
  
)
})

output$GO_enrich <- renderUI({
  #if (rv$pageGO != 3){return()}
  
  tagList(
    tags$div(
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
                modulePopoverUI("modulePopover_GOuniverse"),
                radioButtons("universe", NULL, choices = G_universe_Choices)),
      tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
                uiOutput("chooseUniverseFile")),
  # selectInput("PAdjustMethod", "P Adjust Method",choices = G_pAdjustMethod_Choices),
  tags$div( style="display:inline-block; vertical-align: middle; padding-right: 20px;",
            modulePopoverUI("modulePopover_GOfdr"),
            numericInput("pvalueCutoff", NULL, min = 0, max = 1, step = 0.01, value = 0.01, width='100px'))
  ),
  
  actionButton("perform.GO.button","Perform enrichment analysis", class = actionBtnClass),
  tags$hr(),
  highchartOutput("GObarplotEnrich", width = "80%") %>% withSpinner(type=spinnerType),
  highchartOutput("GOdotplotEnrich", width = "80%") %>% withSpinner(type=spinnerType)
)
})

output$GO_Summary <- renderUI({
 # if (rv$pageGO != 4){return()}
  
  DT::dataTableOutput("GO_resumeParams")
})




callModule(modulePopover,"modulePopover_GOlevel", 
           data = reactive(list(title = HTML(paste0("<strong>Level</strong>")), 
                                content="Level")))


callModule(modulePopover,"modulePopover_GOuniverse", 
           data = reactive(list(title = HTML(paste0("<strong>Universe</strong>")), 
                                content="universe")))
callModule(modulePopover,"modulePopover_GOfdr", 
           data = reactive(list(title = HTML(paste0("<strong>FDR</strong>")), 
                                content="BH Adjusted P-value cutoff")))



callModule(modulePopover,"modulePopover_GenomeWide", 
           data = reactive(list(title = HTML(paste0("<strong>Genome Wide Annotation</strong>")), 
                                content=paste0(tags$p("If the expected annotation database is not proposed in the dropdown menu, please find "),
                                               tags$a("here", href = "http://bioconductor.org/packages/release/BiocViews.html#___OrgDb",target="_blank"),
                                               tags$p(" the corresponding package. Then, install it (or have it installed by the administrator of the ProStaR server) and restart ProStaR.")))))



GetListInstalledOrgdDB <- function(){
  l <- installed.packages()[,"Package"]
  l <- l[grep("^org.", l)]
  res <-  list_org_db[l,]$longName
  names(l) <- res
  
  names(l)[which(is.na(names(l)))] <- l[which(is.na(names(l)))]
  
  return(l)
}


GetDataIndexForAnalysis <- reactive({
    req(rv$current.obj)
    
    index <- NULL
    if ("Significant" %in% names(Biobase::fData(rv$current.obj) )){
        index <- which(Biobase::fData(rv$current.obj)$Significant == TRUE)
    }else{
        index <- seq(1:nrow(rv$current.obj))
    }
    
    return(index)
})



output$chooseSourceForProtID <- renderUI({
    req(rv$current.obj)
    input$sourceOfProtID
    
    if (input$sourceOfProtID == "colInDataset"){
        selectInput("UniprotIDCol", "Protein IDs",
                    choices = c("", colnames(Biobase::fData(rv$current.obj))))
    }
    else  if (input$sourceOfProtID == "extFile"){
        fileInput("UNIPROTID_File", "Select file containing protein IDs")
        
    }
})




output$chooseUniverseFile <- renderUI({
    input$universe
    if (input$universe == "Custom"){
        fileInput("UniverseFile", "Universe file")
    }
})



observeEvent(input$UniprotIDCol,ignoreInit =  TRUE,{ 
    if((input$UniprotIDCol == "")) {  rv$GO$ProtIDList <- return (NULL)}
    else {
        rv$GO$ProtIDList <- Biobase::fData(rv$current.obj)[,input$UniprotIDCol]
    }
})


observeEvent(input$UNIPROTID_File,ignoreInit =  TRUE,{ 
    rv$GO$ProtIDList <- read.table(input$UNIPROTID_File$datapath, header = FALSE, stringsAsFactors = FALSE)$V1
})


output$warnDifferentSizeID <- renderUI({
    req(rv$GO$ProtIDList)
     if (length(rv$GO$ProtIDList) != nrow(rv$current.obj)){
        h4("Warning : the protein ID list has not the same number of entites as the dataset.")
        br()
        h4("Please select another list of ID")
    }
})


observeEvent(input$mapProtein.GO.button,ignoreInit =  TRUE,{
    input$UniprotIDCol
    input$Organism
    input$idFrom
    
    if(is.null(input$UniprotIDCol) || (input$UniprotIDCol == "")) {  
        rv$GO$ProtIDList <- NULL
        return (NULL)}
    
    require(clusterProfiler)
    isolate({
        rv$GO$gene <- NULL
        rv$GO$ProtIDList <- Biobase::fData(rv$current.obj)[,input$UniprotIDCol]
        index <- GetDataIndexForAnalysis()
        
        tryCatch({
            
             rv$GO$gene <- bitr(rv$GO$ProtIDList[index], fromType=input$idFrom, toType="ENTREZID", OrgDb=input$Organism)
            rv$GO$proteinsNotMapped <- which((rv$GO$ProtIDList[index] %in% rv$GO$gene[,input$idFrom]) == FALSE)
            rv$GO$ratio <- 100*length(rv$GO$proteinsNotMapped) / length(index)
        }, warning = function(w) {
            rv$GO$gene <- bitr(rv$GO$ProtIDList[index], fromType=input$idFrom, toType="ENTREZID", OrgDb=input$Organism)
            rv$GO$proteinsNotMapped <- which((rv$GO$ProtIDList[index] %in% rv$GO$gene[,input$idFrom]) == FALSE)
            rv$GO$ratio <- 100*length(rv$GO$proteinsNotMapped) / length(index)
            
        }, error = function(e) {
            # shinyjs::info(paste("Perform GO enrichment",":",conditionMessage(e), sep=" "))
            rv$GO$ratio <- 100
        }, finally = {    
        }
        )
        
        
    })
})


##' Reactive behavior : GO analysis of data
##' @author Samuel Wieczorek
observeEvent(input$perform.GO.button,ignoreInit =  TRUE,{
    input$universe
    input$Organism
    input$Ontology
    input$pvalueCutoff
    req(rv$GO$ProtIDList)
    input$idFrom
    rv$GO$uniprotID
    req(input$perform.GO.button)
  req(rv$GO$ratio)
  
    if (rv$GO$ratio == 100){return(NULL)}
    
    require(clusterProfiler)
    

    if (input$universe == "Entire dataset") {
        rv$GO$universeData  <- rv$GO$ProtIDList
    } else if (input$universe == "Entire organism") {
        rv$GO$universeData = DAPAR::univ_AnnotDbPkg(input$Organism)
    } else {
        rv$GO$universeData <- read.table(input$UniverseFile$datapath, header = FALSE, stringsAsFactors = FALSE)
    }
    
    index <- GetDataIndexForAnalysis()
    rv$GO$enrichGO_data <- enrich_GO(rv$GO$ProtIDList[index],
                                  idFrom = input$idFrom, 
                                  orgdb = input$Organism, 
                                  ont = input$Ontology, 
                                  pval = input$pvalueCutoff, 
                                  universe = rv$GO$universeData )
})





observeEvent(input$group.GO.perform.button, ignoreInit =  TRUE,{
    input$Organism
    input$Ontology
    req(rv$GO$ProtIDList)
    rv$GO$uniprotID
    input$idFrom
    input$GO_level
    req(rv$GO$ratio)
    if (rv$GO$ratio == 100){return(NULL)}
    
    levelIndex <- sort(input$GO_level)
    index <- GetDataIndexForAnalysis()
    rv$GO$groupGO_data <- list()
    for (i in 1:length(levelIndex)){
        rv$GO$groupGO_data[[i]] <- list(level = as.numeric(levelIndex[i]),
                                     ggo_res = group_GO(rv$GO$ProtIDList[index],
                                                        idFrom = input$idFrom,
                                                        orgdb = input$Organism,
                                                        ont=input$Ontology,
                                                        level=as.numeric(levelIndex[i])))
    }
    
    
})


##########################################
GOplotGroup_level2 <- reactive({
    req(rv$GO$groupGO_data)
    
    isolate({
        if (length(rv$GO$groupGO_data) >=1){
            barplotGroupGO_HC(rv$GO$groupGO_data[[1]]$ggo_res, 
                              title = paste("Groups at level ", rv$GO$groupGO_data[[1]]$level, sep=""))}
    })
})

##########################################
output$GOplotGroup_level2 <- renderHighchart({
    GOplotGroup_level2()
})


##########################################
GOplotGroup_level3 <- reactive({
    req(rv$GO$groupGO_data)
    
    if ((length(rv$GO$groupGO_data) < 2)){return(NULL)}
    isolate({
        barplotGroupGO_HC(rv$GO$groupGO_data[[2]]$ggo_res, title = paste("Groups at level ",  rv$GO$groupGO_data[[2]]$level))
    })
})


output$GOplotGroup_level3 <- renderHighchart({
    GOplotGroup_level3()
})

GOplotGroup_level4 <- reactive({
    req(rv$GO$groupGO_data)
    
    if ((length(rv$GO$groupGO_data) != 3)){return(NULL)}
    isolate({
            barplotGroupGO_HC(rv$GO$groupGO_data[[3]]$ggo_res, title = paste("Groups at level ",  rv$GO$groupGO_data[[3]]$level))
    })
})


output$GOplotGroup_level4 <- renderHighchart({
    GOplotGroup_level4()
})

GObarplotEnrich <- reactive({
    req(rv$GO$enrichGO_data)
     barplotEnrichGO_HC(rv$GO$enrichGO_data)
   
})

output$GObarplotEnrich <- renderHighchart({
    GObarplotEnrich()
    
})

GOdotplotEnrich <- reactive({
    req(rv$GO$enrichGO_data)
    
    scatterplotEnrichGO_HC(rv$GO$enrichGO_data)
})

output$GOdotplotEnrich <- renderHighchart({
    GOdotplotEnrich()
    
})


output$GODatatable <- renderDataTable({
    req(rv$GO$enrichGO_data)
    req(rv$GO$groupGO_data)
    
    
    dt <- datatable( as.data.frame(rv$GO$groupGO_data@result),
                     extensions = c('Scroller', 'Buttons'),
                     options = list(dom = 'Bfrtip',
                                    initComplete = initComplete(),
                                    displayLength = 20,
                                    deferRender = TRUE,
                                    bLengthChange = FALSE,
                                    scrollX = 400,
                                    scrollY = 600,
                                    scroller = TRUE,
                                    ordering=FALSE,
                                    server = TRUE)
    )
    
    dt
})


output$GeneMappedRatio <- renderUI({
    req(rv$GO$ProtIDList)
    req(rv$current.obj)
    req(rv$GO$gene)
    input$idFrom
    
    req(rv$GO$ratio)
    
    index <- GetDataIndexForAnalysis()
    rv$GO$proteinsNotMapped <- which((rv$GO$ProtIDList[index] %in% rv$GO$gene[,input$idFrom]) == FALSE)
    nProtMapped <- length(rv$GO$proteinsNotMapped)
    nProtTotal <-length(index)
    
    tagList(
        h5(paste(round(rv$GO$ratio, digits=2), " % of the proteins have not been mapped (",nProtMapped," / ",nProtTotal,").", sep="")),
        helpText("These proteins are listed in the table below."),
        if (rv$GO$ratio == 100){
            h3(paste("Tip: You should check the organism which has been selected.", sep=""))
        }
    )
})



output$nonIdentifiedProteins <- renderDataTable({
    req(rv$GO$ProtIDList)
    req(rv$current.obj)
    req(rv$GO$gene)
    input$idFrom
    
    index <- GetDataIndexForAnalysis()
    rv$GO$proteinsNotMapped <- which((rv$GO$ProtIDList[index] %in% rv$GO$gene[,input$idFrom]) == FALSE)
    data <- as.data.frame(fData(rv$current.obj)[index[rv$GO$proteinsNotMapped],])
    
    
    if( nrow(data) != 0){
      
      dt <- datatable( data,
                       extensions = c('Scroller', 'Buttons'),
                       options = list(dom = 'Bfrtip',
                                      initComplete = initComplete(),
                                      displayLength = 20,
                                      deferRender = TRUE,
                                      bLengthChange = FALSE,
                                      scrollX = 400,
                                      scrollY = 600,
                                      scroller = TRUE,
                                      ordering=FALSE,
                                      server = TRUE)
      )
      
      dt
    }
})



output$chooseGOtoSave <- renderUI({
    rv$GO$groupGO_data
    rv$GO$enrichGO_data
    if(is.null(rv$GO$enrichGO_data) && is.null(rv$GO$groupGO_data)){return(NULL)}
    
    .choices <- c()
    if(!is.null(rv$GO$groupGO_data)){.choices <- c(.choices, "Classification")}
    if(!is.null(rv$GO$enrichGO_data)){.choices <- c(.choices, "Enrichment")}
    if(!is.null(rv$GO$enrichGO_data) && !is.null(rv$GO$groupGO_data)){.choices <- c(.choices, "Both")}
    
    radioButtons("whichGO2Save", "GO analysis to save", choices = .choices)
})


## Validation of the GO analysis
observeEvent(input$ValidGOAnalysis,ignoreInit =  TRUE,{ 
    input$Organism
    input$Ontology
    input$pvalueCutoff
    req(rv$current.obj)
    rv$GO$enrichGO_data
    rv$GO$groupGO_data 
    input$universe
    input$whichGO2Save
    
    
    if ((input$ValidGOAnalysis == 0) ||  is.null(input$ValidGOAnalysis) ) {
        return()}
    
    isolate({
        
        result = tryCatch(
            {
                
                
                textGOParams <- paste("Dataset of ",
                                      rv$typeOfDataset,"GO analysis with ",
                                      "organism = ", input$Organism,
                                      "ontology = ", input$Ontology, sep= " ")
                
                
                switch(input$whichGO2Save,
                       Both =
                       {temp <- GOAnalysisSave(rv$dataset[[input$datasets]],
                                               ggo_res = rv$GO$groupGO_data ,
                                               ego_res = rv$GO$enrichGO_data ,
                                               organism = input$Organism,
                                               ontology = input$Ontology,
                                               level = input$GO_level,
                                               pvalueCutoff = input$pvalueCutoff,
                                               typeUniverse = input$universe)},
                       Classification = 
                       {temp <- GOAnalysisSave(rv$dataset[[input$datasets]],
                                               ggo_res = rv$GO$groupGO_data ,
                                               organism = input$Organism,
                                               ontology = input$Ontology,
                                               level = input$GO_level)},
                       
                       Enrichment = 
                       {temp <- GOAnalysisSave(rv$dataset[[input$datasets]],
                                               ego_res = rv$GO$enrichGO_data ,
                                               organism = input$Organism,
                                               ontology = input$Ontology,
                                               pvalueCutoff = input$pvalueCutoff,
                                               typeUniverse = input$universe)}
                       
                )
                
                #name <- paste("GOAnalysis - ", rv$typeOfDataset, sep="")
                #rv$dataset[[name]] <- temp
                #rv$current.obj <- temp
                
                
                #updateSelectInput(session, "datasets", 
                #                 # paste("Dataset versions of", rv$current.obj.name, sep=" "),
                #                  choices = names(rv$dataset),
                #                  selected = name)
                #updateRadioButtons(session, "whichGO2Save",selected = input$whichGO2Save)
                
                # 
                # ####write command Log file
                # writeToCommandLogFile(paste("cond1 <- '", input$condition1, "'", sep=""))
                # writeToCommandLogFile(paste("cond2 <- '", input$condition2, "'", sep=""))
                # writeToCommandLogFile(paste("method <- '", input$diffAnaMethod, "'", sep=""))
                # if (input$diffAnaMethod == "Limma"){
                #     writeToCommandLogFile("data <- wrapper.diffAnaLimma(current.obj, cond1, cond2)")
                # } else if (input$diffAnaMethod == "Welch"){
                #     writeToCommandLogFile( "data <- wrapper.diffAnaWelch(current.obj, cond1, cond2)")
                # }
                # 
                # 
                # writeToCommandLogFile(paste("threshold_pValue <- ", input$seuilPVal, sep=""))
                # writeToCommandLogFile(paste("threshold_logFC <- ", input$seuilLogFC,sep=""))
                # 
                # writeToCommandLogFile(paste("calibMethod <- \"", input$calibrationMethod, "\"", sep=""))
                # if (input$calibrationMethod == "Benjamini-Hochberg") { 
                #     writeToCommandLogFile("m <- 1") }
                # else if (input$calibrationMethod == "numeric value") 
                # { writeToCommandLogFile(paste(" m <- ",as.numeric(input$numericValCalibration), sep=""))}
                # else {writeToCommandLogFile("m <- calibMethod")}
                # 
                # writeToCommandLogFile("fdr <- diffAnaComputeFDR(data, threshold_pValue, threshold_logFC, m)")
                # 
                # 
                # writeToCommandLogFile(paste(" temp <- diffAnaSave(dataset[['",
                #                             input$datasets,"']],  data, method, cond1, cond2, threshold_pValue, threshold_logFC, fdr, calibMethod)", sep=""))
                # writeToCommandLogFile(paste(" name <- \"DiffAnalysis.", 
                #                             input$diffAnaMethod, ".", rv$typeOfDataset,"\"", sep="" ))
                # writeToCommandLogFile("dataset[[name]] <- temp")
                # writeToCommandLogFile("current.obj <- temp")
                # 
                # 
                # 
                # cMethod <- NULL
                # if (input$calibrationMethod == "numeric value"){
                #     cMethod <- paste("The proportion of true null
                #                      hypotheses was set to", 
                #                      input$numericValCalibration, sep= " ")}
                # else {cMethod <-input$calibrationMethod }
                # 
                
                text2Log <- NULL
                
                switch(input$whichGO2Save,
                       Both =
                       {
                           
                           text2Log <- paste(
                               "ProtIDList <- Biobase::fData(current.obj)[,\"",input$UniprotIDCol,"]\"\n",
                               "levelIndex <- sort(",input$GO_level,") \n",
                               
                               "index <- NULL\n",
                               "if (\"Significant.Welch\" %in% names(Biobase::fData(current.obj) )){\n",
                               "index <- which(Biobase::fData(current.obj)$Significant.Welch == TRUE)\n",
                               "} else if (\"Significant.limma\" %in% names(Biobase::fData(current.obj) )){",
                               "index <- which(Biobase::fData(current.obj)$Significant.limma == TRUE)\n",
                               "} else{ index <- seq(1:nrow(current.obj))}\n",
                               "groupGO_data <- list()\n",
                               "for (i in 1:length(levelIndex)){\n",
                               "groupGO_data[[i]] <- list(level = as.numeric(levelIndex[i]),\n",
                               "ggo_res = group_GO(ProtIDList[index],\n",
                               "\"",input$idFrom,"\", 
                               \"ENTREZID\", \n",
                               "orgdb = \"",input$Organism,"\",\n", 
                               "ont=",input$Ontology,",\n", 
                               "level=as.numeric(levelIndex[i]))) }\n",
                               # index <- GetDataIndexForAnalysis()
                               # rv$enrichGO_data <- enrich_GO(rv$ProtIDList[index],
                               #                               idFrom = input$idFrom, 
                               #                               idTo = "ENTREZID", 
                               #                               orgdb = input$Organism, 
                               #                               ont = input$Ontology, 
                               #                               #pAdj = input$PAdjustMethod, 
                               #                               pval = input$pvalueCutoff, 
                               #                               universe = rv$universeData )
                               # 
                               
                               
                               "temp <- GOAnalysisSave(dataset[[datasets]],ggo_res = groupGO_data ,
                               ego_res = enrichGO_data ,
                               organism = \"",input$Organism,"\",ontology = \"", input$Ontology,"\",\n",
                               "level = ", input$GO_level,", pvalueCutoff = ", input$pvalueCutoff,",\n",
                               "typeUniverse = \"", input$universe,"\")\n",
                               " name <- \"GOAnalysis", ".", rv$typeOfDataset,"\"",
                               "dataset[[name]] <- temp\n",
                               "current.obj <- temp\n", sep= " ")
                           # writeToCommandLogFile(text2Log)
                       }
                )
                
                updateTabsetPanel(session, "tabsetPanel_GO", selected = "tabPanelSaveGO")
                
                
                
            }
            #, warning = function(w) {
            #    shinyjs::info(conditionMessage(w))
            #}
            , error = function(e) {
                shinyjs::info(paste("Valid GO Analysis",":",
                                    conditionMessage(e), sep=" "))
            }, finally = {
                #cleanup-code 
            })
        
        
        
    }) 
    
})




output$GO_resumeParams <- DT::renderDataTable({
  req(c(rv$current.obj,input$selectComparison,
        as.numeric(input$seuilPVal),as.character(input$AnaDiff_ChooseFilters),input$calibrationMethod))
  rv$resAnaDiff
  req(rv$res_AllPairwiseComparisons)
  
  l.params <- data.frame(param="sourceOfProtID", value=input$sourceOfProtID)
  
  l.params <- rbind(l.params,data.frame(param="idFrom", value=as.character(input$idFrom)))
  l.params <- rbind(l.params,data.frame(param="Organism", value=input$Organism))
  l.params <- rbind(l.params,data.frame(param="Ontology", value=input$Ontology))
  
  
 
  
  DT::datatable(l.params,
                escape = FALSE,
                rownames=FALSE,
                extensions = c('Scroller', 'Buttons'),
                options = list(initComplete = initComplete(),
                               dom = 'Brt',
                               buttons = c('copy','excel', 'pdf', 'print'),
                               columnDefs = list(list(width='200px',targets= "_all")),
                               ordering = FALSE)
  )
  #}
})

