## ----style, eval=TRUE, echo=FALSE, results="asis"--------------------------
BiocStyle::latex()

## ----loading, fig.width=6, fig.height=6, echo=TRUE-------------------------
library(Pigengene)
data(aml)
data(mds)
d1 <- rbind(aml,mds)
Labels <- c(rep("AML",nrow(aml)),rep("MDS",nrow(mds)))
names(Labels) <- rownames(d1)
Disease <- as.data.frame(Labels)
h1 <- pheatmap.type(d1[,1:20],annRow=Disease,show_rownames=FALSE)

## ----oneStep, echo=TRUE----------------------------------------------------
p1 <- one.step.pigengene(Data=d1,saveDir='pigengene', bnNum=0, verbose=1,
      seed=1, Labels=Labels, toCompact=FALSE, doHeat=FALSE)

## ----tree, fig.width=5, fig.height=5, echo=TRUE----------------------------
plot(p1$c5treeRes$c5Trees[["34"]])

## ----pigengene, fig.width=5, fig.height=5, echo=TRUE-----------------------
dim(p1$pigengene$eigengenes)
p1 <- pheatmap.type(p1$pigengene$eigengenes,annRow=Disease,show_rownames=FALSE)



## ----citation, results='asis', eval=TRUE-----------------------------------
citation("Pigengene")

## ----sessionInfo, results='asis', eval=TRUE--------------------------------
toLatex(sessionInfo())

