## ----load_libraries, message=FALSE-----------------------------------------
library(MultiDataSet)
library(Biobase)
library(minfi)

## ----create_data, echo=FALSE, eval=TRUE, message=FALSE---------------------
library(brgedata)
data("brge_gexp") # Get the ExpressionSet from brgedata 
gSet1 <- brge_gexp[sample(1:21916, 300), 1:50]   # Create ExpressionSet with samples from 01 to 50
gSet2 <- brge_gexp[sample(1:21916, 300), 35:61]  # Create ExpressionSet with samples from 35 to 64

data("brge_methy")
mSet <- brge_methy[sample(1:40000, 300),]

# setwd("/home/chernandez/Projects/multidataset/Tutorials/")
save(gSet1, gSet2, file="expression.RData")
save(mSet, file="methylation.RData")

## ----load_data-------------------------------------------------------------
load("expression.RData")
load("methylation.RData")
ls()

## ----common_samples_1------------------------------------------------------
## gSet1 intersection gSet2
length(intersect(sampleNames(gSet1), sampleNames(gSet2)))

## gSet1 intersection mSet
length(intersect(sampleNames(gSet1), sampleNames(mSet)))

## gSet2 intersection mSet
length(intersect(sampleNames(gSet2), sampleNames(mSet)))

## ----common_samples_2------------------------------------------------------
## gSet1 intersection gSet2 intersection mSet
length(intersect(intersect(
	sampleNames(gSet1), sampleNames(gSet2)), sampleNames(mSet)))

## ----create_multidataset_1-------------------------------------------------
md <- createMultiDataSet()
md

## ----add_element_1, warning=FALSE------------------------------------------
md.e <- add_genexp(md, gSet1)
md.e

## ----add_element_error, warning=FALSE, error=TRUE--------------------------
md.e <- add_genexp(md.e, gSet2)

## ----rm_mde, include=FALSE-------------------------------------------------
rm(md.e)

## ----add_element_2, warning=FALSE------------------------------------------
md <- add_genexp(md, gSet1, dataset.name = "gSet1")
md <- add_genexp(md, gSet2, dataset.name = "gSet2")
md

## ----add_element_3, warning=FALSE------------------------------------------
md <- add_methy(md, mSet)
md

## ----n_sets----------------------------------------------------------------
length(md)
names(md)

## ----load_omicade4, message=FALSE------------------------------------------
library(omicade4)

## ----list_three_sets, error=TRUE, warning=FALSE----------------------------
dat <- list(
  assayDataElement(gSet1, "exprs"),
  assayDataElement(gSet2, "exprs"),
  assay(mSet, "Beta")
)

## ----mcia_three_sets, error=TRUE, warning=FALSE----------------------------
fit <- mcia(dat)

## ----mcia_dim_common_mds---------------------------------------------------
md.r <- commonSamples(md)

## ----veryfi_dim------------------------------------------------------------
lapply(as.list(md.r), dim)

## ----mcia_mds--------------------------------------------------------------
fit <- mcia(as.list(md.r))

## ----mcia_mds_wrapper------------------------------------------------------
fit <- w_mcia(md)

## ----mcia_output-----------------------------------------------------------
fit

## ----load_iclusterplus, message=FALSE--------------------------------------
library(iClusterPlus)

## ----iclusterplus_three_datasets, error=TRUE, cache=TRUE-------------------
fit <- iClusterPlus(
	dt1 = assayDataElement(gSet1, "exprs"),
	dt2 = assayDataElement(gSet2, "exprs"),
	dt3 = assay(mSet, "Beta"),
	type = c("gaussian", "gaussian", "gaussian"),
	lambda = c(0.04,0.61,0.90),
	K = 3,
	maxiter = 10
)

## ---- iclusterplus_mds_wrapper---------------------------------------------
fit <- w_iclusterplus(
  md,
  lambda = c(0.04,0.61,0.90),
  K = 3,
  maxiter = 10
)

## ----iclusterplus_show, message=FALSE, warning=FALSE-----------------------
library(lattice) # Required for iClusterPlus's plotHeatmap
library(gplots) # Required to generate the colour-schemes

col.scheme <- alist()
col.scheme[[1]] <- bluered(256) # colours for gSet1
col.scheme[[2]] <- bluered(256) # colours for gSet2
col.scheme[[3]] <- greenred(256) # colours for mSet

plotHeatmap(fit=fit,datasets=lapply(as.list(commonSamples(md)), t),
  type=c("gaussian","gaussian","gaussian"), col.scheme = col.scheme,
  row.order=c(TRUE,TRUE,TRUE),sparse=c(TRUE,FALSE,TRUE),cap=c(FALSE,FALSE,FALSE)
)

## ---- eval=FALSE-----------------------------------------------------------
#  setMethod(
#      f = "w_mcia",
#      signature = "MultiDataSet",
#      definition = function(object, ...) {
#          # Obtain the common samples between datasets
#          object <- commonSamples(object)
#  
#          # Call mcia with the generated arguments and the user's arguments
#          omicade4::mcia(as_list(object), ...)
#      }
#  )

## ---- eval=FALSE-----------------------------------------------------------
#  setMethod(
#      f = "w_iclusterplus",
#      signature = "MultiDataSet",
#      definition = function(object, commonSamples=TRUE, ...) {
#          if(length(object) > 4) {
#              stop("'iClusterPlus' only allows four datasets.")
#          }
#  
#          # Obtain the common samples between datasets
#          if(commonSamples) {
#              object <- commonSamples(object)
#          }
#  
#          # Put the names iClusterPlus requires on the datasets
#          datasets <- lapply(as.list(object), t)
#          names(datasets) <- paste("dt", 1:length(datasets), sep="")
#  
#          # Generate the "type" argument for iClusterPlus
#          datasets[["type"]] <- sapply(names(object), function(nm) {
#              ifelse(startsWith(nm, "expression"), "gaussian",
#                     ifelse(startsWith(nm, "methylation"), "gaussian", "multinomial"))
#          })
#          names(datasets[["type"]]) <- paste("dt", 1:(length(datasets) -1), sep="")
#  
#          # Call iClusterPlus with the generated arguments and the user's arguments
#          do.call("iClusterPlus", c(datasets, list(...)))
#      }
#  )

