/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.bio.seq.projection.ProjectionEngine;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public class ReparentContext
implements ProjectionContext,
Serializable {
    private final transient Map forwardersByFeature = new HashMap();
    private final FeatureHolder parent;
    private final FeatureHolder wrapped;

    public ReparentContext(FeatureHolder parent, FeatureHolder wrapped) {
        this.parent = parent;
        this.wrapped = wrapped;
    }

    public final FeatureHolder getParent() {
        return this.parent;
    }

    public final FeatureHolder getUnprojectedFeatures() {
        return this.wrapped;
    }

    public Feature projectFeature(Feature feat) {
        return ProjectionEngine.DEFAULT.projectFeature(feat, this);
    }

    public Feature revertFeature(Feature feat) {
        return ((Projection)((Object)feat)).getViewedFeature();
    }

    public final FeatureFilter projectFilter(FeatureFilter ff) {
        return FilterUtils.transformFilter(ff, this.getTransformer());
    }

    public final FeatureFilter revertFilter(FeatureFilter ff) {
        return FilterUtils.transformFilter(ff, this.getReverter());
    }

    protected FilterUtils.FilterTransformer getTransformer() {
        return new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                return ff;
            }
        };
    }

    protected FilterUtils.FilterTransformer getReverter() {
        return new FilterUtils.FilterTransformer(){

            public FeatureFilter transform(FeatureFilter ff) {
                return ff;
            }
        };
    }

    public final FeatureHolder getParent(Feature f) {
        FeatureHolder oldP = f.getParent();
        if (oldP instanceof Feature) {
            if (this.wrapped.containsFeature(f)) {
                return this.parent;
            }
            return this.projectFeature((Feature)oldP);
        }
        return this.parent;
    }

    public final Sequence getSequence(Feature f) {
        FeatureHolder fh = this.getParent();
        while (fh instanceof Feature) {
            fh = ((Feature)fh).getParent();
        }
        if (!(fh instanceof Sequence)) {
            throw new BioRuntimeException("Chasing up parents to get sequence: actually hit: " + fh.toString());
        }
        return (Sequence)fh;
    }

    public FeatureHolder projectChildFeatures(Feature f, FeatureHolder parent) {
        return new ProjectionSet(f);
    }

    public final Feature createFeature(Feature.Template projTempl) throws BioException, ChangeVetoException {
        return this.projectFeature(this.wrapped.createFeature(ProjectionEngine.DEFAULT.revertTemplate(projTempl, this)));
    }

    public final void removeFeature(Feature dyingChild) throws BioException, ChangeVetoException {
        this.wrapped.removeFeature(this.revertFeature(dyingChild));
    }

    public final Feature createFeature(Feature f, Feature.Template projTempl) throws BioException, ChangeVetoException {
        return this.projectFeature(this.revertFeature(f).createFeature(ProjectionEngine.DEFAULT.revertTemplate(projTempl, this)));
    }

    public final void removeFeature(Feature f, Feature f2) throws ChangeVetoException, BioException {
        this.revertFeature(f).removeFeature(this.revertFeature(f2));
    }

    public final FeatureFilter getSchema(Feature f) {
        return this.projectFilter(f.getSchema());
    }

    public final void addChangeListener(Feature f, ChangeListener cl, ChangeType ct) {
        if (!f.isUnchanging(ct)) {
            PFChangeForwarder forwarder = (PFChangeForwarder)this.forwardersByFeature.get(f);
            if (forwarder == null) {
                forwarder = new PFChangeForwarder(f);
                this.forwardersByFeature.put(f, forwarder);
                f.addChangeListener(forwarder, ChangeType.UNKNOWN);
            }
            forwarder.addChangeListener(cl, ct);
        }
    }

    public final void removeChangeListener(Feature f, ChangeListener cl, ChangeType ct) {
        PFChangeForwarder forwarder = (PFChangeForwarder)this.forwardersByFeature.get(f);
        if (forwarder != null) {
            forwarder.removeChangeListener(cl, ct);
            if (!forwarder.hasListeners()) {
                this.forwardersByFeature.remove(f);
                f.removeChangeListener(forwarder, ChangeType.UNKNOWN);
            }
        }
    }

    public final FeatureHolder projectFeatures(FeatureHolder fh) {
        return new ProjectionSet(fh);
    }

    private class PFChangeForwarder
    extends ChangeSupport
    implements ChangeListener {
        private Feature master;

        public PFChangeForwarder(Feature master) {
            super(1);
            this.master = master;
        }

        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ChangeEvent cev2 = this.forwardFeatureChangeEvent(this.master, cev);
            if (cev2 != null) {
                this.firePreChangeEvent(cev2);
            }
        }

        public void postChange(ChangeEvent cev) {
            ChangeEvent cev2 = this.forwardFeatureChangeEvent(this.master, cev);
            if (cev2 != null) {
                this.firePostChangeEvent(cev2);
            }
        }

        protected ChangeEvent forwardFeatureChangeEvent(Feature f, ChangeEvent cev) {
            return new ChangeEvent(ReparentContext.this.projectFeature(f), cev.getType(), cev.getChange(), cev.getPrevious(), cev);
        }
    }

    private class ProjectionSet
    extends Unchangeable
    implements FeatureHolder,
    Serializable {
        private final FeatureHolder baseSet;

        ProjectionSet(FeatureHolder baseSet) {
            this.baseSet = baseSet;
        }

        public int countFeatures() {
            return this.baseSet.countFeatures();
        }

        public Iterator features() {
            final Iterator wrappedIterator = this.baseSet.features();
            return new Iterator(){

                public boolean hasNext() {
                    return wrappedIterator.hasNext();
                }

                public Object next() {
                    return ReparentContext.this.projectFeature((Feature)wrappedIterator.next());
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean containsFeature(Feature f) {
            if (!(f instanceof Projection)) {
                return false;
            }
            Projection p = (Projection)((Object)f);
            return p.getProjectionContext() == ReparentContext.this && this.baseSet.containsFeature(p.getViewedFeature());
        }

        public FeatureHolder filter(FeatureFilter ff) {
            return this.filter(ff, true);
        }

        public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
            ff = ReparentContext.this.revertFilter(ff);
            FeatureHolder toProject = this.baseSet.filter(ff, recurse);
            return new ProjectionSet(toProject);
        }

        public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
            throw new ChangeVetoException("Can't create features in this projection");
        }

        public void removeFeature(Feature toDie) throws ChangeVetoException, BioException {
            throw new ChangeVetoException("Can't remove features in this projection");
        }

        public FeatureFilter getSchema() {
            return ReparentContext.this.projectFilter(this.baseSet.getSchema());
        }
    }
}

