/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.CytoscapeSessionReader;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.lang.reflect.Method;
import java.util.Set;
import junit.framework.TestCase;

public class CytoscapeSessionReaderTest
extends TestCase {
    private void invokeReader(String file) throws Exception {
        Cytoscape.buildOntologyServer();
        CytoscapeSessionReader sr = new CytoscapeSessionReader(file, null);
        Class<?> cls = sr.getClass();
        Method method = cls.getDeclaredMethod("unzipSessionFromURL", Boolean.TYPE);
        method.setAccessible(true);
        Object ret = method.invoke((Object)sr, false);
    }

    public void testNestedNetworkReconstruction1() throws Exception {
        this.invokeReader("testData/NNFData/t3.cys");
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        GraphPerspective targetNet = null;
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals("Module_Overview")) continue;
            targetNet = net;
        }
        CytoscapeSessionReaderTest.assertNotNull(targetNet);
        CytoscapeSessionReaderTest.assertEquals(4, targetNet.getNodeCount());
        CytoscapeSessionReaderTest.assertEquals(5, targetNet.getEdgeCount());
        CyNode m1 = Cytoscape.getCyNode("M1");
        CytoscapeSessionReaderTest.assertNotNull(m1);
        CyNode m1InOverview = (CyNode)targetNet.getNode(m1.getRootGraphIndex());
        CytoscapeSessionReaderTest.assertNotNull(m1InOverview);
        CytoscapeSessionReaderTest.assertTrue(m1InOverview.getIdentifier().equals("M1"));
        CytoscapeSessionReaderTest.assertNotNull(m1InOverview.getNestedNetwork());
        CytoscapeSessionReaderTest.assertTrue(m1InOverview.getNestedNetwork() instanceof CyNetwork);
        CytoscapeSessionReaderTest.assertTrue(((CyNetwork)m1InOverview.getNestedNetwork()).getTitle().equals("M1"));
    }

    public void testNestedNetworkReconstruction2() throws Exception {
        this.invokeReader("testData/NNFData/t4.cys");
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        GraphPerspective targetNet = null;
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals("Top_Level_Network")) continue;
            targetNet = net;
        }
        CytoscapeSessionReaderTest.assertNotNull(targetNet);
        CytoscapeSessionReaderTest.assertEquals(7, targetNet.getNodeCount());
        CytoscapeSessionReaderTest.assertEquals(5, targetNet.getEdgeCount());
        CyNode m3 = Cytoscape.getCyNode("M3");
        CytoscapeSessionReaderTest.assertNotNull(m3);
        Node m3InOverview = targetNet.getNode(m3.getRootGraphIndex());
        CytoscapeSessionReaderTest.assertNotNull(m3InOverview);
        CyNetwork nestedNetwork = (CyNetwork)m3InOverview.getNestedNetwork();
        CytoscapeSessionReaderTest.assertNotNull(nestedNetwork);
        CytoscapeSessionReaderTest.assertTrue(nestedNetwork.getTitle().equals("M3"));
        CytoscapeSessionReaderTest.assertEquals(4, nestedNetwork.getNodeCount());
        CytoscapeSessionReaderTest.assertEquals(3, nestedNetwork.getEdgeCount());
        CyNode m2 = (CyNode)nestedNetwork.getNode(Cytoscape.getCyNode("M2").getRootGraphIndex());
        CytoscapeSessionReaderTest.assertNotNull(m2);
        CytoscapeSessionReaderTest.assertNotNull(m2.getNestedNetwork());
        CytoscapeSessionReaderTest.assertNotNull(m2.getNestedNetwork().getNode(Cytoscape.getCyNode("D").getRootGraphIndex()));
        CyAttributes nodeAttr = Cytoscape.getNodeAttributes();
        CytoscapeSessionReaderTest.assertTrue(nodeAttr.getStringAttribute("M1", "nested_network_id").equals("M1"));
        CytoscapeSessionReaderTest.assertTrue(nodeAttr.getStringAttribute("M2", "nested_network_id").equals("M2"));
        CytoscapeSessionReaderTest.assertTrue(nodeAttr.getStringAttribute("M3", "nested_network_id").equals("M3"));
        CytoscapeSessionReaderTest.assertNull(nodeAttr.getStringAttribute("M4", "nested_network_id"));
        CytoscapeSessionReaderTest.assertNull(nodeAttr.getStringAttribute("A", "nested_network_id"));
        CytoscapeSessionReaderTest.assertNull(nodeAttr.getStringAttribute("B", "nested_network_id"));
        CytoscapeSessionReaderTest.assertNull(nodeAttr.getStringAttribute("C", "nested_network_id"));
        CytoscapeSessionReaderTest.assertNull(nodeAttr.getStringAttribute("D", "nested_network_id"));
    }
}

