## ----libraryLoad, message=FALSE, warning=FALSE-----------------------------
library(ENCODExplorer)

## ----load_encodeDF, collapse=TRUE------------------------------------------
encode_df <- get_encode_df()

## ----query_results, collapse=TRUE, eval =T---------------------------------
query_results <- queryEncode(organism = "Homo sapiens", 
                      biosample_name = "MCF-7", file_format = "fastq",
                      fixed = TRUE)

## ----query_results_2, collapse=TRUE----------------------------------------
query_results <- queryEncode(organism = "Homo sapiens", biosample_name = "mcf7",
                        file_format = "fastq", fixed = TRUE,
                       fuzzy = FALSE)

## ----query_results_3, collapse=TRUE----------------------------------------
query_results <- queryEncode(organism = "Homo sapiens",
                    biosample_name = "mcf7", file_format = "fastq", fixed = TRUE,
                    fuzzy = TRUE)

## ----query_results_4, collapse=TRUE----------------------------------------
query_results <- queryEncode(assay = ".*RNA-seq",
                    biosample_name = "HeLa-S3", fixed = FALSE)
table(query_results$assay)

## ----query_results_5, collapse=TRUE----------------------------------------
query_results <- queryEncodeGeneric(biosample_name="HeLa-S3",
				    assay="RNA-seq", submitted_by="Diane Trout",
				    fuzzy=TRUE)
table(query_results$submitted_by)

## ----fuzzy_results, collapse=TRUE------------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca"))

## ----fuzzy_results_2, collapse=TRUE----------------------------------------
fuzzy_results <- fuzzySearch(searchTerm = c("brca", "ZNF24"),
                             filterVector = c("target"),
                             multipleTerm = TRUE)

## ----search_results, collapse=TRUE-----------------------------------------
  search_results <- searchEncode(searchTerm = "a549 chip-seq homo sapiens",
                                 limit = "all")

## ----query_results_6, collapse=TRUE----------------------------------------
query_results <- queryEncode(assay = "switchgear", target ="elavl1", fixed = FALSE)

## ----search_results_1, collapse=TRUE---------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----query_results_7, collapse=TRUE, eval=FALSE----------------------------
#  query_results <- queryEncode(assay = "switchgear", target ="elavl1",
#                               file_format = "bed" , fixed = FALSE)
#  downloadEncode(query_results)

## ----collapse=TRUE, eval=FALSE---------------------------------------------
#  downloadEncode(search_results, format = "bed")

## ----search_results_2, collapse=TRUE---------------------------------------
search_results <- searchEncode(searchTerm = "switchgear elavl1", limit = "all")

## ----convert_results_1, collapse=TRUE--------------------------------------
convert_results <- searchToquery(searchResults = search_results)

## ----ah, message=FALSE-----------------------------------------------------
require(AnnotationHub)
ah = AnnotationHub()
query(ah, "ENCODExplorerData")

