## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, results = "markup", message = FALSE, warning = FALSE)

## ------------------------------------------------------------------------
library(flowWorkspace)
library(CytoML)
acs <- system.file("extdata/cytobank_experiment.acs", package = "CytoML")

## ------------------------------------------------------------------------
ce <- cytobankExperiment(acs)
ce

## ------------------------------------------------------------------------
sampleNames(ce)
colnames(ce)
markernames(ce)
pData(ce)

## ------------------------------------------------------------------------
gs <- cytobank2GatingSet(ce)

## ---- eval=FALSE---------------------------------------------------------
#  xmlfile <- ce$gatingML
#  fcsFiles <- list.files(ce$fcsdir, full.names = TRUE)
#  gs <- cytobank2GatingSet(xmlfile, fcsFiles)

## ------------------------------------------------------------------------
library(ggcyto)
## Plot the gates
autoplot(gs[[1]])
# Extract the population statistics
getPopStats(gs, statType = "count")

