## ---- include = FALSE------------------------------------------------------
library(CellBench)
library(purrr)

## --------------------------------------------------------------------------
# generic skeleton for a wrapper
wrapper <- function(sce, ...) {
    stopifnot(is(sce, "SingleCellExperiment"))
    
    res <- method_function(sce, ...)
    
    return(res)
}

## --------------------------------------------------------------------------
# one possible wrapper implmentation
drimpute_wrapper <- function(expr, ...) {
    # wrapper only accepts SingleCellExperiment or matrix type objects
    stopifnot(
        is(expr, "SingleCellExperiment") ||
        is(expr, "matrix")
    )

    if (is(expr, "SingleCellExperiment")) {
        expr <- SingleCellExperiment::normcounts(expr)
    }

    expr_processed <- DrImpute::preprocessSC(expr)
    count_mat <- DrImpute::DrImpute(expr_processed, ...)

    return(count_mat)
}

## --------------------------------------------------------------------------
# another possible implementation
# DrImpute's default ks is 10:15, we can use 5:15 for robustness
drimpute_wrapper <- function(expr, ks = 5:15, method = c("mean", "med")) {
    stopifnot(
        is(expr, "SingleCellExperiment") ||
        is(expr, "matrix")
    )

    if (is(expr, "SingleCellExperiment")) {
        expr <- SingleCellExperiment::normcounts(expr)
    }

    expr_processed <- DrImpute::preprocessSC(expr)
    
    method <- match.arg(method)
    count_mat <- DrImpute::DrImpute(expr_processed, ks = ks, method = method)

    return(count_mat)
}

## --------------------------------------------------------------------------
imputation_method <- fn_list(
    dr_impute_mean = purrr::partial(drimpute_wrapper, method = "mean"),
    dr_impute_median = purrr::partial(drimpute_wrapper, method = "med")
)

