## ---- eval=FALSE, message=FALSE, warning=FALSE-----------------------------
#  library(LOLA)
#  library(COCOA)

## ---- eval=FALSE, message=FALSE, warning=FALSE-----------------------------
#  # the genomic coordinates
#  signalCoord <- methylData$coordinates
#  # consider whether centering or scaling is needed
#  mPCA <- prcomp(x=t(methylData$methylProp), center=TRUE, scale.=FALSE)

## ---- eval=FALSE, message=FALSE, warning=FALSE-----------------------------
#  # reading in the region sets
#  # load LOLA database
#  lolaPath <- paste0("path/to/LOLACore/genomeVersion/")
#  regionSetDB <- loadRegionDB(lolaPath)
#  
#  # metadata about the region sets
#  loRegionAnno <- regionSetDB$regionAnno
#  lolaCoreRegionAnno <- loRegionAnno
#  collections <- c("cistrome_cistrome", "cistrome_epigenome", "codex",
#                  "encode_segmentation", "encode_tfbs", "ucsc_features")
#  collectionInd <- lolaCoreRegionAnno$collection %in% collections
#  lolaCoreRegionAnno <- lolaCoreRegionAnno[collectionInd, ]
#  regionSetName <- lolaCoreRegionAnno$filename
#  regionSetDescription <- lolaCoreRegionAnno$description
#  
#  # the actual region sets
#  GRList <- GRangesList(regionSetDB$regionGRL[collectionInd])
#  
#  # since we have what we need, we can delete this to free up memory
#  rm("regionSetDB")

## ---- eval=FALSE, message=FALSE, warning=FALSE-----------------------------
#  PCsToAnnotate <- paste0("PC", 1:6)
#  regionSetScores <- runCOCOA(loadingMat=mPCA$rotation,
#                              signalCoord=signalCoord,
#                              GRList=GRList,
#                              PCsToAnnotate=PCsToAnnotate,
#                              scoringMetric="regionMean")
#  regionSetScores$regionSetName <- regionSetName
#  regionSetScores$regionSetDescription <- regionSetDescription

## ---- eval=FALSE, message=FALSE, warning=FALSE-----------------------------
#  View(regionSetScores[order(regionSetScores$PC1, decreasing=TRUE), ])
#  View(regionSetScores[order(regionSetScores$PC2, decreasing=TRUE), ])
#  # etc.

