## --------------------------------------------------------------------------
library(CATALYST)
data(raw_data)
ff <- concatFCS(raw_data)

## ----eval=FALSE------------------------------------------------------------
#  normCytof(x=ff, y="dvs", k=80, plot=FALSE)

## --------------------------------------------------------------------------
data(sample_ff)
sample_ff

## --------------------------------------------------------------------------
data(sample_key)
head(sample_key)

## ----messages=FALSE--------------------------------------------------------
re0 <- assignPrelim(x=sample_ff, y=sample_key, verbose=FALSE)
re0

## --------------------------------------------------------------------------
# estimate separation cutoffs
re <- estCutoffs(x=re0)

## ----results = 'hide'------------------------------------------------------
# use global separation cutoff
applyCutoffs(x=re, sep_cutoffs=0.35)

# use population-specific cutoffs
re <- applyCutoffs(x=re)

## ----results='hide', message=FALSE-----------------------------------------
outFCS(x=re, y=sample_ff)

## ----eval=FALSE------------------------------------------------------------
#  plotYields(x=re, which=c("C1", 0), plotly=FALSE)

## ----echo=FALSE, fig.width=8, fig.height=4.5-------------------------------
ps <- plotYields(x=re, which=c("C1", 0), plotly=FALSE)
for (i in seq_along(ps)) assign(sprintf("p%s", i), ps[[i]])
p1; p2

## ----fig.width=8, fig.height=4---------------------------------------------
# event plots for unassigned events
# & barcode population D1
plotEvents(x=re, which=c(0, "D1"), n_events=25)

## ----warning=FALSE, fig.width=6, fig.height=6.5----------------------------
plotMahal(x=re, which="B3")

## --------------------------------------------------------------------------
# get single-stained control samples
data(ss_exp)
# specify mass channels stained for
bc_ms <- c(139, 141:156, 158:176)
# debarcode
re <- assignPrelim(x=ss_exp, y=bc_ms, verbose=FALSE)
re <- estCutoffs(x=re)
re <- applyCutoffs(x=re)
# compute spillover matrix
spillMat <- computeSpillmat(x=re)

## ----fig.width=7, fig.height=7---------------------------------------------
plotSpillmat(bc_ms=bc_ms, SM=spillMat, plotly=FALSE) 

## ---- message=FALSE--------------------------------------------------------
data(mp_cells)
comped_flow <- compCytof(x=mp_cells, y=spillMat, method="flow")
comped_nnls <- compCytof(x=mp_cells, y=spillMat, method="nnls")

## ----echo=FALSE, message=FALSE, results='hide'-----------------------------
cf <- 20
cells_t <- asinh(exprs(mp_cells)/cf)
comped_flow_t <- asinh(exprs(comped_flow)/cf)
comped_nnls_t <- asinh(exprs(comped_nnls)/cf)

## ----echo=FALSE, fig.width=8.6, fig.height=3.2-----------------------------
par(mfrow=c(1,3))
which <- c("Er167Di", "Er168Di")
cols <- colorRampPalette(rev(RColorBrewer::brewer.pal(10, "Spectral")))
bw <- .2; n <- 100
smoothScatter(cells_t[, which],       nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Uncompensated')
smoothScatter(comped_flow_t[, which], nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='Flow compensated')
smoothScatter(comped_nnls_t[, which], nrpoints=0, nbin=n, bandwidth=bw, colramp=cols, main='NNLS compensated')

