/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import edu.rit.swing.Displayable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class DisplayablePanel
extends JPanel {
    private Displayable myDisplayable;
    private double myZoom = 1.0;
    private Dimension mySize;
    private boolean iamAutofitting;

    public DisplayablePanel(Displayable displayable) {
        this.display(displayable);
    }

    public DisplayablePanel(Displayable displayable, double d) {
        this.zoom(d);
        this.display(displayable);
    }

    public Displayable display() {
        return this.myDisplayable;
    }

    public void display(Displayable displayable) {
        if (displayable == null) {
            throw new NullPointerException();
        }
        this.myDisplayable = displayable;
        if (!this.iamAutofitting) {
            Rectangle2D rectangle2D = displayable.getBoundingBox();
            double d = rectangle2D.getWidth() * this.myZoom;
            double d2 = rectangle2D.getHeight() * this.myZoom;
            Dimension dimension = new Dimension();
            dimension.setSize(d, d2);
            this.setPreferredSize(dimension);
            Rectangle rectangle = this.getBounds();
            this.setBounds(rectangle.x, rectangle.y, (int)d, (int)d2);
        }
        this.repaint();
    }

    public double zoom() {
        return this.myZoom;
    }

    public void zoom(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.myZoom = d;
        if (this.myDisplayable != null) {
            this.display(this.myDisplayable);
        }
    }

    public boolean isAutofitting() {
        return this.iamAutofitting;
    }

    public void setAutofitting(boolean bl) {
        this.iamAutofitting = bl;
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.iamAutofitting) {
            Rectangle rectangle = this.getBounds(null);
            graphics2D.setPaint(this.myDisplayable.getBackgroundPaint());
            graphics2D.fill(rectangle);
            double d = rectangle.getWidth();
            double d2 = rectangle.getHeight();
            Rectangle2D rectangle2D = this.myDisplayable.getBoundingBox();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            double d5 = d / d3;
            double d6 = d2 / d4;
            if (d5 < d6) {
                graphics2D.translate(0.0, (d2 - d4 * d5) * 0.5);
                graphics2D.scale(d5, d5);
            } else {
                graphics2D.translate((d - d3 * d6) * 0.5, 0.0);
                graphics2D.scale(d6, d6);
            }
            this.myDisplayable.draw(graphics2D);
        } else {
            graphics2D.scale(this.myZoom, this.myZoom);
            graphics2D.setPaint(this.myDisplayable.getBackgroundPaint());
            graphics2D.fill(this.myDisplayable.getBoundingBox());
            this.myDisplayable.draw(graphics2D);
        }
        graphics2D.setPaint(paint);
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setTransform(affineTransform);
    }
}

