## ---- echo=FALSE, results="hide", message=FALSE----------------------------
require(knitr)
opts_chunk$set(error=FALSE, message=FALSE, warning=FALSE)

## ----setup, echo=FALSE, message=FALSE--------------------------------------
library(BiocSingular)
set.seed(100)

## --------------------------------------------------------------------------
library(Matrix)
a <- rsparsematrix(10000, 1000, density=0.01)
object.size(a)

centering <- rnorm(ncol(a))
scaling <- runif(ncol(a))
y <- DeferredMatrix(a, centering, scaling)
y

object.size(y) # 'a' plus the size of 'centering' and 'scaling'.

## --------------------------------------------------------------------------
v <- matrix(runif(ncol(a)*2), ncol=2)
system.time(X <- y %*% v)
X    

## --------------------------------------------------------------------------
centering2 <- rnorm(nrow(a))
scaling2 <- runif(nrow(a))
y2 <- DeferredMatrix(t(a), centering2, scaling2) # centering on rows of 'a'.
y3 <- DeferredMatrix(t(y2), centering, scaling) # centering on columns.
y3

## --------------------------------------------------------------------------
a <- rsparsematrix(10000, 1000, density=0.01)
out <- runPCA(a, rank=5, BSPARAM=IrlbaParam(deferred=TRUE)) # deferring for speed.
recon <- LowRankMatrix(out$rotation, out$x)
recon    

## --------------------------------------------------------------------------
summary(recon[,1])
summary(recon[2,])

## --------------------------------------------------------------------------
sessionInfo()

