### R code from vignette source 'NetAffxResource.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(AffyCompatible)


###################################################
### code chunk number 2: rsrc-setup
###################################################
password <- AffyCompatible:::acpassword


###################################################
### code chunk number 3: rsrc
###################################################
rsrc <- NetAffxResource(user="mtmorgan@fhcrc.org", password=password)
rsrc


###################################################
### code chunk number 4: names
###################################################
head(names(rsrc))
affxDescription(rsrc[["Bovine"]])


###################################################
### code chunk number 5: select-anno
###################################################
annos <- rsrc[["Porcine"]]
annos


###################################################
### code chunk number 6: anno-class
###################################################
sapply(affxAnnotation(annos), force)[1:5]
anno <- affxAnnotation(annos)[[3]]
anno


###################################################
### code chunk number 7: select-anno-idx
###################################################
anno <- rsrc[["Porcine", "Annotations, CSV format"]]
anno <- rsrc[["Porcine", 3]]


###################################################
### code chunk number 8: readAnnotation
###################################################
df <- readAnnotation(rsrc, annotation=anno)


###################################################
### code chunk number 9: anno-free-form
###################################################
anno <- rsrc[["Porcine", "PSI Library File"]]
fl <- readAnnotation(rsrc, annotation=anno, content=FALSE)
fl
## a zip file, containing 'Porcine.psi'
conn <- unz(fl, "Porcine.psi")
readLines(conn, n=6)
read.table(conn, header=FALSE, skip=1, sep="\t", nrows=5)


