## ----knitr, echo=FALSE, results='hide'-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,dev="pdf",fig.show="hide",
               fig.width=4,fig.height=4.5,
               message=FALSE, warning=FALSE)


## ----style, eval=TRUE, echo=FALSE, results="asis"--------------------------
BiocStyle::latex()

## ----options, results="hide", echo=FALSE--------------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")
opts_chunk$set(comment=NA, fig.width=7, fig.height=7)

## ----initialize, cache=FALSE, echo=FALSE--------------------------------------
# load library
library('variancePartition')

# optional step to run analysis in parallel on multicore machines
# Here use 4 threads
# This is strongly recommended since the analysis 
# can be computationally intensive 
library('doParallel')
cl <- makeCluster(4)
registerDoParallel(cl)

## ----corStruct, cache=TRUE, results='hide'------------------------------------
# Fit linear mixed model and examine correlation stucture
# for one gene
data(varPartData)

form <- ~ Age + (1|Individual) + (1|Tissue)

fitList <- fitVarPartModel( geneExpr[1:2,], form, info )

# focus on one gene
fit = fitList[[1]]

## ----corStructa, cache=TRUE---------------------------------------------------
# Figure 1a
# correlation structure based on similarity within Individual
# reorder samples based on clustering
plotCorrStructure( fit, "Individual" )

## ----corStructb, cache=TRUE---------------------------------------------------
# Figure 1b
# use original order of samples
plotCorrStructure( fit, "Individual", reorder=FALSE )

## ----corStructc, cache=TRUE---------------------------------------------------
# Figure 1c
# correlation structure based on similarity within Tissue
# reorder samples based on clustering
plotCorrStructure( fit, "Tissue" )

## ----corStructd, cache=TRUE---------------------------------------------------
# Figure 1d
# use original order of samples
plotCorrStructure( fit, "Tissue", reorder=FALSE )

## ----corStructe, cache=TRUE---------------------------------------------------
# Figure 2a
# correlation structure based on similarity within 
# Individual *and* Tissue, reorder samples based on clustering
plotCorrStructure( fit )

## ----corStructf, cache=TRUE---------------------------------------------------
# Figure 2b
# use original order of samples
plotCorrStructure( fit, reorder=FALSE )

## ----resetOptions, results="hide", echo=FALSE---------------------------------
options(prompt="> ", continue="+ ")

