## ------------------------------------------------------------------------
library(transite)

## ---- message=FALSE------------------------------------------------------
background.df <- transite:::ge$background

## ---- message=FALSE------------------------------------------------------
background.df <- dplyr::arrange(background.df, value)

## ---- message=FALSE------------------------------------------------------
background.set <- gsub("T", "U", background.df$seq)

## ---- message=FALSE------------------------------------------------------
names(background.set) <- paste0(background.df$refseq, "|", background.df$seq.type)

## ---- message=FALSE------------------------------------------------------
motif.db <- getMotifById("M178_0.6")

## ---- message=FALSE------------------------------------------------------
results <- runMatrixSPMA(background.set, motifs = motif.db, cache = FALSE)

# Usually, all motifs are included in the analysis and results are cached to make subsequent analyses more efficient.
# results <- runMatrixSPMA(background.set)

## ---- results='asis', echo=FALSE, fig.width=10, fig.height=7-------------
cat("\n\n####", results$spectrum.info.df$motif.rbps, " (", results$spectrum.info.df$motif.id, ")\n\n", sep = "")
  
cat("\n\n**Spectrum plot with polynomial regression:**\n\n")

grid::grid.draw(results$spectrum.plots[[1]])

cat("\n\n**Classification:**\n\n")

if (results$spectrum.info.df$aggregate.classifier.score == 3) {
    cat('\n\n<p style="background-color: #2ecc71; padding: 10px; color: white; margin: 0">spectrum classification: non-random (3 out of 3 criteria met)</p>\n\n')
} else if (results$spectrum.info.df$aggregate.classifier.score == 2) {
    cat('\n\n<p style="background-color: #f1c40f; padding: 10px; color: white; margin: 0">spectrum classification: random (2 out of 3 criteria met)</p>\n\n')
} else if (results$spectrum.info.df$aggregate.classifier.score == 1) {
    cat('\n\n<p style="background-color: #e67e22; padding: 10px; color: white; margin: 0">spectrum classification: random (1 out of 3 criteria met)</p>\n\n')
} else {
    cat('\n\n<p style="background-color: #c0392b; padding: 10px; color: white; margin: 0">spectrum classification: random (0 out of 3 criteria met)</p>\n\n')
}

cat("\n\nProperty | Value | Threshold\n")
cat("------------- | ------------- | -------------\n")
cat("adjusted $R^2$ | ", round(results$spectrum.info.df$adj.r.squared, 3), " | $\\geq 0.4$ \n")
cat("polynomial degree | ", results$spectrum.info.df$degree, " | $\\geq 1$ \n")
cat("slope | ", round(results$spectrum.info.df$slope, 3), " | $\\neq 0$ \n")
cat("unadjusted p-value estimate of consistency score | ", round(results$spectrum.info.df$consistency.score.p.value, 7), " | $< 0.000005$ \n")
cat("number of significant bins | ", results$spectrum.info.df$n.significant, " | ", paste0("$\\geq ", floor(40 / 10), "$"), " \n\n")

