## ----setup_knitr, include = FALSE, cache = FALSE-------------------------
library("srnadiff")
library("BiocStyle")
library("knitr")
library("rmarkdown")
opts_chunk$set(message = FALSE, error = FALSE, warning = FALSE,
               cache = FALSE, fig.width = 5, fig.height = 5)

## ---- standard, results="hide", warning=FALSE----------------------------
dir         <- system.file("extdata", package="srnadiff", mustWork = TRUE)
data        <- read.csv(file.path(dir, "data.csv"))
gtfFile     <- file.path(dir, "Homo_sapiens.GRCh38.76.gtf.gz")
annotation  <- readWholeGenomeAnnotation(gtfFile)
bamFiles    <- file.path(dir, data$FileName)
replicates  <- data$SampleName
conditions  <- factor(data$Condition)
exp         <- sRNADiffExp(annotation, bamFiles, replicates, conditions)
diffRegions <- runAll(exp)

## ---- example------------------------------------------------------------
exp         <- sRNADiffExample()
diffRegions <- runAll(exp)

## ---- read_whole_genome--------------------------------------------------
gtfFile     <- file.path(dir, "Homo_sapiens.GRCh38.76.gtf.gz")
annotation  <- readWholeGenomeAnnotation(gtfFile)

## ---- read_mirbase_pre---------------------------------------------------
gffFile    <- file.path(dir, "mirbase21_GRCh38.gff3")
annotation <- readMiRBasePreAnnotation(gffFile)

## ---- read_mirbase_mature------------------------------------------------
annotation <- readMiRBaseMatureAnnotation(gffFile)

## ---- read_annotation----------------------------------------------------
annotation <- readAnnotation(gtfFile, source="miRNA", feature="gene", name="gene_name")

## ---- set_merge_distance-------------------------------------------------
exp <- setMergeDistance(exp, 100)

## ---- hmm----------------------------------------------------------------
exp <- setTransitionProbabilities(exp, noDiffToDiff = 0.0001, diffToNoDiff = 0.01)
exp <- setEmissionProbabilities(exp, probability = 0.9)
exp <- setEmissionThreshold(exp, threshold = 0.1)

## ---- slicing------------------------------------------------------------
exp <- setMinDifferences(exp, differences = 50)

## ---- general_parameters-------------------------------------------------
exp <- setMinDepth(exp, depth = 10)
exp <- setSizes(exp, minSize = 15, maxSize = 1000)

## ---- strategies---------------------------------------------------------
exp <- setStrategies(exp, annotation = TRUE, naive = FALSE, hmm = TRUE, slice = TRUE)

## ---- minOverlap---------------------------------------------------------
exp <- setMinOverlap(exp, minOverlap = 20)

## ----regions-------------------------------------------------------------
exp     <- sRNADiffExample()
exp     <- runAll(exp)
regions <- regions(exp, pvalue = 0.5)

## ---- plot---------------------------------------------------------------
plotRegion(exp, regions[1])

## ---- conditions---------------------------------------------------------
conditions  <- factor(c("wt", "wt", "ko", "ko"), levels=c("wt", "ko"))

## ---- threads------------------------------------------------------------
exp <- setNThreads(exp, nThreads = 4)

## ---- session_info-------------------------------------------------------
devtools::session_info()

