/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export;

import com.compomics.util.io.export.ExportFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ExportScheme
implements Serializable {
    static final long serialVersionUID = -4712918049667194600L;
    private String name;
    private boolean editable;
    private String mainTitle = null;
    private ArrayList<String> sectionList = new ArrayList();
    private HashMap<String, ArrayList<ExportFeature>> exportFeaturesMap = new HashMap();
    private String separator = "\t";
    private boolean indexes = true;
    private boolean header = true;
    private int separationLines = 3;
    private boolean includeSectionTitles = true;

    private ExportScheme(String name, boolean editable, ArrayList<String> sectionList, HashMap<String, ArrayList<ExportFeature>> exportFeatures, String separator, boolean indexes, boolean header, int separationLines, boolean includeSectionTitles, String mainTitle) {
        this.sectionList = sectionList;
        this.exportFeaturesMap.putAll(exportFeatures);
        this.separator = separator;
        this.indexes = indexes;
        this.separationLines = separationLines;
        this.header = header;
        this.includeSectionTitles = includeSectionTitles;
        this.mainTitle = mainTitle;
        this.name = name;
        this.editable = editable;
    }

    public ExportScheme(String name, boolean editable, HashMap<String, ArrayList<ExportFeature>> exportFeatures, String separator, boolean indexes, boolean header, int separationLines, boolean includeSectionTitles, String mainTitle) {
        this(name, editable, new ArrayList<String>(exportFeatures.keySet()), exportFeatures, separator, indexes, header, separationLines, includeSectionTitles, mainTitle);
    }

    public ExportScheme(String name, boolean editable, ArrayList<String> sectionList, HashMap<String, ArrayList<ExportFeature>> exportFeatures, String separator, boolean indexes, boolean header, int separationLines, boolean includeSectionTitles) {
        this(name, editable, sectionList, exportFeatures, separator, indexes, header, separationLines, includeSectionTitles, null);
    }

    public ExportScheme(String name, boolean editable, HashMap<String, ArrayList<ExportFeature>> exportFeatures, String separator, boolean indexes, boolean header, int separationLines, boolean includeSectionTitles) {
        this(name, editable, new ArrayList<String>(exportFeatures.keySet()), exportFeatures, separator, indexes, header, separationLines, includeSectionTitles, null);
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isIndexes() {
        return this.indexes;
    }

    public boolean isHeader() {
        return this.header;
    }

    public int getSeparationLines() {
        return this.separationLines;
    }

    public boolean isIncludeSectionTitles() {
        return this.includeSectionTitles;
    }

    public ArrayList<String> getSections() {
        return this.sectionList;
    }

    public ArrayList<ExportFeature> getExportFeatures(String section) {
        return this.exportFeaturesMap.get(section);
    }

    public void setExportFeatures(String section, ArrayList<ExportFeature> exportFeatures) {
        this.exportFeaturesMap.put(section, exportFeatures);
        this.sectionList.add(section);
    }

    public void addExportFeature(String section, ExportFeature exportFeature) {
        ArrayList<ExportFeature> sectionFeatures = this.exportFeaturesMap.get(section);
        if (sectionFeatures == null) {
            sectionFeatures = new ArrayList();
            this.exportFeaturesMap.put(section, sectionFeatures);
            this.sectionList.add(section);
        }
        sectionFeatures.add(exportFeature);
    }

    public void removeSection(String sectionName) {
        this.exportFeaturesMap.remove(sectionName);
        this.sectionList.remove(sectionName);
    }

    public String getMainTitle() {
        return this.mainTitle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

