/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.Glycon;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Collections;

public abstract class Ion
extends ExperimentObject {
    static final long serialVersionUID = -1505719074403886934L;
    protected IonType type = IonType.UNKNOWN;
    protected double theoreticMass;

    public abstract String getName();

    public abstract CvTerm getPrideCvTerm();

    public abstract int getSubType();

    public abstract String getSubTypeAsString();

    public static ArrayList<Integer> getPossibleSubtypes(IonType ionType) {
        switch (ionType) {
            case ELEMENTARY_ION: {
                return ElementaryIon.getPossibleSubtypes();
            }
            case GLYCON: {
                return Glycon.getPossibleSubtypes();
            }
            case IMMONIUM_ION: {
                return ImmoniumIon.getPossibleSubtypes();
            }
            case PEPTIDE_FRAGMENT_ION: {
                return PeptideFragmentIon.getPossibleSubtypes();
            }
            case TAG_FRAGMENT_ION: {
                return TagFragmentIon.getPossibleSubtypes();
            }
            case PRECURSOR_ION: {
                return PrecursorIon.getPossibleSubtypes();
            }
            case REPORTER_ION: {
                return ReporterIon.getPossibleSubtypes();
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract ArrayList<NeutralLoss> getNeutralLosses();

    public abstract boolean isSameAs(Ion var1);

    public String getNeutralLossesAsString() {
        return Ion.getNeutralLossesAsString(this.getNeutralLosses());
    }

    public static String getNeutralLossesAsString(ArrayList<NeutralLoss> neutralLosses) {
        ArrayList<String> names = new ArrayList<String>();
        for (NeutralLoss neutralLoss : neutralLosses) {
            names.add(neutralLoss.name);
        }
        Collections.sort(names);
        StringBuffer result = new StringBuffer();
        for (String name : names) {
            result.append("-").append(name);
        }
        return result.toString();
    }

    public double getTheoreticMass() {
        return this.theoreticMass;
    }

    public double getTheoreticMz(int chargeValue) {
        return (this.getTheoreticMass() + (double)chargeValue * ElementaryIon.proton.theoreticMass) / (double)chargeValue;
    }

    public void setTheoreticMass(double theoreticMass) {
        this.theoreticMass = theoreticMass;
    }

    public IonType getType() {
        return this.type;
    }

    public static ArrayList<IonType> getImplementedIonTypes() {
        ArrayList<IonType> result = new ArrayList<IonType>();
        result.add(IonType.ELEMENTARY_ION);
        result.add(IonType.GLYCON);
        result.add(IonType.IMMONIUM_ION);
        result.add(IonType.PEPTIDE_FRAGMENT_ION);
        result.add(IonType.TAG_FRAGMENT_ION);
        result.add(IonType.PRECURSOR_ION);
        result.add(IonType.REPORTER_ION);
        return result;
    }

    public String getTypeAsString() {
        return Ion.getTypeAsString(this.type);
    }

    public static String getTypeAsString(IonType type) {
        switch (type) {
            case PEPTIDE_FRAGMENT_ION: {
                return "Peptide fragment ion";
            }
            case TAG_FRAGMENT_ION: {
                return "Tag fragment ion";
            }
            case PRECURSOR_ION: {
                return "Precursor ion";
            }
            case IMMONIUM_ION: {
                return "Immonium ion";
            }
            case REPORTER_ION: {
                return "Reporter ion";
            }
            case GLYCON: {
                return "Glycon";
            }
            case ELEMENTARY_ION: {
                return "Elementary ion";
            }
            case UNKNOWN: {
                return "Unknown ion type";
            }
        }
        throw new UnsupportedOperationException("No name for ion type " + (Object)((Object)type) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType, ArrayList<NeutralLoss> neutralLosses) {
        if (neutralLosses == null) {
            neutralLosses = new ArrayList();
        }
        switch (ionType) {
            case ELEMENTARY_ION: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case GLYCON: {
                return new Glycon("new Glycon", "new Glycon");
            }
            case IMMONIUM_ION: {
                return new ImmoniumIon(subType);
            }
            case PEPTIDE_FRAGMENT_ION: {
                return new PeptideFragmentIon(subType, neutralLosses);
            }
            case TAG_FRAGMENT_ION: {
                return new TagFragmentIon(subType, neutralLosses);
            }
            case PRECURSOR_ION: {
                return new PrecursorIon(neutralLosses);
            }
            case REPORTER_ION: {
                return ReporterIon.getReporterIon(subType);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static Ion getGenericIon(IonType ionType, int subType) {
        switch (ionType) {
            case ELEMENTARY_ION: {
                return new ElementaryIon("new ElementaryIon", 0.0, subType);
            }
            case GLYCON: {
                return new Glycon("new Glycon", "new Glycon");
            }
            case IMMONIUM_ION: {
                return new ImmoniumIon(subType);
            }
            case PEPTIDE_FRAGMENT_ION: {
                return new PeptideFragmentIon(subType);
            }
            case TAG_FRAGMENT_ION: {
                return new TagFragmentIon(subType);
            }
            case PRECURSOR_ION: {
                return new PrecursorIon();
            }
            case REPORTER_ION: {
                return ReporterIon.getReporterIon(subType);
            }
        }
        throw new UnsupportedOperationException("No generic constructor for " + Ion.getTypeAsString(ionType) + ".");
    }

    public static enum IonType {
        PEPTIDE_FRAGMENT_ION,
        TAG_FRAGMENT_ION,
        PRECURSOR_ION,
        IMMONIUM_ION,
        REPORTER_ION,
        GLYCON,
        ELEMENTARY_ION,
        UNKNOWN;

    }
}

