## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
Sys.setenv('RETICULATE_PYTHON'=Sys.getenv("RETICULATE_PYTHON"))
library(rhdf5client)
library(reticulate)

## ------------------------------------------------------------------------
src <- HSDSSource('http://hsdshdflab.hdfgroup.org')
rd <- HSDSDataset(HSDSFile(src, '/home/spollack/testone.h5'), '/group0/group1/group2/data4d')
A <- getData(rd, list(3:4, 8:9, 5:6, 2:3))
sum(A)

## ---- eval=FALSE---------------------------------------------------------
#  h5pyd <- import("h5pyd")
#  builtins <- import_builtins()
#  
#  endpoint <- 'http://hsdshdflab.hdfgroup.org'
#  domain <- '/home/spollack/testone.h5'
#  f <- h5pyd$File(endpoint=endpoint, mode='r', domain=domain)
#  pd <- f$`__getitem__`('/group0/group1/group2/data4d')
#  scs <- tuple(builtins$slice(2L, 4L, 1L), builtins$slice(7L, 9L, 1L),
#               builtins$slice(4L, 6L, 1L), builtins$slice(1L, 3L, 1L))
#  A <- pd$`__getitem__`(scs)
#  sum(A)

## ---- eval=FALSE---------------------------------------------------------
#  BR <- getData(rd, list(c(4), 1:11, c(5), 1:3))
#  scs <- tuple(builtins$slice(3L, 4L, 1L), builtins$slice(0L, 12L, 1L),
#               builtins$slice(4L, 5L, 1L), builtins$slice(0L, 3L, 1L))
#  BP <- pd$`__getitem__`(scs)
#  print(BR)
#  all(BP == BR)

## ---- eval=FALSE---------------------------------------------------------
#  BR <- getData(rd, list(c(5), 1:11, 1:7, c(2)))
#  scs <- tuple(builtins$slice(4L, 5L, 1L), builtins$slice(0L, 12L, 1L),
#               builtins$slice(0L, 7L, 1L), builtins$slice(1L, 2L, 1L))
#  BP <- pd$`__getitem__`(scs)
#  print(BR)
#  all(BP == BR)

## ------------------------------------------------------------------------
f <- HSDSFile(src, '/home/spollack/testtwo.h5')
d <- HSDSDataset(f, '/grpB/grpC/dataC')
print(getData(d, list(1:9, 1:11)))
print(getData(d, list(c(2, 3, 5, 7), c(1, 2, 4, 6, 8, 10))))

## ------------------------------------------------------------------------
d <- HSDSDataset(HSDSFile(src, '/home/spollack/testone.h5'), '/group0/group1/dataR')
X <- getData(d, list(c(5), 3:6, c(2), 2:4))
print(X)

## ------------------------------------------------------------------------
d <- HSDSDataset(HSDSFile(src, '/home/spollack/testone.h5'), '/group0/group1/dataR')
BR <- getData(d, list(c(4), 2:6, c(5), 1:3))
print(BR)
BT <- getData(d, list(c(4), c(2, 3, 5, 6), c(5), 1:3))
print(BT)
BR <- getData(d, list(c(4), 2:6, c(5), 1:5))
print(BR)
BT <- getData(d, list(c(4), c(2, 3, 5, 6), c(5), c(1, 2, 4, 5)))
print(BT)

## ------------------------------------------------------------------------
x <- getData(d, list(c(4), c(5), c(3), c(2)))
print(x)

