## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
library(rhdf5client)

## ------------------------------------------------------------------------
src.hsds <- HSDSSource('http://hsdshdflab.hdfgroup.org')

## ------------------------------------------------------------------------
listDomains(src.hsds, '/home/jreadey')
listDomains(src.hsds, '/home/jreadey/HDFLabTutorial')

## ------------------------------------------------------------------------
f0 <- HSDSFile(src.hsds, '/home/spollack/testzero.h5')
f1 <- HSDSFile(src.hsds, '/shared/bioconductor/tenx_full.h5')

## ------------------------------------------------------------------------
listDatasets(f0)
listDatasets(f1)

## ------------------------------------------------------------------------
d0 <- HSDSDataset(f0, '/grpA/grpAB/dsetX')
d1 <- HSDSDataset(f1, '/newassay001')

## ------------------------------------------------------------------------
apply(getData(d1, c('1:4', '1:27998'), transfermode='JSON'), 1, sum)
apply(getData(d1, c('1:4', '1:27998'), transfermode='binary'), 1, sum)

## ------------------------------------------------------------------------
apply(getData(d1, list(1:4, 1:27998), transfermode='JSON'), 1, sum)
apply(getData(d1, list(1:4, 1:27998), transfermode='binary'), 1, sum)

## ------------------------------------------------------------------------
apply(d1[1:4, 1:27998], 1, sum)

