/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Interval;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Position;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml.model.RangeStatus;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeUtils {
    protected static final String RANGE_SEPARATOR = "-";
    protected static final String RANGE_UNDETERMINED = "?";
    protected static final String RANGE_INTERVAL = "..";
    protected static final String RANGE_GREATER = ">";
    protected static final String RANGE_LESS = "<";
    protected static final String RANGE_N_TERM = "n";
    protected static final String RANGE_C_TERM = "c";
    protected static final String MI_RANGE_CERTAIN = "MI:0335";
    protected static final String MI_RANGE_UNDETERMINED = "MI:0339";
    protected static final String MI_RANGE_INTERVAL = "MI:0338";
    protected static final String MI_RANGE_GREATER = "MI:0336";
    protected static final String MI_RANGE_LESS = "MI:0337";
    protected static final String MI_RANGE_N_TERM = "MI:1040";
    protected static final String MI_RANGE_C_TERM = "MI:1039";
    private static final int START = 0;
    private static final int END = 1;
    public static final Log log = LogFactory.getLog(RangeUtils.class);

    public static Collection<Range> fromMitab(List<String> ranges) throws ConverterException {
        if (ranges == null || ranges.isEmpty()) {
            throw new ConverterException("The ranges list can not be empty or null");
        }
        ArrayList<Range> xmlRanges = new ArrayList<Range>();
        for (String range : ranges) {
            if (!(range = range.trim()).contains(RANGE_SEPARATOR)) continue;
            String[] positions = range.split(RANGE_SEPARATOR);
            if (positions.length != 2) {
                throw new ConverterException("The range is bad formatted." + ArrayUtils.toString(positions));
            }
            Range oneXmlRange = RangeUtils.parseRange(positions);
            if (oneXmlRange == null) continue;
            xmlRanges.add(oneXmlRange);
        }
        return xmlRanges;
    }

    public static List<String> toMitab(Collection<Range> ranges) throws TabConversionException {
        if (ranges == null || ranges.isEmpty()) {
            throw new TabConversionException("The ranges list can not be empty or null");
        }
        ArrayList<String> tabRanges = new ArrayList<String>();
        for (Range range : ranges) {
            if (!range.isLink()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(RangeUtils.buildBeginOrEnd(range, 0));
                stringBuilder.append(RANGE_SEPARATOR);
                stringBuilder.append(RangeUtils.buildBeginOrEnd(range, 1));
                tabRanges.add(stringBuilder.toString());
                continue;
            }
            log.warn("Linked features/ranges can not be converted to mitab.");
        }
        return tabRanges;
    }

    /*
     * Unable to fully structure code
     */
    private static Range parseRange(String[] positions) throws ConverterException {
        if (positions.length != 2) {
            throw new ConverterException("The range is bad formatted." + ArrayUtils.toString(positions));
        }
        range = new Range();
        for (i = 0; i < positions.length; ++i) {
            names = new Names();
            rangeRef = new DbReference();
            rangeRef.setDb("psi-mi");
            rangeRef.setDbAc("MI:0488");
            rangeRef.setRefType("identity");
            rangeRef.setRefTypeAc("MI:0356");
            xref = new Xref();
            xref.setPrimaryRef(rangeRef);
            position = positions[i];
            status = new RangeStatus();
            status.setNames(names);
            status.setXref(xref);
            if (position.contains("..")) {
                names.setShortLabel("range");
                names.setFullName("range");
                rangeRef.setId("MI:0338");
                interval = position.split("\\.\\.");
                if (interval.length != 2) {
                    throw new ConverterException("The range is bad formatted. Interval: " + ArrayUtils.toString(interval));
                }
                try {
                    start = Long.valueOf(interval[0]);
                    end = Long.valueOf(interval[1]);
                    if (i == 0) {
                        range.setBeginInterval(new Interval(start, end));
                    }
                    if (i != 1) ** GOTO lbl76
                    range.setEndInterval(new Interval(start, end));
                }
                catch (Exception e) {
                    throw new ConverterException("The range is bad formatted. Start:" + interval[0] + "End:" + interval[1]);
                }
            } else {
                value = null;
                if (position.startsWith(">")) {
                    names.setShortLabel("greater-than");
                    names.setFullName("greater-than");
                    rangeRef.setId("MI:0336");
                    value = RangeUtils.removeFirstCharAndConvert(position);
                } else if (position.startsWith("<")) {
                    names.setShortLabel("less-than");
                    names.setFullName("less-than");
                    rangeRef.setId("MI:0337");
                    value = RangeUtils.removeFirstCharAndConvert(position);
                } else if (position.equals("n")) {
                    names.setShortLabel("n-term range");
                    names.setFullName("n-terminal range");
                    rangeRef.setId("MI:1040");
                } else if (position.equals("c")) {
                    names.setShortLabel("c-term range");
                    names.setFullName("c-terminal range");
                    rangeRef.setId("MI:1039");
                } else if (position.equals("?")) {
                    names.setShortLabel("undetermined");
                    names.setFullName("undetermined sequence position");
                    rangeRef.setId("MI:0339");
                } else {
                    names.setShortLabel("certain");
                    names.setFullName("certain sequence position");
                    rangeRef.setId("MI:0335");
                    try {
                        value = new Position(Long.valueOf(position));
                    }
                    catch (Exception e) {
                        throw new ConverterException("The range is a certain sequence position but is bad formatted. Value:" + value);
                    }
                }
                if (i == 0) {
                    range.setBegin(value);
                } else if (i == 1) {
                    range.setEnd(value);
                }
            }
lbl76:
            // 7 sources

            if (i == 0) {
                range.setStartStatus(status);
                continue;
            }
            if (i != 1) continue;
            range.setEndStatus(status);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildBeginOrEnd(Range range, int startOrEnd) throws TabConversionException {
        StringBuilder stringBuilder = new StringBuilder();
        RangeStatus status = startOrEnd == 0 ? range.getStartStatus() : range.getEndStatus();
        if (status == null || status.getXref() == null) throw new TabConversionException("The range can not be converter because has not a valid status.");
        DbReference dbReference = status.getXref().getPrimaryRef();
        if (dbReference == null) throw new TabConversionException("The range can not be converter because has not a valid reference.");
        String id = dbReference.getId();
        if (id.equalsIgnoreCase(MI_RANGE_N_TERM)) {
            stringBuilder.append(RANGE_N_TERM);
            return stringBuilder.toString();
        } else if (id.equalsIgnoreCase(MI_RANGE_C_TERM)) {
            stringBuilder.append(RANGE_C_TERM);
            return stringBuilder.toString();
        } else if (id.equalsIgnoreCase(MI_RANGE_GREATER)) {
            stringBuilder.append(RANGE_GREATER);
            stringBuilder.append(RangeUtils.buildPosition(range, startOrEnd));
            return stringBuilder.toString();
        } else if (id.equalsIgnoreCase(MI_RANGE_LESS)) {
            stringBuilder.append(RANGE_LESS);
            stringBuilder.append(RangeUtils.buildPosition(range, startOrEnd));
            return stringBuilder.toString();
        } else if (id.equalsIgnoreCase(MI_RANGE_UNDETERMINED)) {
            stringBuilder.append(RANGE_UNDETERMINED);
            return stringBuilder.toString();
        } else if (id.equalsIgnoreCase(MI_RANGE_CERTAIN)) {
            stringBuilder.append(RangeUtils.buildPosition(range, startOrEnd));
            return stringBuilder.toString();
        } else {
            if (!id.equalsIgnoreCase(MI_RANGE_INTERVAL)) return stringBuilder.toString();
            if (startOrEnd == 0) {
                if (!range.hasBeginInterval()) throw new TabConversionException("The range must have a valid start interval.");
                Interval startInterval = range.getBeginInterval();
                stringBuilder.append(startInterval.getBegin());
                stringBuilder.append(RANGE_INTERVAL);
                stringBuilder.append(startInterval.getEnd());
                return stringBuilder.toString();
            } else {
                if (!range.hasEndInterval()) throw new TabConversionException("The range must have a valid end interval.");
                Interval endInterval = range.getEndInterval();
                stringBuilder.append(endInterval.getBegin());
                stringBuilder.append(RANGE_INTERVAL);
                stringBuilder.append(endInterval.getEnd());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildPosition(Range range, int startOrEnd) throws TabConversionException {
        if (startOrEnd == 0) {
            if (!range.hasBegin()) throw new TabConversionException("The range must have a valid start position.");
            return String.valueOf(range.getBegin().getPosition());
        }
        if (!range.hasEnd()) throw new TabConversionException("The range must have a valid end position.");
        return String.valueOf(range.getEnd().getPosition());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Position removeFirstCharAndConvert(String stringPosition) throws ConverterException {
        if (stringPosition.length() <= 1) throw new ConverterException("The range is bad formatted. Value:" + stringPosition);
        String position = stringPosition.substring(1);
        if (position.equals("")) throw new ConverterException("The range is bad formatted. Value:" + position);
        try {
            return new Position(Long.valueOf(position));
        }
        catch (Exception e2) {
            throw new ConverterException("The range is bad formatted. Value:" + position);
        }
    }
}

