/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.util.ArrayList;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.sbgn.Compaction;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.VisibilityEdge;
import org.ivis.util.RectangleD;

public class VisibilityGraph
extends LGraph {
    public Compaction.CompactionDirection direction;

    public VisibilityGraph(SbgnPDNode parent, LGraphManager graphMgr, Object vGraph) {
        super((LNode)parent, graphMgr, vGraph);
    }

    public void construct(Compaction.CompactionDirection d, ArrayList<SbgnPDNode> vertices) {
        this.init(vertices);
        ArrayList nodes = (ArrayList)this.getNodes();
        this.direction = d;
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                SbgnPDNode node2;
                SbgnPDNode node1 = (SbgnPDNode)nodes.get(i);
                int result = this.findVisibilityDirection(node1, node2 = (SbgnPDNode)nodes.get(j));
                if (result == 0) continue;
                this.createEdge(node1, node2);
            }
        }
    }

    private void init(ArrayList<SbgnPDNode> vertices) {
        for (SbgnPDNode s : vertices) {
            this.add(s);
        }
    }

    private int findVisibilityDirection(SbgnPDNode p, SbgnPDNode q) {
        if (this.direction == Compaction.CompactionDirection.VERTICAL) {
            if (q.getLeft() < p.getLeft() && p.getLeft() < q.getLeft() + q.getWidth()) {
                SbgnPDNode temp = p;
                p = q;
                q = temp;
            }
            if (p.getLeft() <= q.getLeft() && q.getLeft() <= p.getLeft() + p.getWidth() && this.sweepIntersectedArea(p, q)) {
                return 1;
            }
        } else if (this.direction == Compaction.CompactionDirection.HORIZONTAL) {
            if (q.getTop() < p.getTop() && p.getTop() < q.getTop() + q.getHeight()) {
                SbgnPDNode temp = p;
                p = q;
                q = temp;
            }
            if (p.getTop() <= q.getTop() && q.getTop() <= p.getTop() + p.getHeight() && this.sweepIntersectedArea(p, q)) {
                return 2;
            }
        }
        return 0;
    }

    private boolean sweepIntersectedArea(SbgnPDNode p, SbgnPDNode q) {
        int start = 0;
        int end = 0;
        if (this.direction == Compaction.CompactionDirection.VERTICAL) {
            start = (int)q.getLeft();
            end = (int)Math.min(p.getRight(), q.getRight());
        } else if (this.direction == Compaction.CompactionDirection.HORIZONTAL) {
            start = (int)q.getTop();
            end = (int)Math.min(p.getBottom(), q.getBottom());
        }
        if (start == end) {
            return false;
        }
        for (int sweepPoint = start; sweepPoint <= end; ++sweepPoint) {
            boolean isValid = true;
            RectangleD edge = this.tryConstructingEdge(p, q, sweepPoint);
            if (edge != null) {
                int result = this.checkIntermediateNodes(p, q, edge, sweepPoint);
                if (sweepPoint == result) {
                    isValid = true;
                } else {
                    sweepPoint = result;
                    isValid = false;
                }
            }
            if (!isValid) continue;
            return true;
        }
        return false;
    }

    private RectangleD tryConstructingEdge(SbgnPDNode p, SbgnPDNode q, int i) {
        if (this.direction == Compaction.CompactionDirection.VERTICAL) {
            if (p.getTop() < q.getTop() && p.getBottom() <= q.getTop()) {
                return new RectangleD(i, (int)p.getBottom(), 1.0, (int)(q.getTop() - p.getBottom()));
            }
            if (q.getTop() < p.getTop() && q.getTop() + q.getHeight() <= p.getTop()) {
                return new RectangleD(i, (int)q.getBottom(), 1.0, (int)(p.getTop() - q.getBottom()));
            }
            return null;
        }
        if (this.direction == Compaction.CompactionDirection.HORIZONTAL) {
            if (p.getLeft() < q.getLeft() && p.getRight() <= q.getLeft()) {
                return new RectangleD((int)p.getRight(), i, (int)(q.getLeft() - p.getRight()), 1.0);
            }
            if (q.getLeft() < p.getLeft() && q.getRight() <= p.getLeft()) {
                return new RectangleD((int)q.getRight(), i, (int)(p.getLeft() - q.getRight()), 1.0);
            }
            return null;
        }
        return null;
    }

    private int checkIntermediateNodes(SbgnPDNode p, SbgnPDNode q, RectangleD edge, int sweepPoint) {
        for (int j = 0; j < this.getNodes().size(); ++j) {
            SbgnPDNode intermediateNode = (SbgnPDNode)this.getNodes().get(j);
            if (intermediateNode.equals(p) || intermediateNode.equals(q) || !edge.intersects(intermediateNode.getRect())) continue;
            if (this.direction == Compaction.CompactionDirection.VERTICAL) {
                sweepPoint = (int)(intermediateNode.getRight() + 1.0);
                break;
            }
            if (this.direction != Compaction.CompactionDirection.HORIZONTAL) break;
            sweepPoint = (int)(intermediateNode.getBottom() + 1.0);
            break;
        }
        return sweepPoint;
    }

    private void createEdge(SbgnPDNode node1, SbgnPDNode node2) {
        if (this.direction == Compaction.CompactionDirection.VERTICAL) {
            if (node1.getTop() < node2.getTop()) {
                this.add(new VisibilityEdge(node1, node2, null), node1, node2);
            } else {
                this.add(new VisibilityEdge(node2, node1, null), node2, node1);
            }
        } else if (this.direction == Compaction.CompactionDirection.HORIZONTAL) {
            if (node1.getLeft() < node2.getLeft()) {
                this.add(new VisibilityEdge(node1, node2, null), node1, node2);
            } else {
                this.add(new VisibilityEdge(node2, node1, null), node2, node1);
            }
        }
        ((VisibilityEdge)this.getEdges().get(this.getEdges().size() - 1)).updateLength();
    }

    public VisibilityEdge findShortestEdge(SbgnPDNode s) {
        VisibilityEdge shortestEdge = null;
        int minLength = Integer.MAX_VALUE;
        for (int i = 0; i < this.getEdges().size(); ++i) {
            VisibilityEdge e2 = (VisibilityEdge)this.getEdges().get(i);
            e2.updateLength();
            if (!e2.getTarget().equals(s) || !(e2.getLength() < (double)minLength)) continue;
            shortestEdge = e2;
            minLength = (int)e2.getLength();
        }
        return shortestEdge;
    }
}

