/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XMLException;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

class XPointer {
    private XPointer() {
    }

    static Nodes query(Document doc, String xptr) throws XPointerSyntaxException, XPointerResourceException {
        Nodes result = new Nodes();
        boolean found = false;
        try {
            new Element(xptr, "http://www.example.com");
            Element identified = XPointer.findByID(doc.getRootElement(), xptr);
            if (identified != null) {
                result.append(identified);
                return result;
            }
        }
        catch (IllegalNameException ex) {
            List elementSchemeData = XPointer.findElementSchemeData(xptr);
            if (elementSchemeData.size() == 0) {
                throw new XPointerSyntaxException("No supported XPointer schemes found");
            }
            for (int i = 0; i < elementSchemeData.size(); ++i) {
                String currentData = (String)elementSchemeData.get(i);
                int[] keys = new int[]{};
                ParentNode current = doc;
                if (currentData.indexOf(47) == -1) {
                    try {
                        new Element(currentData);
                    }
                    catch (IllegalNameException inex) {
                        continue;
                    }
                    Element identified = XPointer.findByID(doc.getRootElement(), currentData);
                    if (identified != null) {
                        if (!found) {
                            result.append(identified);
                        }
                        found = true;
                    }
                } else if (!currentData.startsWith("/")) {
                    String id = currentData.substring(0, currentData.indexOf(47));
                    try {
                        new Element(id);
                    }
                    catch (XMLException inex) {
                        continue;
                    }
                    current = XPointer.findByID(doc.getRootElement(), id);
                    keys = XPointer.split(currentData.substring(currentData.indexOf(47)));
                    if (current == null) {
                        continue;
                    }
                } else {
                    keys = XPointer.split(currentData);
                }
                for (int j = 0; j < keys.length && (current = XPointer.findNthChildElement(current, keys[j])) != null; ++j) {
                }
                if (current == doc || current == null) continue;
                if (!found) {
                    result.append(current);
                }
                found = true;
            }
        }
        if (found) {
            return result;
        }
        throw new XPointerResourceException("XPointer " + xptr + " did not locate any nodes in the document " + doc.getBaseURI());
    }

    private static Element findNthChildElement(ParentNode parent, int position) {
        int elementCount = 1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node child = parent.getChild(i);
            if (!(child instanceof Element)) continue;
            if (elementCount == position) {
                return (Element)child;
            }
            ++elementCount;
        }
        return null;
    }

    private static int[] split(String tumbler) throws XPointerSyntaxException {
        int numberOfParts = 0;
        for (int i = 0; i < tumbler.length(); ++i) {
            if (tumbler.charAt(i) != '/') continue;
            ++numberOfParts;
        }
        int[] result = new int[numberOfParts];
        int index = 0;
        StringBuffer part = new StringBuffer(3);
        try {
            for (int i = 1; i < tumbler.length(); ++i) {
                if (tumbler.charAt(i) == '/') {
                    result[index] = Integer.parseInt(part.toString());
                    ++index;
                    part = new StringBuffer(3);
                    continue;
                }
                part.append(tumbler.charAt(i));
            }
            result[result.length - 1] = Integer.parseInt(part.toString());
        }
        catch (NumberFormatException ex) {
            XPointerSyntaxException ex2 = new XPointerSyntaxException(tumbler + " is not syntactically correct", ex);
            throw ex2;
        }
        return result;
    }

    private static List findElementSchemeData(String xpointer) throws XPointerSyntaxException {
        char c;
        int i;
        ArrayList<String> result = new ArrayList<String>(1);
        StringBuffer xptr = new StringBuffer(xpointer.trim());
        StringBuffer scheme = new StringBuffer();
        for (i = 0; i < xptr.length() && (c = xptr.charAt(i)) != '('; ++i) {
            scheme.append(c);
        }
        try {
            new Element(scheme.toString(), "http://www.example.com/");
        }
        catch (IllegalNameException ex) {
            throw new XPointerSyntaxException(ex.getMessage());
        }
        int open = 1;
        ++i;
        StringBuffer schemeData = new StringBuffer();
        try {
            while (open > 0) {
                char c2 = xptr.charAt(i);
                if (c2 == '^') {
                    c2 = xptr.charAt(i + 1);
                    schemeData.append(c2);
                    if (c2 != '^' && c2 != '(' && c2 != ')') {
                        throw new XPointerSyntaxException("Illegal XPointer escape sequence");
                    }
                    ++i;
                } else if (c2 == '(') {
                    schemeData.append(c2);
                    ++open;
                } else if (c2 == ')') {
                    if (--open > 0) {
                        schemeData.append(c2);
                    }
                } else {
                    schemeData.append(c2);
                }
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new XPointerSyntaxException("Unbalanced parentheses");
        }
        if (scheme.toString().equals("element")) {
            result.add(schemeData.toString());
        }
        if (i + 1 < xptr.length()) {
            result.addAll(XPointer.findElementSchemeData(xptr.substring(i)));
        }
        return result;
    }

    static Element findByID(Element element, String id) {
        Node current = element;
        boolean end = false;
        int index = -1;
        while (true) {
            if (current instanceof Element) {
                Element currentElement = current;
                for (int i = 0; i < currentElement.getAttributeCount(); ++i) {
                    Attribute att = currentElement.getAttribute(i);
                    if (att.getType() != Attribute.Type.ID || !att.getValue().trim().equals(id)) continue;
                    return currentElement;
                }
            }
            if (!end && current.getChildCount() > 0) {
                current = current.getChild(0);
                index = 0;
                continue;
            }
            if (end && current == element) break;
            end = false;
            ParentNode parent = current.getParent();
            if (parent.getChildCount() - 1 == index) {
                current = parent;
                if (current != element) {
                    parent = current.getParent();
                    index = parent.indexOf(current);
                }
                end = true;
                continue;
            }
            current = parent.getChild(++index);
        }
        return null;
    }
}

