/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.CommentImpl;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.tree.NodeFactory;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.ProcInstImpl;
import net.sf.saxon.tree.TextImpl;

public class TreeBuilder
extends Builder {
    private static AttributeCollectionImpl emptyAttributeCollection = new AttributeCollectionImpl(null);
    private ParentNodeImpl currentNode;
    private NodeFactory nodeFactory;
    private int[] size = new int[100];
    private int depth = 0;
    private ArrayList arrays = new ArrayList(20);
    private int pendingElement;
    private int pendingLocationId;
    private AttributeCollectionImpl attributes;
    private int[] namespaces;
    private int namespacesUsed;
    private int nextNodeNumber = 1;
    private static final int[] EMPTY_ARRAY_OF_INT = new int[0];

    public TreeBuilder() {
        this.nodeFactory = new DefaultNodeFactory();
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void open() throws XPathException {
        DocumentImpl documentImpl;
        this.started = true;
        if (this.currentRoot == null) {
            documentImpl = new DocumentImpl();
            this.currentRoot = documentImpl;
        } else {
            if (!(this.currentRoot instanceof DocumentImpl)) {
                throw new DynamicError("Document node supplied is of wrong kind (" + this.currentRoot.getClass().getName() + ')');
            }
            documentImpl = (DocumentImpl)this.currentRoot;
            if (documentImpl.getFirstChild() != null) {
                throw new DynamicError("Supplied document is not empty");
            }
        }
        documentImpl.setSystemId(this.getSystemId());
        documentImpl.setConfiguration(this.config);
        this.currentNode = documentImpl;
        this.depth = 0;
        this.size[this.depth] = 0;
        documentImpl.sequence = 0;
        if (this.lineNumbering) {
            documentImpl.setLineNumbering();
        }
        super.open();
    }

    public void close() throws XPathException {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.compact(this.size[this.depth]);
        this.currentNode = null;
        this.arrays = null;
        super.close();
        this.nodeFactory = null;
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        this.pendingElement = n;
        this.pendingLocationId = n4;
        this.namespacesUsed = 0;
        this.attributes = null;
    }

    public void namespace(int n, int n2) {
        if (this.namespaces == null) {
            this.namespaces = new int[5];
        }
        if (this.namespacesUsed == this.namespaces.length) {
            int[] nArray = new int[this.namespaces.length * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesUsed);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesUsed++] = n;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        n5 &= 0xFFFFFFFE;
        if (this.attributes == null) {
            this.attributes = new AttributeCollectionImpl(this.namePool);
        }
        this.attributes.addAttribute(n, n2, ((Object)charSequence).toString(), n4, n5);
    }

    public void startContent() throws XPathException {
        if (this.attributes == null) {
            this.attributes = emptyAttributeCollection;
        } else {
            this.attributes.compact();
        }
        int[] nArray = this.namespaces;
        if (nArray == null || this.namespacesUsed == 0) {
            nArray = EMPTY_ARRAY_OF_INT;
        }
        ElementImpl elementImpl = this.nodeFactory.makeElementNode(this.currentNode, this.pendingElement, this.attributes, nArray, this.namespacesUsed, this.pipe.getLocationProvider(), this.pendingLocationId, this.nextNodeNumber++);
        this.namespacesUsed = 0;
        this.attributes = null;
        while (this.depth >= this.arrays.size()) {
            this.arrays.add(new NodeImpl[20]);
        }
        elementImpl.useChildrenArray((NodeImpl[])this.arrays.get(this.depth));
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(elementImpl, n2);
        if (this.depth >= this.size.length - 1) {
            int[] nArray2 = new int[this.size.length * 2];
            System.arraycopy(this.size, 0, nArray2, 0, this.size.length);
            this.size = nArray2;
        }
        this.size[++this.depth] = 0;
        this.namespacesUsed = 0;
        if (this.currentNode instanceof DocumentInfo) {
            ((DocumentImpl)this.currentNode).setDocumentElement(elementImpl);
        }
        this.currentNode = elementImpl;
    }

    public void endElement() throws XPathException {
        this.currentNode.compact(this.size[this.depth]);
        --this.depth;
        this.currentNode = (ParentNodeImpl)this.currentNode.getParent();
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (charSequence.length() > 0) {
            TextImpl textImpl = new TextImpl(this.currentNode, ((Object)charSequence).toString());
            int n4 = this.depth;
            int n5 = this.size[n4];
            this.size[n4] = n5 + 1;
            this.currentNode.addChild(textImpl, n5);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) {
        int n4 = this.namePool.allocate("", "", string);
        ProcInstImpl procInstImpl = new ProcInstImpl(n4, ((Object)charSequence).toString());
        int n5 = this.depth;
        int n6 = this.size[n5];
        this.size[n5] = n6 + 1;
        this.currentNode.addChild(procInstImpl, n6);
        LocationProvider locationProvider = this.pipe.getLocationProvider();
        if (locationProvider != null) {
            procInstImpl.setLocation(locationProvider.getSystemId(n), locationProvider.getLineNumber(n));
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        CommentImpl commentImpl = new CommentImpl(((Object)charSequence).toString());
        int n4 = this.depth;
        int n5 = this.size[n4];
        this.size[n4] = n5 + 1;
        this.currentNode.addChild(commentImpl, n5);
    }

    public void graftElement(ElementImpl elementImpl) throws XPathException {
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(elementImpl, n2);
    }

    public void setUnparsedEntity(String string, String string2, String string3) {
        ((DocumentImpl)this.currentRoot).setUnparsedEntity(string, string2, string3);
    }

    private static class DefaultNodeFactory
    implements NodeFactory {
        private DefaultNodeFactory() {
        }

        public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollectionImpl attributeCollectionImpl, int[] nArray, int n2, LocationProvider locationProvider, int n4, int n5) {
            ElementImpl elementImpl;
            if (attributeCollectionImpl.getLength() == 0 && n2 == 0) {
                elementImpl = new ElementImpl();
            } else {
                elementImpl = new ElementWithAttributes();
                if (n2 > 0) {
                    ((ElementWithAttributes)elementImpl).setNamespaceDeclarations(nArray, n2);
                }
            }
            String string = null;
            int n6 = -1;
            if (locationProvider != null) {
                string = locationProvider.getSystemId(n4);
                n6 = locationProvider.getLineNumber(n4);
            }
            elementImpl.initialise(n, attributeCollectionImpl, nodeInfo, string, n6, n5);
            return elementImpl;
        }
    }
}

