/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.JDKTimeZone;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.STZInfo;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;

public class SimpleTimeZone
extends JDKTimeZone {
    private static final long serialVersionUID = -7034676239311322769L;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final byte[] staticLeapMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private static final int WALL_TIME = 0;
    private static final int STANDARD_TIME = 1;
    private static final int UTC_TIME = 2;
    private int raw;
    private int dst = 3600000;
    private STZInfo xinfo = null;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endTimeMode;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private boolean useDaylight;
    private int startMode;
    private int endMode;

    public SimpleTimeZone(int rawOffset, String ID2) {
        this.construct(rawOffset, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3600000);
        super.setID(ID2);
    }

    public SimpleTimeZone(int rawOffset, String ID2, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime) {
        this.construct(rawOffset, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, 3600000);
        super.setID(ID2);
    }

    public SimpleTimeZone(int rawOffset, String ID2, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this.raw = rawOffset;
        this.dst = dstSavings;
        this.construct(rawOffset, startMonth, startDay, startDayOfWeek, startTime, 0, endMonth, endDay, endDayOfWeek, endTime, 0, dstSavings);
        super.setID(ID2);
    }

    public void setRawOffset(int offsetMillis) {
        this.raw = offsetMillis;
    }

    public int getRawOffset() {
        return this.raw;
    }

    public void setStartYear(int year) {
        this.getSTZInfo().sy = year;
        this.startYear = year;
    }

    public void setStartRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.getSTZInfo().setStart(month, dayOfWeekInMonth, dayOfWeek, time, -1, false);
        this.setStartRule(month, dayOfWeekInMonth, dayOfWeek, time, 0);
    }

    private void setStartRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time, int mode) {
        this.startMonth = month;
        this.startDay = dayOfWeekInMonth;
        this.startDayOfWeek = dayOfWeek;
        this.startTime = time;
        this.startTimeMode = mode;
        this.decodeStartRule();
    }

    public void setStartRule(int month, int dayOfMonth, int time) {
        this.getSTZInfo().setStart(month, -1, -1, time, dayOfMonth, false);
        this.setStartRule(month, dayOfMonth, 0, time, 0);
    }

    public void setStartRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        this.getSTZInfo().setStart(month, -1, dayOfWeek, time, dayOfMonth, after);
        this.setStartRule(month, after ? dayOfMonth : -dayOfMonth, -dayOfWeek, time, 0);
    }

    public void setEndRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time) {
        this.getSTZInfo().setEnd(month, dayOfWeekInMonth, dayOfWeek, time, -1, false);
        this.setEndRule(month, dayOfWeekInMonth, dayOfWeek, time, 0);
    }

    public void setEndRule(int month, int dayOfMonth, int time) {
        this.getSTZInfo().setEnd(month, -1, -1, time, dayOfMonth, false);
        this.setEndRule(month, dayOfMonth, 0, time);
    }

    public void setEndRule(int month, int dayOfMonth, int dayOfWeek, int time, boolean after) {
        this.getSTZInfo().setEnd(month, -1, dayOfWeek, time, dayOfMonth, after);
        this.setEndRule(month, dayOfMonth, dayOfWeek, time, 0, after);
    }

    private void setEndRule(int month, int dayOfMonth, int dayOfWeek, int time, int mode, boolean after) {
        this.setEndRule(month, after ? dayOfMonth : -dayOfMonth, -dayOfWeek, time, mode);
    }

    private void setEndRule(int month, int dayOfWeekInMonth, int dayOfWeek, int time, int mode) {
        this.endMonth = month;
        this.endDay = dayOfWeekInMonth;
        this.endDayOfWeek = dayOfWeek;
        this.endTime = time;
        this.endTimeMode = mode;
        this.decodeEndRule();
    }

    public void setDSTSavings(int millisSavedDuringDST) {
        if (millisSavedDuringDST <= 0) {
            throw new IllegalArgumentException();
        }
        this.dst = millisSavedDuringDST;
    }

    public int getDSTSavings() {
        return this.dst;
    }

    public SimpleTimeZone(java.util.SimpleTimeZone tz, String ID2) {
        super(tz);
        super.setID(ID2);
        this.dst = tz.getDSTSavings();
        this.raw = tz.getRawOffset();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String id = this.getID();
        if (this.xinfo != null) {
            this.xinfo.applyTo(this);
        }
    }

    public String toString() {
        return "SimpleTimeZone: " + this.getID();
    }

    private STZInfo getSTZInfo() {
        if (this.xinfo == null) {
            this.xinfo = new STZInfo();
        }
        return this.xinfo;
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        return this.getOffset(era, year, month, day, dayOfWeek, millis, staticMonthLength[month]);
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        int prevMonthLength = month >= 1 ? staticMonthLength[month - 1] : 31;
        return this.getOffset(era, year, month, day, dayOfWeek, millis, monthLength, prevMonthLength);
    }

    int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength, int prevMonthLength) {
        if (era != 1 && era != 0 || month < 0 || month > 11 || day < 1 || day > monthLength || dayOfWeek < 1 || dayOfWeek > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31 || prevMonthLength < 28 || prevMonthLength > 31) {
            throw new IllegalArgumentException();
        }
        int result = this.raw;
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return result;
        }
        boolean southern = this.startMonth > this.endMonth;
        int startCompare = this.compareToRule(month, monthLength, prevMonthLength, day, dayOfWeek, millis, this.startTimeMode == 2 ? -this.raw : 0, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int endCompare = 0;
        if (southern != startCompare >= 0) {
            endCompare = this.compareToRule(month, monthLength, prevMonthLength, day, dayOfWeek, millis, this.endTimeMode == 0 ? this.dst : (this.endTimeMode == 2 ? -this.raw : 0), this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!southern && startCompare >= 0 && endCompare < 0 || southern && (startCompare >= 0 || endCompare < 0)) {
            result += this.dst;
        }
        return result;
    }

    private int compareToRule(int month, int monthLen, int prevMonthLen, int dayOfMonth, int dayOfWeek, int millis, int millisDelta, int ruleMode, int ruleMonth, int ruleDayOfWeek, int ruleDay, int ruleMillis) {
        millis += millisDelta;
        while (millis >= 86400000) {
            millis -= 86400000;
            dayOfWeek = 1 + dayOfWeek % 7;
            if (++dayOfMonth <= monthLen) continue;
            dayOfMonth = 1;
            ++month;
        }
        while (millis < 0) {
            millis += 86400000;
            dayOfWeek = 1 + (dayOfWeek + 5) % 7;
            if (--dayOfMonth >= 1) continue;
            dayOfMonth = prevMonthLen;
            --month;
        }
        if (month < ruleMonth) {
            return -1;
        }
        if (month > ruleMonth) {
            return 1;
        }
        int ruleDayOfMonth = 0;
        switch (ruleMode) {
            case 1: {
                ruleDayOfMonth = ruleDay;
                break;
            }
            case 2: {
                if (ruleDay > 0) {
                    ruleDayOfMonth = 1 + (ruleDay - 1) * 7 + (7 + ruleDayOfWeek - (dayOfWeek - dayOfMonth + 1)) % 7;
                    break;
                }
                ruleDayOfMonth = monthLen + (ruleDay + 1) * 7 - (7 + (dayOfWeek + monthLen - dayOfMonth) - ruleDayOfWeek) % 7;
                break;
            }
            case 3: {
                ruleDayOfMonth = ruleDay + (49 + ruleDayOfWeek - ruleDay - dayOfWeek + dayOfMonth) % 7;
                break;
            }
            case 4: {
                ruleDayOfMonth = ruleDay - (49 - ruleDayOfWeek + ruleDay + dayOfWeek - dayOfMonth) % 7;
            }
        }
        if (dayOfMonth < ruleDayOfMonth) {
            return -1;
        }
        if (dayOfMonth > ruleDayOfMonth) {
            return 1;
        }
        if (millis < ruleMillis) {
            return -1;
        }
        if (millis > ruleMillis) {
            return 1;
        }
        return 0;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date2) {
        GregorianCalendar gc = new GregorianCalendar(this);
        gc.setTime(date2);
        return gc.inDaylightTime();
    }

    public SimpleTimeZone(int raw, String ID2, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int dst) {
        this.construct(raw, startMonth, startDay, startDayOfWeek, startTime, startTimeMode, endMonth, endDay, endDayOfWeek, endTime, endTimeMode, dst);
    }

    private void construct(int raw, int startMonth, int startDay, int startDayOfWeek, int startTime, int startTimeMode, int endMonth, int endDay, int endDayOfWeek, int endTime, int endTimeMode, int dst) {
        this.raw = raw;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.startTimeMode = startTimeMode;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.endTimeMode = endTimeMode;
        this.dst = dst;
        this.startYear = 0;
        this.startMode = 1;
        this.endMode = 1;
        this.decodeRules();
        if (dst <= 0) {
            throw new IllegalArgumentException();
        }
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.useDaylight && this.dst == 0) {
            this.dst = 86400000;
        }
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException();
            }
            if (this.startTime < 0 || this.startTime >= 86400000 || this.startTimeMode < 0 || this.startTimeMode > 2) {
                throw new IllegalArgumentException();
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.startMode == 2 ? this.startDay < -5 || this.startDay > 5 : this.startDay < 1 || this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException();
            }
        }
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.useDaylight && this.dst == 0) {
            this.dst = 86400000;
        }
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException();
            }
            if (this.endTime < 0 || this.endTime > 86400000 || this.endTimeMode < 0 || this.endTimeMode > 2) {
                throw new IllegalArgumentException();
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.endMode == 2 ? this.endDay < -5 || this.endDay > 5 : this.endDay < 1 || this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTimeZone that = (SimpleTimeZone)obj;
        return this.raw == that.raw && this.useDaylight == that.useDaylight && this.idEquals(this.getID(), that.getID()) && (!this.useDaylight || this.dst == that.dst && this.startMode == that.startMode && this.startMonth == that.startMonth && this.startDay == that.startDay && this.startDayOfWeek == that.startDayOfWeek && this.startTime == that.startTime && this.startTimeMode == that.startTimeMode && this.endMode == that.endMode && this.endMonth == that.endMonth && this.endDay == that.endDay && this.endDayOfWeek == that.endDayOfWeek && this.endTime == that.endTime && this.endTimeMode == that.endTimeMode && this.startYear == that.startYear);
    }

    private boolean idEquals(String id1, String id2) {
        if (id1 == null && id2 == null) {
            return true;
        }
        if (id1 != null && id2 != null) {
            return id1.equals(id2);
        }
        return false;
    }

    public int hashCode() {
        int ret = super.hashCode() + this.raw ^ (this.raw >>> 8) + (this.useDaylight ? 0 : 1);
        if (!this.useDaylight) {
            ret += this.dst ^ (this.dst >>> 10) + this.startMode ^ (this.startMode >>> 11) + this.startMonth ^ (this.startMonth >>> 12) + this.startDay ^ (this.startDay >>> 13) + this.startDayOfWeek ^ (this.startDayOfWeek >>> 14) + this.startTime ^ (this.startTime >>> 15) + this.startTimeMode ^ (this.startTimeMode >>> 16) + this.endMode ^ (this.endMode >>> 17) + this.endMonth ^ (this.endMonth >>> 18) + this.endDay ^ (this.endDay >>> 19) + this.endDayOfWeek ^ (this.endDayOfWeek >>> 20) + this.endTime ^ (this.endTime >>> 21) + this.endTimeMode ^ (this.endTimeMode >>> 22) + this.startYear ^ this.startYear >>> 23;
        }
        return ret;
    }

    public Object clone() {
        SimpleTimeZone clone = new SimpleTimeZone(this.raw, this.getID());
        clone.startMonth = this.startMonth;
        clone.startDay = this.startDay;
        clone.startDayOfWeek = this.startDayOfWeek;
        clone.startTime = this.startTime;
        clone.startTimeMode = this.startTimeMode;
        clone.endMonth = this.endMonth;
        clone.endDay = this.endDay;
        clone.endDayOfWeek = this.endDayOfWeek;
        clone.endTime = this.endTime;
        clone.endTimeMode = this.endTimeMode;
        clone.dst = this.dst;
        clone.startYear = this.startYear;
        clone.startMode = this.startMode;
        clone.endMode = this.endMode;
        clone.useDaylight = this.useDaylight;
        return clone;
    }

    public boolean hasSameRules(TimeZone othr) {
        if (!(othr instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone other = (SimpleTimeZone)othr;
        return other != null && this.raw == other.raw && this.useDaylight == other.useDaylight && (!this.useDaylight || this.dst == other.dst && this.startMode == other.startMode && this.startMonth == other.startMonth && this.startDay == other.startDay && this.startDayOfWeek == other.startDayOfWeek && this.startTime == other.startTime && this.startTimeMode == other.startTimeMode && this.endMode == other.endMode && this.endMonth == other.endMonth && this.endDay == other.endDay && this.endDayOfWeek == other.endDayOfWeek && this.endTime == other.endTime && this.endTimeMode == other.endTimeMode && this.startYear == other.startYear);
    }
}

