/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.util.ArrayList;
import java.util.List;

public abstract class ExprFunction
extends ExprNode {
    protected FunctionLabel funcSymbol;
    protected String opSign;

    protected ExprFunction(String fName) {
        this.funcSymbol = new FunctionLabel(fName);
        this.opSign = null;
    }

    protected ExprFunction(String fName, String opSign) {
        this(fName);
        this.opSign = opSign;
    }

    public abstract Expr getArg(int var1);

    public abstract int numArgs();

    public List getArgs() {
        ArrayList<Expr> x = new ArrayList<Expr>();
        for (int i = 1; i <= this.numArgs(); ++i) {
            x.add(this.getArg(i));
        }
        return x;
    }

    public boolean isFunction() {
        return true;
    }

    public ExprFunction getFunction() {
        return this;
    }

    public int hashCode() {
        return this.funcSymbol.hashCode() ^ this.numArgs();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        ExprFunction ex = (ExprFunction)other;
        if (!this.funcSymbol.equals(ex.funcSymbol)) {
            return false;
        }
        if (this.numArgs() != ex.numArgs()) {
            return false;
        }
        for (int i = 1; i <= this.numArgs(); ++i) {
            Expr a2;
            Expr a1 = this.getArg(i);
            if (a1.equals(a2 = ex.getArg(i))) continue;
            return false;
        }
        return true;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public String getFunctionPrintName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public String getFunctionName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public FunctionLabel getFunctionSymbol() {
        return this.funcSymbol;
    }

    public String getFunctionIRI() {
        return null;
    }

    public String getOpName() {
        return this.opSign;
    }
}

