/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.ChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.ConsumerChoicePointFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrameWithDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.FrameObject;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import com.hp.hpl.jena.reasoner.rulesys.impl.TopLevelTripleMatchFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.TripleMatchFrame;
import com.hp.hpl.jena.util.PrintUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LPInterpreter {
    protected LPBRuleEngine engine;
    protected LPInterpreterContext iContext;
    protected boolean isComplete = false;
    protected Node[] tVars = new Node[8];
    protected Node[] argVars = new Node[8];
    protected Node[] pVars = null;
    protected EnvironmentFrame envFrame;
    protected FrameObject cpFrame;
    protected ArrayList trail = new ArrayList();
    protected RuleContext context;
    protected TopLevelTripleMatchFrame topTMFrame;
    protected TriplePattern goal;
    static Log logger = LogFactory.getLog(LPInterpreter.class);

    public LPInterpreter(LPBRuleEngine engine, TriplePattern goal) {
        this(engine, goal, engine.getRuleStore().codeFor(goal), true);
    }

    public LPInterpreter(LPBRuleEngine engine, TriplePattern goal, boolean isTop) {
        this(engine, goal, engine.getRuleStore().codeFor(goal), isTop);
    }

    public LPInterpreter(LPBRuleEngine engine, TriplePattern goal, List clauses, boolean isTop) {
        this.engine = engine;
        this.goal = goal;
        this.envFrame = engine.getDerivationLogging() ? new EnvironmentFrameWithDerivation(RuleClauseCode.returnCodeBlock) : new EnvironmentFrame(RuleClauseCode.returnCodeBlock);
        this.envFrame.allocate(15);
        HashMap mappedVars = new HashMap();
        this.envFrame.pVars[0] = this.argVars[0] = this.standardize(goal.getSubject(), mappedVars);
        this.envFrame.pVars[1] = this.argVars[1] = this.standardize(goal.getPredicate(), mappedVars);
        this.envFrame.pVars[2] = this.argVars[2] = this.standardize(goal.getObject(), mappedVars);
        if (engine.getDerivationLogging()) {
            ((EnvironmentFrameWithDerivation)this.envFrame).initDerivationRecord(this.argVars);
        }
        if (clauses != null && clauses.size() > 0) {
            if (isTop && engine.getRuleStore().isTabled(goal)) {
                this.setupTabledCall(0, 0);
            } else {
                this.setupClauseCall(0, 0, clauses, goal.isGround());
            }
        }
        this.topTMFrame = new TopLevelTripleMatchFrame(this, goal);
        this.topTMFrame.linkTo(this.cpFrame);
        this.topTMFrame.setContinuation(0, 0);
        this.cpFrame = this.topTMFrame;
    }

    public void setTopInterpreter(LPInterpreterContext context) {
        this.iContext = context;
        FrameObject topChoice = this.topTMFrame.getLink();
        if (topChoice instanceof ConsumerChoicePointFrame) {
            ((ConsumerChoicePointFrame)topChoice).context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LPBRuleEngine lPBRuleEngine = this.engine;
        synchronized (lPBRuleEngine) {
            this.isComplete = true;
            this.engine.detach(this);
            if (this.cpFrame != null) {
                this.cpFrame.close();
            }
        }
    }

    public void setState(LPInterpreterState state) {
        if (state instanceof ConsumerChoicePointFrame) {
            this.restoreState((ConsumerChoicePointFrame)state);
        } else {
            this.iContext = (LPInterpreterContext)state;
        }
    }

    public Object next() {
        boolean traceOn = this.engine.isTraceOn();
        StateFlag answer = this.run();
        if (answer == StateFlag.FAIL || answer == StateFlag.SUSPEND) {
            return answer;
        }
        if (answer == StateFlag.SATISFIED) {
            if (traceOn) {
                logger.info("RETURN: " + this.topTMFrame.lastMatch);
            }
            return this.topTMFrame.lastMatch;
        }
        Triple t = new Triple(LPInterpreter.deref(this.pVars[0]), LPInterpreter.deref(this.pVars[1]), LPInterpreter.derefPossFunctor(this.pVars[2]));
        if (traceOn) {
            logger.info("RETURN: " + t);
        }
        return t;
    }

    public LPBRuleEngine getEngine() {
        return this.engine;
    }

    public FrameObject getChoiceFrame() {
        return this.cpFrame;
    }

    public LPInterpreterContext getContext() {
        return this.iContext;
    }

    /*
     * Unable to fully structure code
     */
    protected StateFlag run() {
        pc = 0;
        ac = 0;
        clause = null;
        choice = null;
        traceOn = this.engine.isTraceOn();
        recordDerivations = this.engine.getDerivationLogging();
        block25: while (this.cpFrame != null) {
            if (this.cpFrame instanceof ChoicePointFrame) {
                choice = (ChoicePointFrame)this.cpFrame;
                if (!choice.hasNext()) {
                    this.cpFrame = choice.getLink();
                    if (!traceOn) continue;
                    LPInterpreter.logger.info("FAIL in clause " + choice.envFrame.clause + " choices exhausted");
                    continue;
                }
                clause = choice.nextClause();
                this.envFrame = recordDerivations != false ? new EnvironmentFrameWithDerivation(clause) : new EnvironmentFrame(clause);
                this.envFrame.linkTo(choice.envFrame);
                this.envFrame.cpc = choice.cpc;
                this.envFrame.cac = choice.cac;
                System.arraycopy(choice.argVars, 0, this.argVars, 0, 8);
                trailMark = choice.trailIndex;
                if (trailMark < this.trail.size()) {
                    this.unwindTrail(trailMark);
                }
                ac = 0;
                pc = 0;
                if (recordDerivations) {
                    ((EnvironmentFrameWithDerivation)this.envFrame).initDerivationRecord(this.argVars);
                }
                if (traceOn) {
                    LPInterpreter.logger.info("ENTER " + clause + " : " + this.getArgTrace());
                }
            } else if (this.cpFrame instanceof TripleMatchFrame) {
                tmFrame = (TripleMatchFrame)this.cpFrame;
                this.envFrame = tmFrame.envFrame;
                clause = this.envFrame.clause;
                trailMark = tmFrame.trailIndex;
                if (trailMark < this.trail.size()) {
                    this.unwindTrail(trailMark);
                }
                if (!tmFrame.nextMatch(this)) {
                    this.cpFrame = this.cpFrame.getLink();
                    if (!traceOn) continue;
                    LPInterpreter.logger.info("TRIPLE match (" + tmFrame.goal + ") -> FAIL");
                    continue;
                }
                if (traceOn) {
                    LPInterpreter.logger.info("TRIPLE match (" + tmFrame.goal + ") -> " + this.getArgTrace());
                    LPInterpreter.logger.info("RENTER " + clause);
                }
                pc = tmFrame.cpc;
                ac = tmFrame.cac;
                if (recordDerivations && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                    ((EnvironmentFrameWithDerivation)this.envFrame).noteMatch(tmFrame.goal, pc);
                }
            } else {
                if (this.cpFrame instanceof TopLevelTripleMatchFrame) {
                    tmFrame = (TopLevelTripleMatchFrame)this.cpFrame;
                    if (!tmFrame.nextMatch(this)) {
                        this.cpFrame = this.cpFrame.getLink();
                        if (!traceOn) continue;
                        LPInterpreter.logger.info("TRIPLE match (" + tmFrame.goal + ") -> FAIL");
                        continue;
                    }
                    if (traceOn) {
                        LPInterpreter.logger.info("TRIPLE match (" + tmFrame.goal + ") ->");
                    }
                    return StateFlag.SATISFIED;
                }
                if (this.cpFrame instanceof ConsumerChoicePointFrame) {
                    ccp = (ConsumerChoicePointFrame)this.cpFrame;
                    this.envFrame = ccp.envFrame;
                    clause = this.envFrame.clause;
                    if (traceOn) {
                        LPInterpreter.logger.info("RESTORE " + clause + ", due to tabled goal " + ccp.generator.goal);
                    }
                    if ((trailMark = ccp.trailIndex) < this.trail.size()) {
                        this.unwindTrail(trailMark);
                    }
                    if ((state = ccp.nextMatch(this)) == StateFlag.FAIL) {
                        this.cpFrame = this.cpFrame.getLink();
                        if (!traceOn) continue;
                        LPInterpreter.logger.info("FAIL " + clause);
                        continue;
                    }
                    if (state == StateFlag.SUSPEND) {
                        this.preserveState(ccp);
                        this.iContext.notifyBlockedOn(ccp);
                        this.cpFrame = this.cpFrame.getLink();
                        if (!traceOn) continue;
                        LPInterpreter.logger.info("SUSPEND " + clause);
                        continue;
                    }
                    pc = ccp.cpc;
                    ac = ccp.cac;
                    if (recordDerivations && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                        ((EnvironmentFrameWithDerivation)this.envFrame).noteMatch(ccp.goal, pc);
                    }
                } else {
                    throw new ReasonerException("Internal error in backward rule system, unrecognized choice point");
                }
            }
            this.engine.incrementProfile(clause);
            block26: while (this.envFrame != null) {
                this.pVars = this.envFrame.pVars;
                code = clause.getCode();
                args = clause.getArgs();
                block27: while (true) {
                    switch (code[pc++]) {
                        case 32: {
                            if (!LPInterpreter.deref(this.argVars[ai = code[pc++]]).isVariable()) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 33: {
                            if (LPInterpreter.deref(this.argVars[ai = code[pc++]]).isVariable()) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 22: {
                            envSize = code[pc++];
                            this.envFrame.allocate(envSize);
                            this.pVars = this.envFrame.pVars;
                            continue block27;
                        }
                        case 2: {
                            yi = code[pc++];
                            ai = code[pc++];
                            this.pVars[yi] = this.argVars[ai];
                            continue block27;
                        }
                        case 4: {
                            ti = code[pc++];
                            ai = code[pc++];
                            this.tVars[ti] = this.argVars[ai];
                            continue block27;
                        }
                        case 1: {
                            ai = code[pc++];
                            arg = this.argVars[ai];
                            if (arg instanceof Node_RuleVariable) {
                                arg = ((Node_RuleVariable)arg).deref();
                            }
                            constant = (Node)args[ac++];
                            if (arg instanceof Node_RuleVariable) {
                                this.bind(arg, constant);
                                continue block27;
                            }
                            if (arg.sameValueAs(constant)) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 10: {
                            func = (Functor)args[ac++];
                            match = false;
                            o = this.argVars[2];
                            if (o instanceof Node_RuleVariable) {
                                o = ((Node_RuleVariable)o).deref();
                            }
                            if (Functor.isFunctor(o)) {
                                funcArg = (Functor)o.getLiteralValue();
                                if (funcArg.getName().equals(func.getName()) && funcArg.getArgLength() == func.getArgLength()) {
                                    fargs = funcArg.getArgs();
                                    for (i = 0; i < fargs.length; ++i) {
                                        this.argVars[i + 3] = fargs[i];
                                    }
                                    match = true;
                                }
                            } else if (o.isVariable()) {
                                fargs = new Node[func.getArgLength()];
                                templateArgs = func.getArgs();
                                for (i = 0; i < fargs.length; ++i) {
                                    template = templateArgs[i];
                                    if (template.isVariable()) {
                                        template = new Node_RuleVariable(null, i + 3);
                                    }
                                    fargs[i] = template;
                                    this.argVars[i + 3] = template;
                                }
                                newFunc = Functor.makeFunctorNode(func.getName(), fargs);
                                this.bind(((Node_RuleVariable)o).deref(), newFunc);
                                match = true;
                            }
                            if (match) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 3: {
                            if (this.unify(this.argVars[ai = code[pc++]], this.pVars[yi = code[pc++]])) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 18: {
                            if (this.unify(this.argVars[ai = code[pc++]], this.tVars[ti = code[pc++]])) continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause);
                            continue block25;
                        }
                        case 6: {
                            yi = code[pc++];
                            ai = code[pc++];
                            this.argVars[ai] = this.pVars[yi] = new Node_RuleVariable(null, (int)yi);
                            continue block27;
                        }
                        case 7: {
                            yi = code[pc++];
                            ai = code[pc++];
                            this.argVars[ai] = this.pVars[yi];
                            continue block27;
                        }
                        case 20: {
                            yi = code[pc++];
                            ai = code[pc++];
                            this.argVars[ai] = LPInterpreter.deref(this.pVars[yi]);
                            continue block27;
                        }
                        case 8: {
                            ti = code[pc++];
                            ai = code[pc++];
                            this.argVars[ai] = this.tVars[ti];
                            continue block27;
                        }
                        case 5: {
                            ai = code[pc++];
                            this.argVars[ai] = (Node)args[ac++];
                            continue block27;
                        }
                        case 16: {
                            ai = code[pc++];
                            this.argVars[ai] = new Node_RuleVariable(null, (int)ai);
                            continue block27;
                        }
                        case 12: {
                            f = (Functor)args[ac++];
                            fargs = new Node[f.getArgLength()];
                            System.arraycopy(this.argVars, 3, fargs, 0, fargs.length);
                            this.argVars[2] = Functor.makeFunctorNode(f.getName(), fargs);
                            continue block27;
                        }
                        case 9: 
                        case 19: {
                            clauses = (List)args[ac++];
                            groundCall = LPInterpreter.isGrounded(this.argVars[0]) != false && LPInterpreter.isGrounded(this.argVars[1]) != false && LPInterpreter.isGrounded(this.argVars[2]) != false;
                            this.setupClauseCall(pc, ac, clauses, groundCall);
                            this.setupTripleMatchCall(pc, ac);
                            continue block25;
                        }
                        case 23: {
                            clauses = (List)args[ac++];
                            if (!this.argVars[2].isVariable()) {
                                clauses = this.engine.getRuleStore().codeFor(new TriplePattern(this.argVars[0], this.argVars[1], this.argVars[2]));
                            }
                            this.setupClauseCall(pc, ac, clauses, false);
                            this.setupTripleMatchCall(pc, ac);
                            continue block25;
                        }
                        case 17: {
                            this.setupTripleMatchCall(pc, ac);
                            continue block25;
                        }
                        case 24: {
                            this.setupTabledCall(pc, ac);
                            continue block25;
                        }
                        case 25: {
                            predicate = LPInterpreter.deref(this.argVars[1]);
                            if (this.engine.getRuleStore().isTabled(predicate)) {
                                this.setupTabledCall(pc, ac);
                                continue block25;
                            }
                            clauses = this.engine.getRuleStore().codeFor(new TriplePattern(this.argVars[0], predicate, this.argVars[2]));
                            if (clauses != null) {
                                this.setupClauseCall(pc, ac, clauses, false);
                            }
                            this.setupTripleMatchCall(pc, ac);
                            continue block25;
                        }
                        case 11: {
                            pc = this.envFrame.cpc;
                            ac = this.envFrame.cac;
                            if (traceOn) {
                                LPInterpreter.logger.info("EXIT " + clause);
                            }
                            if (choice != null) {
                                choice.noteSuccess();
                            }
                            if (recordDerivations && this.envFrame.getRule() != null && this.envFrame instanceof EnvironmentFrameWithDerivation) {
                                efd = (EnvironmentFrameWithDerivation)this.envFrame;
                                result = efd.getResult();
                                matches = efd.getMatchList();
                                infGraph = this.engine.getInfGraph();
                                d = new RuleDerivation(this.envFrame.getRule(), result, matches, infGraph);
                                infGraph.logDerivation(result, d);
                                if (this.envFrame.link instanceof EnvironmentFrameWithDerivation) {
                                    pefd = (EnvironmentFrameWithDerivation)this.envFrame.link;
                                    pefd.noteMatch(new TriplePattern(result), pc);
                                }
                            }
                            this.envFrame = (EnvironmentFrame)this.envFrame.link;
                            if (this.envFrame == null) continue block26;
                            clause = this.envFrame.clause;
                            continue block26;
                        }
                        case 13: {
                            builtin = (Builtin)args[ac++];
                            if (this.context == null) {
                                bbcontext = new BBRuleContext(this.engine.getInfGraph());
                                bbcontext.setEnv(new LPBindingEnvironment(this));
                                this.context = bbcontext;
                            }
                            this.context.setRule(clause.getRule());
                            if (!builtin.bodyCall(this.argVars, code[pc++], this.context)) ** break;
                            continue block27;
                            if (!traceOn) continue block25;
                            LPInterpreter.logger.info("FAIL " + clause + ", due to " + builtin.getName());
                            continue block25;
                        }
                    }
                    break;
                }
                throw new ReasonerException("Internal error in backward rule system\nIllegal op code");
            }
            return StateFlag.ACTIVE;
        }
        return StateFlag.FAIL;
    }

    private String getArgTrace() {
        StringBuffer temp = new StringBuffer();
        temp.append(PrintUtil.print(LPInterpreter.deref(this.argVars[0])));
        temp.append(" ");
        temp.append(PrintUtil.print(LPInterpreter.deref(this.argVars[1])));
        temp.append(" ");
        temp.append(PrintUtil.print(LPInterpreter.deref(this.argVars[2])));
        return temp.toString();
    }

    private void setupTripleMatchCall(int pc, int ac) {
        TripleMatchFrame tmFrame = new TripleMatchFrame(this);
        tmFrame.setContinuation(pc, ac);
        tmFrame.linkTo(this.cpFrame);
        this.cpFrame = tmFrame;
    }

    private void setupClauseCall(int pc, int ac, List clauses, boolean isSingleton) {
        ChoicePointFrame newChoiceFrame = new ChoicePointFrame(this, clauses, isSingleton);
        newChoiceFrame.linkTo(this.cpFrame);
        newChoiceFrame.setContinuation(pc, ac);
        this.cpFrame = newChoiceFrame;
    }

    private void setupTabledCall(int pc, int ac) {
        ConsumerChoicePointFrame ccp = new ConsumerChoicePointFrame(this);
        ccp.linkTo(this.cpFrame);
        ccp.setContinuation(pc, ac);
        this.cpFrame = ccp;
    }

    public void preserveState(ConsumerChoicePointFrame ccp) {
        ccp.preserveState(this.trail);
    }

    public void restoreState(ConsumerChoicePointFrame ccp) {
        this.cpFrame = ccp;
        ccp.restoreState(this);
        this.iContext = ccp.context;
    }

    public boolean unify(Node n1, Node n2) {
        Node nv2;
        Node nv1 = n1;
        if (nv1 instanceof Node_RuleVariable) {
            nv1 = ((Node_RuleVariable)n1).deref();
        }
        if ((nv2 = n2) instanceof Node_RuleVariable) {
            nv2 = ((Node_RuleVariable)n2).deref();
        }
        if (nv1 instanceof Node_RuleVariable) {
            this.bind(nv1, nv2);
            return true;
        }
        if (nv2 instanceof Node_RuleVariable) {
            this.bind(nv2, nv1);
            return true;
        }
        return nv1.sameValueAs(nv2);
    }

    public void bind(Node var, Node val) {
        ((Node_RuleVariable)var).simpleBind(val);
        this.trail.add(var);
    }

    public void unwindTrail(int mark) {
        for (int i = this.trail.size() - 1; i >= mark; --i) {
            Node_RuleVariable var = (Node_RuleVariable)this.trail.get(i);
            var.unbind();
            this.trail.remove(i);
        }
    }

    public static Node deref(Node node) {
        if (node instanceof Node_RuleVariable) {
            return ((Node_RuleVariable)node).deref();
        }
        return node;
    }

    public static boolean isGrounded(Node node) {
        return !(LPInterpreter.deref(node) instanceof Node_RuleVariable);
    }

    public static Triple deref(TriplePattern t) {
        if (t == null) {
            return null;
        }
        return new Triple(LPInterpreter.deref(t.getSubject()), LPInterpreter.deref(t.getPredicate()), LPInterpreter.deref(t.getObject()));
    }

    public static Node derefPossFunctor(Node node) {
        if (node instanceof Node_RuleVariable) {
            Node dnode = ((Node_RuleVariable)node).deref();
            if (dnode.isVariable()) {
                throw new ReasonerException("Internal error in LP reasoner: variable in triple result");
            }
            if (Functor.isFunctor(dnode)) {
                Functor f = (Functor)dnode.getLiteralValue();
                Node[] fargs = f.getArgs();
                boolean needCopy = false;
                for (int i = 0; i < fargs.length; ++i) {
                    if (!fargs[i].isVariable()) continue;
                    needCopy = true;
                    break;
                }
                if (needCopy) {
                    Node[] newArgs = new Node[fargs.length];
                    for (int i = 0; i < fargs.length; ++i) {
                        newArgs[i] = LPInterpreter.deref(fargs[i]);
                    }
                    dnode = Functor.makeFunctorNode(f.getName(), newArgs);
                }
                return dnode;
            }
            return dnode;
        }
        return node;
    }

    private Node standardize(Node node, Map mappedVars) {
        Node dnode = LPInterpreter.deref(node);
        if (node == Node.ANY || node == Node_RuleVariable.WILD) {
            return new Node_RuleVariable(null, 0);
        }
        if (dnode.isVariable()) {
            Node mnode = (Node)mappedVars.get(dnode);
            if (mnode == null) {
                mnode = new Node_RuleVariable(null, 0);
                mappedVars.put(dnode, mnode);
            }
            return mnode;
        }
        return dnode;
    }
}

