/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.util.TranslationTable;

public class Syntax
extends Symbol {
    public static final Syntax syntaxSPARQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL");
    public static final Syntax syntaxARQ = new Syntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
    public static final Syntax syntaxRDQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/RDQL");
    public static final Syntax syntaxAlgebra = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_Algebra");
    public static TranslationTable querySyntaxNames = new TranslationTable(true);
    public static Syntax defaultSyntax;

    protected Syntax(String s) {
        super(s);
    }

    protected Syntax(Syntax s) {
        super(s);
    }

    public static Syntax make(String uri) {
        if (uri == null) {
            return null;
        }
        Symbol sym2 = Symbol.create(uri);
        if (sym2.equals(syntaxARQ)) {
            return syntaxARQ;
        }
        if (sym2.equals(syntaxRDQL)) {
            return syntaxRDQL;
        }
        if (sym2.equals(syntaxSPARQL)) {
            return syntaxSPARQL;
        }
        if (sym2.equals(syntaxAlgebra)) {
            return syntaxAlgebra;
        }
        return null;
    }

    public static Syntax guessQueryFileSyntax(String url) {
        return Syntax.guessQueryFileSyntax(url, syntaxSPARQL);
    }

    public static Syntax guessQueryFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return syntaxSPARQL;
        }
        if (url.endsWith(".rdql")) {
            return syntaxRDQL;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax lookup(String s) {
        return (Syntax)querySyntaxNames.lookup(s);
    }

    static {
        querySyntaxNames.put("sparql", syntaxSPARQL);
        querySyntaxNames.put("arq", syntaxARQ);
        querySyntaxNames.put("rdql", syntaxRDQL);
        querySyntaxNames.put("alg", syntaxAlgebra);
        querySyntaxNames.put("op", syntaxAlgebra);
        defaultSyntax = syntaxSPARQL;
    }
}

