## ----env, echo=FALSE-------------------------------------------------------
library("BiocStyle")

## ----loadPkgs, message = FALSE, warning = FALSE----------------------------
library("pRolocGUI")
library("pRolocdata")

## ----loadData, echo = TRUE, message = FALSE, warning = FALSE---------------
data(hyperLOPIT2015) 

## ----example, eval = FALSE, echo = TRUE------------------------------------
#  pRolocVis(object = hyperLOPIT2015, fcol = "markers")

## ----pca1, eval = FALSE, echo = TRUE---------------------------------------
#  pRolocVis(object = hyperLOPIT2015, fcol = "markers")

## ----classify, eval = TRUE, echo = TRUE, warning = FALSE-------------------
opt <- svmOptimisation(object = hyperLOPIT2015, 
                       fcol = "markers", 
                       times = 3, verbose = FALSE)
res <- svmClassification(object = hyperLOPIT2015, assessRes = opt) 

## ----cutoff, eval = FALSE, echo = TRUE-------------------------------------
#  pRolocVis(object = res, app = "classify", fcol = "svm")

## ----score, eval=FALSE-----------------------------------------------------
#  mythreshold <- pRolocVis(object = res, app = "classify", fcol = "svm")
#  res <- getPredictions(res, fcol = "svm",
#                        mcol = "markers", t = mythreshold)

## ----compare, eval = FALSE, echo = TRUE------------------------------------
#  data(hyperLOPIT2015ms3r1)
#  data(hyperLOPIT2015ms3r2)
#  mydata <- MSnSetList(list(hyperLOPIT2015ms3r1, hyperLOPIT2015ms3r2))
#  pRolocVis(mydata, app = "compare")

