## ----include=FALSE-------------------------------------------------------
knitr::opts_chunk$set(warning = FALSE,
                      message = TRUE)

library(DOSE)
library(org.Hs.eg.db)
library(ggplot2)
library(ggraph)
library(cowplot)
library(UpSetR)
library(enrichplot)

CRANpkg <- function (pkg) {
    cran <- "https://CRAN.R-project.org/package"
    fmt <- "[%s](%s=%s)"
    sprintf(fmt, pkg, cran, pkg)
}

Biocpkg <- function (pkg) {
    sprintf("[%s](http://bioconductor.org/packages/%s)", pkg, pkg)
}

## ----fig.width=12, fig.height=8------------------------------------------
library(DOSE)
data(geneList)
de <- names(geneList)[abs(geneList) > 2]

edo <- enrichDGN(de)

## ----message=FALSE-------------------------------------------------------
edo2 <- gseNCG(geneList, nPerm=10000)

## ----fig.width=12, fig.height=8------------------------------------------
barplot(edo, showCategory=20)

## ----fig.width=12, fig.height=8------------------------------------------
p1 <- dotplot(edo, showCategory=30) + ggtitle("dotplot for ORA")
p2 <- dotplot(edo2, showCategory=30) + ggtitle("dotplot for GSEA")
plot_grid(p1, p2, ncol=2)

## ------------------------------------------------------------------------
N <- as.numeric(sub("\\d+/", "", edo[1, "BgRatio"]))
N
dotplot(edo, showCategory=15, x = ~Count/N) + ggplot2::xlab("Rich Factor")

## ----fig.width=12, fig.height=8------------------------------------------
## convert gene ID to Symbol
edox <- setReadable(edo, 'org.Hs.eg.db', 'ENTREZID')
cnetplot(edox, foldChange=geneList)
cnetplot(edox, foldChange=geneList, circular = TRUE, colorEdge = TRUE)

## ----fig.width=12, fig.height=5------------------------------------------
upsetplot(edo)

## ----fig.width=16, fig.height=4------------------------------------------
heatplot(edox)
heatplot(edox, foldChange=geneList)

## ----fig.width=12, fig.height=10-----------------------------------------
emapplot(edo)

## ----fig.width=12, fig.height=8, message=FALSE---------------------------
ridgeplot(edo2)

## ----fig.width=12, fig.height=4------------------------------------------
gseaplot(edo2, geneSetID = 1, by = "runningScore", title = edo2$Description[1])
gseaplot(edo2, geneSetID = 1, by = "preranked", title = edo2$Description[1])

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot(edo2, geneSetID = 1, title = edo2$Description[1])

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot2(edo2, geneSetID = 1, title = edo2$Description[1])

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot2(edo2, geneSetID = 1:3)

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot2(edo2, geneSetID = 1:3, pvalue_table = TRUE,
          color = c("#E495A5", "#86B875", "#7DB0DD"), ES_geom = "dot")

## ----fig.width=12, fig.height=4------------------------------------------
gseaplot2(edo2, geneSetID = 1:3, subplots = 1)

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot2(edo2, geneSetID = 1:3, subplots = 1:2)

## ----fig.width=8, fig.height=4-------------------------------------------
gsearank(edo2, 1, title = edo2[1, "Description"])

## ----fig.width=8, fig.height=6-------------------------------------------
pp <- lapply(1:3, function(i) {
    anno <- edo2[i, c("NES", "pvalue", "p.adjust")]
    lab <- paste0(names(anno), "=",  round(anno, 3), collapse="\n")

    gsearank(edo2, i, edo2[i, 2]) + xlab(NULL) +ylab(NULL) +
        annotate("text", 0, edo2[i, "enrichmentScore"] * .9, label = lab, hjust=0, vjust=0)
})
plot_grid(plotlist=pp, ncol=1)

## ----fig.width=12, fig.height=4------------------------------------------
terms <- edo$Description[1:3]
p <- pmcplot(terms, 2010:2017)
p2 <- pmcplot(terms, 2010:2017, proportion=FALSE)
plot_grid(p, p2, ncol=2)

