## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"-----------------------------
BiocStyle::latex()

## ----include=FALSE------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance = TRUE,
background = "#f3f3ff"
)

## ----req----------------------------------------------------------------------------
library("SparseSignatures")
data(ssm560_reduced)
head(ssm560_reduced)

## ----example_import-----------------------------------------------------------------
library("BSgenome.Hsapiens.1000genomes.hs37d5")
bsg = BSgenome.Hsapiens.1000genomes.hs37d5
data(mutation_categories)
head(mutation_categories)
imported_data = import.counts.data(input=ssm560_reduced,bsg=bsg,mutation_categories=mutation_categories)
head(imported_data)

## ----image-1, fig.show='hide', fig.width=5, fig.height=5, results='hide'------------
patient.plot(countMatrix=imported_data,patientName="PD10010a")

## ----patients_data------------------------------------------------------------------
data(patients)
head(patients)

## ----starting_betas,eval=FALSE------------------------------------------------------
#  starting_betas = starting.betas.estimation(x=patients,K=3:12,background_signature=background)

## ----lambda_range,eval=FALSE--------------------------------------------------------
#  lambda_range = evaluate.lambda.range(x=patients,K=10,beta=starting_betas[[8,1]],
#                                       lambda_values=c(0.05,0.10))

## ----example_data-------------------------------------------------------------------
data(starting_betas_example)
data(lambda_range_example)

## ----example_small------------------------------------------------------------------
# example of using too small a value of lambda
# the log-likelihood is very unstable across the iterations
res = as.loglik.progression.in.range(lambda.range.result=lambda_range_example,lambda_value=0.01)

## ----image-2, fig.show='hide', fig.width=5, fig.height=5,results='hide'-------------
plot(res)

## ----example_big--------------------------------------------------------------------
# example of using too high a value of lambda
# the log-likelihood drops after the first iteration
res = as.loglik.progression.in.range(lambda.range.result=lambda_range_example,lambda_value=0.30)

## ----image-3, fig.show='hide', fig.width=5, fig.height=5,results='hide'-------------
plot(res)

## ----example_good-------------------------------------------------------------------
# example of using a good value of lambda
# the log-likelihood is increasing across the iterations
res = as.loglik.progression.in.range(lambda.range.result=lambda_range_example,lambda_value=0.15)

## ----image-4, fig.show='hide', fig.width=5, fig.height=5,results='hide'-------------
plot(res)

## ----cross_validation,eval=FALSE----------------------------------------------------
#  cv = nmf.LassoCV(x=patients,K=3:10)

## ----example_data_cv----------------------------------------------------------------
data(cv_example)

## ----best_configuation--------------------------------------------------------------
res = as.mean.squared.error(cv_example)$median
res_best = which(res==res[which.min(res)],arr.ind=TRUE)
best_K = rownames(res)[res_best[1]]
best_lambda = colnames(res)[res_best[2]]
best_K
best_lambda

## ----best_configuation_signatures---------------------------------------------------
beta = starting_betas_example[["5_signatures","Value"]]
res = nmf.LassoK(x=patients,K=5,beta=beta,background=background,lambda_rate=0.10,
                 iterations=5,num_processes=NA)

## ----image-5, fig.show='hide', fig.width=5, fig.height=5, results='hide'------------
signatures = as.beta(res)
signatures.plot(beta=signatures, xlabels=FALSE)

## ----sessioninfo,results='asis',echo=FALSE------------------------------------------
toLatex(sessionInfo())

