### R code from vignette source 'HiCBricks-Vignette.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: HiCBricks-Vignette.Rnw:126-127
###################################################
options(width=80)


###################################################
### code chunk number 2: HiCBricks-Vignette.Rnw:143-146 (eval = FALSE)
###################################################
## curl_download(url = "https://data.4dnucleome.org/files-
##     processed/4DNFI7JNCNFB/@@download/4DNFI7JNCNFB.mcool",
##     destfile = "H1-hESC-HiC-4DNFI7JNCNFB.mcool")


###################################################
### code chunk number 3: HiCBricks-Vignette.Rnw:161-163 (eval = FALSE)
###################################################
## 
## Brick_list_mcool_normalisations(names.only = TRUE)


###################################################
### code chunk number 4: HiCBricks-Vignette.Rnw:170-172 (eval = FALSE)
###################################################
## 
## Brick_list_mcool_normalisations(names.only = FALSE)


###################################################
### code chunk number 5: HiCBricks-Vignette.Rnw:178-181 (eval = FALSE)
###################################################
## 
## mcoolName="H1-hESC-HiC-4DNFI7JNCNFB.mcool"
## Brick_list_mcool_resolutions(mcool = filename)


###################################################
### code chunk number 6: HiCBricks-Vignette.Rnw:210-230 (eval = FALSE)
###################################################
## 
## Output.brick <- "H1-hESC-HiC-4DNFI7JNCNFB-10000-ICE-
##     normalised-chr1.brick"
## mcool <- mcoolName
## 
## CreateBrick_from_mcool(Brick = Output.brick, 
##     mcool = mcool, 
##     binsize = 10000, 
##     chrs = "chr1")
## 
## Brick_load_data_from_mcool(Brick = Output.brick, 
##     mcool = mcool, 
##     chr1 = "chr1", 
##     chr2 = "chr1", 
##     binsize = 10000,
##     cooler.batch.size = 1000000, 
##     matrix.chunk = 2000, 
##     dont.look.for.chr2 = TRUE, 
##     remove.prior = TRUE,
##     norm.factor = "Iterative-Correction")


###################################################
### code chunk number 7: HiCBricks-Vignette.Rnw:259-303
###################################################

library("HiCBricks")

Bintable.path <- system.file("extdata", 
    "Bintable_40kb.txt", 
    package = "HiCBricks")

Chromosomes <- "chr19"

Output.Filename <- "test.hdf"



Path_to_cached_file <- CreateBrick(ChromNames = Chromosomes, 
    BinTable = Bintable.path, 
    bin.delim = " ", 
    Output.Filename = Output.Filename, 
    exec = "cat", 
    remove.existing = TRUE)



Test.mat <- matrix(NA,nrow = 800, ncol = 800)
Row <- row(Test.mat)
Col <- col(Test.mat)
Dist <- Col - Row
Matrix.file <- "Test_matrix.txt"

write.table(x = Dist, 
    file = Matrix.file, 
    sep = " ", 
    quote = FALSE,
    row.names = FALSE, 
    col.names = FALSE)

Brick.file <- Path_to_cached_file

Brick_load_matrix(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19",
    matrix.file = Matrix.file, 
    delim = " ", 
    exec = "cat",
    remove.prior = TRUE)


###################################################
### code chunk number 8: HiCBricks-Vignette.Rnw:309-316
###################################################

Brick_load_cis_matrix_till_distance(Brick = Brick.file, 
    chr = "chr19", 
    matrix.file = Matrix.file, 
    delim = " ", 
    distance = 100, 
    remove.prior = TRUE)


###################################################
### code chunk number 9: HiCBricks-Vignette.Rnw:327-333
###################################################

Brick.file <- system.file("extdata", 
    "test.hdf", 
    package = "HiCBricks")

Brick_list_rangekeys(Brick.file)


###################################################
### code chunk number 10: HiCBricks-Vignette.Rnw:340-342
###################################################

Brick_get_bintable(Brick.file)


###################################################
### code chunk number 11: HiCBricks-Vignette.Rnw:348-351
###################################################

Brick_get_ranges(Brick = Brick.file, 
    rangekey = "Bintable")


###################################################
### code chunk number 12: HiCBricks-Vignette.Rnw:357-361
###################################################

Brick_get_ranges(Brick = Brick.file, 
    rangekey = "Bintable", 
    chr = "chr19")


###################################################
### code chunk number 13: HiCBricks-Vignette.Rnw:369-373
###################################################

testRun=Brick_return_region_position(Brick = Brick.file, 
    region = "chr19:5000000:10000000")
head(testRun)


###################################################
### code chunk number 14: HiCBricks-Vignette.Rnw:383-388
###################################################

testRun=Brick_fetch_range_index(Brick = Brick.file, 
    chr = "chr19", 
    start = 5000000, 
    end = 10000000)


###################################################
### code chunk number 15: HiCBricks-Vignette.Rnw:412-416
###################################################

Values <- Brick_get_values_by_distance(Brick = Brick.file, 
    chr = "chr19", 
    distance = 4)


###################################################
### code chunk number 16: HiCBricks-Vignette.Rnw:421-431
###################################################

Failsafe_median_log10 <- function(x){
    x[is.na(x) | is.nan(x) | is.infinite(x)] <- 0
    return(median(log10(x+1)))
}

Brick_get_values_by_distance(Brick = Brick.file, 
    chr = "chr19", 
    distance = 4, 
    FUN = Failsafe_median_log10)


###################################################
### code chunk number 17: HiCBricks-Vignette.Rnw:438-449
###################################################

Failsafe_median_log10 <- function(x){
    x[is.na(x) | is.nan(x) | is.infinite(x)] <- 0
    return(median(log10(x+1)))
}

Brick_get_values_by_distance(Brick = Brick.file, 
    chr = "chr19", 
    distance = 4, 
    constrain.region = "chr19:1:5000000", 
    FUN = Failsafe_median_log10)


###################################################
### code chunk number 18: HiCBricks-Vignette.Rnw:457-462
###################################################

Sub.matrix <- Brick_get_matrix_within_coords(Brick = Brick.file, 
    x.coords="chr19:5000001:10000000", 
    force = TRUE,
    y.coords = "chr19:5000001:10000000")


###################################################
### code chunk number 19: HiCBricks-Vignette.Rnw:467-476
###################################################

x.axis <- 5000000/40000
y.axis <- 10000000/40000

Sub.matrix <- Brick_get_matrix(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19", 
    x.vector = c(x.axis:y.axis), 
    y.vector = c(x.axis:y.axis))


###################################################
### code chunk number 20: HiCBricks-Vignette.Rnw:489-500
###################################################

Coordinate <- c("chr19:1:40000","chr19:40001:80000")
Brick.file <- system.file("extdata", 
    "test.hdf", 
    package = "HiCBricks")
Test_Run <- Brick_fetch_row_vector(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19", 
    by = "ranges", 
    vector = Coordinate,
    regions = c("chr19:1:1000000", "chr19:40001:2000000"))


###################################################
### code chunk number 21: HiCBricks-Vignette.Rnw:505-516
###################################################

Coordinate <- c(1,2)
Brick.file <- system.file("extdata", 
    "test.hdf", 
    package = "HiCBricks")
Test_Run <- Brick_fetch_row_vector(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19", 
    by = "position", 
    vector = Coordinate,
    regions = c("chr19:1:1000000", "chr19:40001:2000000"))


###################################################
### code chunk number 22: HiCBricks-Vignette.Rnw:539-541
###################################################

Brick_list_matrix_mcols()


###################################################
### code chunk number 23: HiCBricks-Vignette.Rnw:546-555
###################################################

Brick.file <- system.file("extdata", 
    "test.hdf", 
    package = "HiCBricks")
testRun <- Brick_get_matrix_mcols(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19", 
    what = "row.sums")



###################################################
### code chunk number 24: HiCBricks-Vignette.Rnw:565-569
###################################################

Brick_matrix_isdone(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 25: HiCBricks-Vignette.Rnw:574-578
###################################################

Brick_matrix_issparse(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 26: HiCBricks-Vignette.Rnw:583-587
###################################################

Brick_matrix_maxdist(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 27: HiCBricks-Vignette.Rnw:592-596
###################################################

Brick_matrix_minmax(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 28: HiCBricks-Vignette.Rnw:601-605
###################################################

Brick_matrix_minmax(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 29: HiCBricks-Vignette.Rnw:610-614
###################################################

Brick_matrix_dimensions(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 30: HiCBricks-Vignette.Rnw:619-623
###################################################

Brick_matrix_filename(Brick = Brick.file, 
    chr1 = "chr19", 
    chr2 = "chr19")


###################################################
### code chunk number 31: HiCBricks-Vignette.Rnw:639-655
###################################################

Brick.file <- system.file("extdata", 
    "test.hdf", 
    package = "HiCBricks")


Chromosome <- "chr19"
di_window <- 10
lookup_window <- 30
TAD_ranges <- Brick_local_score_differentiator(Brick = Brick.file, 
    chrs = Chromosome, 
    di.window = di_window, 
    lookup.window = lookup_window, 
    strict = TRUE, 
    fill.gaps=TRUE, 
    chunk.size = 500)


###################################################
### code chunk number 32: HiCBricks-Vignette.Rnw:673-681
###################################################

Name <- paste("LSD",
    di_window,
    lookup_window,
    Chromosome,sep = "_")
Brick_add_ranges(Brick = Path_to_cached_file, 
    ranges = TAD_ranges, 
    rangekey = Name)


###################################################
### code chunk number 33: HiCBricks-Vignette.Rnw:693-697
###################################################

Brick_list_rangekeys(Brick = Path_to_cached_file)
TAD_ranges <- Brick_get_ranges(Brick = Path_to_cached_file, 
    rangekey = Name)


###################################################
### code chunk number 34: chr19-5MB-10MB-normal
###################################################
Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal.pdf", 
    Bricks = Brick.file, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    palette = "Reds", 
    width = 10, 
    height = 11, 
    return.object=TRUE)


###################################################
### code chunk number 35: chr19-5MB-10MB-normal2 (eval = FALSE)
###################################################
## 
## Failsafe_log10 <- function(x){
##     x[is.na(x) | is.nan(x) | is.infinite(x)] <- 0
##     return(log10(x+1))
## }
## 
## Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal2.pdf", 
##     Bricks = Brick.file, 
##     x.coords = "chr19:5000000:10000000", 
##     y.coords = "chr19:5000000:10000000", 
##     FUN = Failsafe_log10, 
##     legend.title = "Log10 Hi-C signal", 
##     palette = "Reds", 
##     width = 10, 
##     height = 11,
##     return.object=TRUE)


###################################################
### code chunk number 36: chr19-5MB-10MB-normal2
###################################################

Failsafe_log10 <- function(x){
    x[is.na(x) | is.nan(x) | is.infinite(x)] <- 0
    return(log10(x+1))
}

Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal2.pdf", 
    Bricks = Brick.file, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    FUN = Failsafe_log10, 
    legend.title = "Log10 Hi-C signal", 
    palette = "Reds", 
    width = 10, 
    height = 11,
    return.object=TRUE)


###################################################
### code chunk number 37: chr19-5MB-10MB-normal3
###################################################
Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal3.pdf", 
    Bricks = Brick.file, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    FUN = Failsafe_log10, 
    value.cap = 0.99, 
    legend.title = "Log10 Hi-C signal", 
    palette = "Reds", 
    width = 10, 
    height = 11, 
    return.object=TRUE)


###################################################
### code chunk number 38: chr19-5MB-10MB-normal4
###################################################

Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal4.pdf", 
    Bricks = Brick.file, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    FUN = Failsafe_log10, 
    value.cap = 0.99, 
    legend.title = "Log10 Hi-C signal", 
    palette = "Reds", 
    width = 10, 
    height = 11, 
    rotate = TRUE,
    return.object=TRUE)


###################################################
### code chunk number 39: chr19-5MB-10MB-normal5
###################################################
Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal5.pdf", 
    Bricks = Brick.file, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    FUN = Failsafe_log10, 
    value.cap = 0.99, 
    legend.title = "Log10 Hi-C signal", 
    palette = "cividis", 
    width = 15, 
    height = 5, 
    rotate = TRUE,
    return.object=TRUE)


###################################################
### code chunk number 40: chr19-5MB-10MB-normal6
###################################################
Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal6.pdf", 
    Bricks = Brick.file, 
    tad.ranges = TAD_ranges, 
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    colours = "#E0CA3C", 
    FUN = Failsafe_log10, 
    value.cap = 0.99, 
    legend.title = "Log10 Hi-C signal", 
    palette = "Reds", 
    width = 10, 
    height = 11,
    return.object=TRUE)


###################################################
### code chunk number 41: chr19-5MB-10MB-normal7
###################################################
Brick_vizart_plot_heatmap(File = "chr19-5MB-10MB-normal.pdf", 
    Bricks = Brick.file, 
    tad.ranges = TAD_ranges,
    x.coords = "chr19:5000000:10000000", 
    y.coords = "chr19:5000000:10000000", 
    colours = "red",
    FUN = Failsafe_log10, 
    value.cap = 0.99, 
    legend.title = "Log10 Hi-C signal", 
    palette = "cividis", 
    width = 15, 
    height = 9,
    cut.corners = TRUE,
    rotate = TRUE,
    return.object=TRUE) 


