/*
 * Decompiled with CFR 0.152.
 */
package fing.model;

import cytoscape.graph.dynamic.DynamicGraph;
import cytoscape.graph.dynamic.util.DynamicGraphFactory;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.util.intr.IntArray;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntIntHash;
import cytoscape.util.intr.IntIterator;
import cytoscape.util.intr.MinIntHeap;
import fing.model.FRootGraph;
import fing.model.GraphPerspectiveChangeListenerChain;
import fing.model.GraphPerspectiveEdgesHiddenEvent;
import fing.model.GraphPerspectiveEdgesRestoredEvent;
import fing.model.GraphPerspectiveNodesHiddenEvent;
import fing.model.GraphPerspectiveNodesRestoredEvent;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import giny.model.RootGraph;
import giny.model.RootGraphChangeEvent;
import giny.model.RootGraphChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class FGraphPerspective
implements GraphPerspective,
FixedGraph {
    private final MinIntHeap m_heap__restoreEdge = new MinIntHeap();
    private final DynamicGraph m_graph = DynamicGraphFactory.instantiateDynamicGraph();
    private final FRootGraph m_root;
    private final GraphPerspectiveChangeListener[] m_lis;
    private final IntArray m_nativeToRootNodeInxMap;
    private final IntArray m_nativeToRootEdgeInxMap;
    private final IntIntHash m_rootToNativeNodeInxMap;
    private final IntIntHash m_rootToNativeEdgeInxMap;
    private final MinIntHeap m_heap;
    private final IntHash m_hash;
    private final GraphWeeder m_weeder;
    private final RootGraphChangeSniffer m_changeSniffer;

    public IntEnumerator nodes() {
        final IntEnumerator nativeNodes = this.m_graph.nodes();
        return new IntEnumerator(){

            public int numRemaining() {
                return nativeNodes.numRemaining();
            }

            public int nextInt() {
                return ~FGraphPerspective.this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeNodes.nextInt());
            }
        };
    }

    public IntEnumerator edges() {
        final IntEnumerator nativeEdges = this.m_graph.edges();
        return new IntEnumerator(){

            public int numRemaining() {
                return nativeEdges.numRemaining();
            }

            public int nextInt() {
                return ~FGraphPerspective.this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeEdges.nextInt());
            }
        };
    }

    public boolean nodeExists(int node) {
        if (node < 0) {
            return false;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(node);
        return this.m_graph.nodeExists(nativeNodeInx);
    }

    public byte edgeType(int edge) {
        if (edge < 0) {
            return -1;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(edge);
        return this.m_graph.edgeType(nativeEdgeInx);
    }

    public int edgeSource(int edge) {
        if (edge < 0) {
            return -1;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(edge);
        int nativeSource = this.m_graph.edgeSource(nativeEdgeInx);
        if (nativeSource < 0) {
            return -1;
        }
        return ~this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeSource);
    }

    public int edgeTarget(int edge) {
        if (edge < 0) {
            return -1;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(edge);
        int nativeTarget = this.m_graph.edgeTarget(nativeEdgeInx);
        if (nativeTarget < 0) {
            return -1;
        }
        return ~this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeTarget);
    }

    public IntEnumerator edgesAdjacent(int node, boolean outgoing, boolean incoming, boolean undirected) {
        if (node < 0) {
            return null;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(node);
        final IntEnumerator nativeEdges = this.m_graph.edgesAdjacent(nativeNodeInx, outgoing, incoming, undirected);
        if (nativeEdges == null) {
            return null;
        }
        return new IntEnumerator(){

            public int numRemaining() {
                return nativeEdges.numRemaining();
            }

            public int nextInt() {
                return ~FGraphPerspective.this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeEdges.nextInt());
            }
        };
    }

    public IntIterator edgesConnecting(int node0, int node1, boolean outgoing, boolean incoming, boolean undirected) {
        int nativeNode1Inx;
        if (node0 < 0 || node1 < 0) {
            return null;
        }
        int nativeNode0Inx = this.m_rootToNativeNodeInxMap.get(node0);
        final IntIterator nativeEdges = this.m_graph.edgesConnecting(nativeNode0Inx, nativeNode1Inx = this.m_rootToNativeNodeInxMap.get(node1), outgoing, incoming, undirected);
        if (nativeEdges == null) {
            return null;
        }
        return new IntIterator(){

            public boolean hasNext() {
                return nativeEdges.hasNext();
            }

            public int nextInt() {
                return ~FGraphPerspective.this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeEdges.nextInt());
            }
        };
    }

    public void addGraphPerspectiveChangeListener(GraphPerspectiveChangeListener listener) {
        this.m_lis[0] = GraphPerspectiveChangeListenerChain.add(this.m_lis[0], listener);
    }

    public void removeGraphPerspectiveChangeListener(GraphPerspectiveChangeListener listener) {
        this.m_lis[0] = GraphPerspectiveChangeListenerChain.remove(this.m_lis[0], listener);
    }

    public Object clone() {
        final IntEnumerator nativeNodes = this.m_graph.nodes();
        IntIterator rootGraphNodeInx = new IntIterator(){

            public boolean hasNext() {
                return nativeNodes.numRemaining() > 0;
            }

            public int nextInt() {
                return FGraphPerspective.this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeNodes.nextInt());
            }
        };
        final IntEnumerator nativeEdges = this.m_graph.edges();
        IntIterator rootGraphEdgeInx = new IntIterator(){

            public boolean hasNext() {
                return nativeEdges.numRemaining() > 0;
            }

            public int nextInt() {
                return FGraphPerspective.this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeEdges.nextInt());
            }
        };
        return new FGraphPerspective(this.m_root, rootGraphNodeInx, rootGraphEdgeInx);
    }

    public RootGraph getRootGraph() {
        return this.m_root;
    }

    public int getNodeCount() {
        return this.m_graph.nodes().numRemaining();
    }

    public int getEdgeCount() {
        return this.m_graph.edges().numRemaining();
    }

    public Iterator nodesIterator() {
        final IntEnumerator nodes = this.m_graph.nodes();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return nodes.numRemaining() > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FGraphPerspective.this.m_root.getNode(FGraphPerspective.this.m_nativeToRootNodeInxMap.getIntAtIndex(nodes.nextInt()));
            }
        };
    }

    public List nodesList() {
        int nodeCount = this.getNodeCount();
        ArrayList returnThis = new ArrayList(nodeCount);
        Iterator iter = this.nodesIterator();
        for (int i = 0; i < nodeCount; ++i) {
            returnThis.add(iter.next());
        }
        return returnThis;
    }

    public int[] getNodeIndicesArray() {
        IntEnumerator nodes = this.m_graph.nodes();
        int[] returnThis = new int[nodes.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.m_nativeToRootNodeInxMap.getIntAtIndex(nodes.nextInt());
        }
        return returnThis;
    }

    public Iterator edgesIterator() {
        final IntEnumerator edges = this.m_graph.edges();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return edges.numRemaining() > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FGraphPerspective.this.m_root.getEdge(FGraphPerspective.this.m_nativeToRootEdgeInxMap.getIntAtIndex(edges.nextInt()));
            }
        };
    }

    public List edgesList() {
        int edgeCount = this.getEdgeCount();
        ArrayList returnThis = new ArrayList(edgeCount);
        Iterator iter = this.edgesIterator();
        for (int i = 0; i < edgeCount; ++i) {
            returnThis.add(iter.next());
        }
        return returnThis;
    }

    public int[] getEdgeIndicesArray() {
        IntEnumerator edges = this.m_graph.edges();
        int[] returnThis = new int[edges.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.m_nativeToRootEdgeInxMap.getIntAtIndex(edges.nextInt());
        }
        return returnThis;
    }

    public int[] getEdgeIndicesArray(int rootGraphFromNodeInx, int rootGraphToNodeInx, boolean undirectedEdges, boolean bothDirections) {
        int nativeToNodeInx;
        if (rootGraphFromNodeInx >= 0 || rootGraphToNodeInx >= 0) {
            return null;
        }
        int nativeFromNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphFromNodeInx);
        IntIterator connectingEdges = this.m_graph.edgesConnecting(nativeFromNodeInx, nativeToNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphToNodeInx), true, bothDirections, undirectedEdges);
        if (connectingEdges == null) {
            return null;
        }
        this.m_heap.empty();
        MinIntHeap edgeBucket = this.m_heap;
        while (connectingEdges.hasNext()) {
            edgeBucket.toss(this.m_nativeToRootEdgeInxMap.getIntAtIndex(connectingEdges.nextInt()));
        }
        int[] returnThis = new int[edgeBucket.size()];
        edgeBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public Node hideNode(Node node) {
        if (node.getRootGraph() == this.m_root && this.hideNode(node.getRootGraphIndex()) != 0) {
            return node;
        }
        return null;
    }

    public int hideNode(int rootGraphNodeInx) {
        return this.m_weeder.hideNode(this, rootGraphNodeInx);
    }

    public List hideNodes(List nodes) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.hideNode((Node)nodes.get(i)) == null) continue;
            returnThis.add(nodes.get(i));
        }
        return returnThis;
    }

    public int[] hideNodes(int[] rootGraphNodeInx) {
        return this.m_weeder.hideNodes(this, rootGraphNodeInx);
    }

    public Node restoreNode(Node node) {
        if (node.getRootGraph() == this.m_root && this.restoreNode(node.getRootGraphIndex()) != 0) {
            return node;
        }
        return null;
    }

    public int restoreNode(int rootGraphNodeInx) {
        GraphPerspectiveChangeListener listener;
        int returnThis = this._restoreNode(rootGraphNodeInx) != 0 ? rootGraphNodeInx : 0;
        if (returnThis != 0 && (listener = this.m_lis[0]) != null) {
            listener.graphPerspectiveChanged(new GraphPerspectiveNodesRestoredEvent(this, new int[]{rootGraphNodeInx}));
        }
        return returnThis;
    }

    private int _restoreNode(int rootGraphNodeInx) {
        if (rootGraphNodeInx >= 0) {
            return 0;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeInx);
        if (this.m_root.getNode(rootGraphNodeInx) == null || nativeNodeInx >= 0 && nativeNodeInx != Integer.MAX_VALUE) {
            return 0;
        }
        nativeNodeInx = this.m_graph.nodeCreate();
        this.m_rootToNativeNodeInxMap.put(~rootGraphNodeInx, nativeNodeInx);
        this.m_nativeToRootNodeInxMap.setIntAtIndex(rootGraphNodeInx, nativeNodeInx);
        return ~nativeNodeInx;
    }

    public List restoreNodes(List nodes) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.restoreNode((Node)nodes.get(i)) == null) continue;
            returnThis.add(nodes.get(i));
        }
        return returnThis;
    }

    public List restoreNodes(List nodes, boolean restoreIncidentEdges) {
        List returnThis = this.restoreNodes(nodes);
        int[] restoredNodeInx = new int[returnThis.size()];
        for (int i = 0; i < restoredNodeInx.length; ++i) {
            restoredNodeInx[i] = ((Node)returnThis.get(i)).getRootGraphIndex();
        }
        int[] connectingEdgeInx = this.m_root.getConnectingEdgeIndicesArray(restoredNodeInx);
        this.restoreEdges(connectingEdgeInx);
        return returnThis;
    }

    public int[] restoreNodes(int[] rootGraphNodeInx, boolean restoreIncidentEdges) {
        int[] returnThis = this.restoreNodes(rootGraphNodeInx);
        int[] connectingEdgeInx = this.m_root.getConnectingEdgeIndicesArray(returnThis);
        this.restoreEdges(connectingEdgeInx);
        return returnThis;
    }

    public int[] restoreNodes(int[] rootGraphNodeInx) {
        GraphPerspectiveChangeListener listener;
        this.m_heap.empty();
        MinIntHeap successes = this.m_heap;
        int[] returnThis = new int[rootGraphNodeInx.length];
        for (int i = 0; i < rootGraphNodeInx.length; ++i) {
            if (this._restoreNode(rootGraphNodeInx[i]) == 0) continue;
            returnThis[i] = rootGraphNodeInx[i];
            successes.toss(returnThis[i]);
        }
        if (successes.size() > 0 && (listener = this.m_lis[0]) != null) {
            int[] successArr = new int[successes.size()];
            successes.copyInto(successArr, 0);
            listener.graphPerspectiveChanged(new GraphPerspectiveNodesRestoredEvent(this, successArr));
        }
        return returnThis;
    }

    public Edge hideEdge(Edge edge) {
        if (edge.getRootGraph() == this.m_root && this.hideEdge(edge.getRootGraphIndex()) != 0) {
            return edge;
        }
        return null;
    }

    public int hideEdge(int rootGraphEdgeInx) {
        return this.m_weeder.hideEdge(this, rootGraphEdgeInx);
    }

    public List hideEdges(List edges) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            if (this.hideEdge((Edge)edges.get(i)) == null) continue;
            returnThis.add(edges.get(i));
        }
        return returnThis;
    }

    public int[] hideEdges(int[] rootGraphEdgeInx) {
        return this.m_weeder.hideEdges(this, rootGraphEdgeInx);
    }

    public Edge restoreEdge(Edge edge) {
        if (edge.getRootGraph() == this.m_root && this.restoreEdge(edge.getRootGraphIndex()) != 0) {
            return edge;
        }
        return null;
    }

    public int restoreEdge(int rootGraphEdgeInx) {
        GraphPerspectiveChangeListener listener;
        int returnThis = this._restoreEdge(rootGraphEdgeInx);
        if (returnThis != 0 && (listener = this.m_lis[0]) != null) {
            listener.graphPerspectiveChanged(new GraphPerspectiveEdgesRestoredEvent(this, new int[]{rootGraphEdgeInx}));
        }
        return returnThis;
    }

    private int _restoreEdge(int rootGraphEdgeInx) {
        GraphPerspectiveChangeListener listener;
        if (rootGraphEdgeInx >= 0) {
            return 0;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeInx);
        if (this.m_root.getEdge(rootGraphEdgeInx) == null || nativeEdgeInx >= 0 && nativeEdgeInx != Integer.MAX_VALUE) {
            return 0;
        }
        int rootGraphSourceNodeInx = this.m_root.getEdgeSourceIndex(rootGraphEdgeInx);
        int rootGraphTargetNodeInx = this.m_root.getEdgeTargetIndex(rootGraphEdgeInx);
        int nativeSourceNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphSourceNodeInx);
        int nativeTargetNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphTargetNodeInx);
        this.m_heap__restoreEdge.empty();
        MinIntHeap restoredNodeRootInx = this.m_heap__restoreEdge;
        if (nativeSourceNodeInx < 0 || nativeSourceNodeInx == Integer.MAX_VALUE) {
            nativeSourceNodeInx = ~this._restoreNode(rootGraphSourceNodeInx);
            restoredNodeRootInx.toss(rootGraphSourceNodeInx);
            if (rootGraphSourceNodeInx == rootGraphTargetNodeInx) {
                nativeTargetNodeInx = nativeSourceNodeInx;
            }
        }
        if (nativeTargetNodeInx < 0 || nativeTargetNodeInx == Integer.MAX_VALUE) {
            nativeTargetNodeInx = ~this._restoreNode(rootGraphTargetNodeInx);
            restoredNodeRootInx.toss(rootGraphTargetNodeInx);
        }
        if (restoredNodeRootInx.size() > 0 && (listener = this.m_lis[0]) != null) {
            int[] restoredNodesArr = new int[restoredNodeRootInx.size()];
            restoredNodeRootInx.copyInto(restoredNodesArr, 0);
            listener.graphPerspectiveChanged(new GraphPerspectiveNodesRestoredEvent(this, restoredNodesArr));
        }
        nativeEdgeInx = this.m_graph.edgeCreate(nativeSourceNodeInx, nativeTargetNodeInx, this.m_root.isEdgeDirected(rootGraphEdgeInx));
        this.m_rootToNativeEdgeInxMap.put(~rootGraphEdgeInx, nativeEdgeInx);
        this.m_nativeToRootEdgeInxMap.setIntAtIndex(rootGraphEdgeInx, nativeEdgeInx);
        return rootGraphEdgeInx;
    }

    public List restoreEdges(List edges) {
        ArrayList returnThis = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            if (this.restoreEdge((Edge)edges.get(i)) == null) continue;
            returnThis.add(edges.get(i));
        }
        return returnThis;
    }

    public int[] restoreEdges(int[] rootGraphEdgeInx) {
        GraphPerspectiveChangeListener listener;
        this.m_heap.empty();
        MinIntHeap successes = this.m_heap;
        int[] returnThis = new int[rootGraphEdgeInx.length];
        for (int i = 0; i < rootGraphEdgeInx.length; ++i) {
            returnThis[i] = this._restoreEdge(rootGraphEdgeInx[i]);
            if (returnThis[i] == 0) continue;
            successes.toss(returnThis[i]);
        }
        if (successes.size() > 0 && (listener = this.m_lis[0]) != null) {
            int[] successArr = new int[successes.size()];
            successes.copyInto(successArr, 0);
            listener.graphPerspectiveChanged(new GraphPerspectiveEdgesRestoredEvent(this, successArr));
        }
        return returnThis;
    }

    public boolean containsNode(Node node) {
        int nativeInx;
        return node.getRootGraph() == this.m_root && (nativeInx = this.m_rootToNativeNodeInxMap.get(~node.getRootGraphIndex())) >= 0 && nativeInx != Integer.MAX_VALUE;
    }

    public boolean containsNode(Node node, boolean recurse) {
        if (node.getRootGraph() != this.m_root) {
            return false;
        }
        int nativeInx = this.m_rootToNativeNodeInxMap.get(~node.getRootGraphIndex());
        if (nativeInx >= 0 && nativeInx != Integer.MAX_VALUE) {
            return true;
        }
        if (!recurse) {
            return false;
        }
        int[] recursiveChildNodes = this.m_root.getNodeMetaChildIndicesArray(this.getNodeIndicesArray());
        for (int i = 0; i < recursiveChildNodes.length; ++i) {
            if (recursiveChildNodes[i] != node.getRootGraphIndex()) continue;
            return true;
        }
        return false;
    }

    public boolean containsEdge(Edge edge) {
        int nativeInx;
        return edge.getRootGraph() == this.m_root && (nativeInx = this.m_rootToNativeEdgeInxMap.get(~edge.getRootGraphIndex())) >= 0 && nativeInx != Integer.MAX_VALUE;
    }

    public boolean containsEdge(Edge edge, boolean recurse) {
        if (edge.getRootGraph() != this.m_root) {
            return false;
        }
        int nativeInx = this.m_rootToNativeEdgeInxMap.get(~edge.getRootGraphIndex());
        if (nativeInx >= 0 && nativeInx != Integer.MAX_VALUE) {
            return true;
        }
        if (!recurse) {
            return false;
        }
        int[] recursiveChildEdges = this.m_root.getEdgeMetaChildIndicesArray(this.getNodeIndicesArray());
        for (int i = 0; i < recursiveChildEdges.length; ++i) {
            if (recursiveChildEdges[i] != edge.getRootGraphIndex()) continue;
            return true;
        }
        return false;
    }

    public GraphPerspective join(GraphPerspective persp) {
        final FGraphPerspective thisPersp = this;
        if (!(persp instanceof FGraphPerspective)) {
            return null;
        }
        final FGraphPerspective otherPersp = (FGraphPerspective)persp;
        if (otherPersp.m_root != thisPersp.m_root) {
            return null;
        }
        final IntEnumerator thisNativeNodes = thisPersp.m_graph.nodes();
        final IntEnumerator otherNativeNodes = otherPersp.m_graph.nodes();
        IntIterator rootGraphNodeInx = new IntIterator(){

            public boolean hasNext() {
                return thisNativeNodes.numRemaining() > 0 || otherNativeNodes.numRemaining() > 0;
            }

            public int nextInt() {
                if (thisNativeNodes.numRemaining() > 0) {
                    return thisPersp.m_nativeToRootNodeInxMap.getIntAtIndex(thisNativeNodes.nextInt());
                }
                return otherPersp.m_nativeToRootNodeInxMap.getIntAtIndex(otherNativeNodes.nextInt());
            }
        };
        final IntEnumerator thisNativeEdges = thisPersp.m_graph.edges();
        final IntEnumerator otherNativeEdges = otherPersp.m_graph.edges();
        IntIterator rootGraphEdgeInx = new IntIterator(){

            public boolean hasNext() {
                return thisNativeEdges.numRemaining() > 0 || otherNativeEdges.numRemaining() > 0;
            }

            public int nextInt() {
                if (thisNativeEdges.numRemaining() > 0) {
                    return thisPersp.m_nativeToRootEdgeInxMap.getIntAtIndex(thisNativeEdges.nextInt());
                }
                return otherPersp.m_nativeToRootEdgeInxMap.getIntAtIndex(otherNativeEdges.nextInt());
            }
        };
        return new FGraphPerspective(this.m_root, rootGraphNodeInx, rootGraphEdgeInx);
    }

    public GraphPerspective createGraphPerspective(Node[] nodes, Edge[] edges) {
        int i;
        for (i = 0; i < nodes.length; ++i) {
            if (this.containsNode(nodes[i])) continue;
            return null;
        }
        for (i = 0; i < edges.length; ++i) {
            if (this.containsEdge(edges[i])) continue;
            return null;
        }
        return this.m_root.createGraphPerspective(nodes, edges);
    }

    public GraphPerspective createGraphPerspective(int[] rootGraphNodeInx, int[] rootGraphEdgeInx) {
        int i;
        for (i = 0; i < rootGraphNodeInx.length; ++i) {
            int rootGraphNodeIndex = rootGraphNodeInx[i];
            if (rootGraphNodeIndex >= 0) {
                return null;
            }
            int nativeNodeIndex = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeIndex);
            if (nativeNodeIndex >= 0 && nativeNodeIndex != Integer.MAX_VALUE) continue;
            return null;
        }
        for (i = 0; i < rootGraphEdgeInx.length; ++i) {
            int rootGraphEdgeIndex = rootGraphEdgeInx[i];
            if (rootGraphEdgeIndex >= 0) {
                return null;
            }
            int nativeEdgeIndex = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeIndex);
            if (nativeEdgeIndex >= 0 && nativeEdgeIndex != Integer.MAX_VALUE) continue;
            return null;
        }
        return this.m_root.createGraphPerspective(rootGraphNodeInx, rootGraphEdgeInx);
    }

    public GraphPerspective createGraphPerspective(Filter filter) {
        this.m_heap.empty();
        MinIntHeap nodeInxBucket = this.m_heap;
        Iterator nodesIter = this.nodesIterator();
        while (nodesIter.hasNext()) {
            Node nodeCandidate = (Node)nodesIter.next();
            if (!filter.passesFilter(nodeCandidate)) continue;
            nodeInxBucket.toss(nodeCandidate.getRootGraphIndex());
        }
        int[] nodeInxArr = new int[nodeInxBucket.size()];
        nodeInxBucket.copyInto(nodeInxArr, 0);
        this.m_heap.empty();
        MinIntHeap edgeInxBucket = this.m_heap;
        Iterator edgesIter = this.edgesIterator();
        while (edgesIter.hasNext()) {
            Edge edgeCandidate = (Edge)edgesIter.next();
            if (!filter.passesFilter(edgeCandidate)) continue;
            edgeInxBucket.toss(edgeCandidate.getRootGraphIndex());
        }
        int[] edgeInxArr = new int[edgeInxBucket.size()];
        edgeInxBucket.copyInto(edgeInxArr, 0);
        return this.m_root.createGraphPerspective(nodeInxArr, edgeInxArr);
    }

    public List neighborsList(Node node) {
        if (node.getRootGraph() == this.m_root) {
            int[] neighInx = this.neighborsArray(node.getRootGraphIndex());
            if (neighInx == null) {
                return null;
            }
            ArrayList<Node> returnThis = new ArrayList<Node>(neighInx.length);
            for (int i = 0; i < neighInx.length; ++i) {
                returnThis.add(this.getNode(neighInx[i]));
            }
            return returnThis;
        }
        return null;
    }

    public int[] neighborsArray(int nodeIndex) {
        int[] adjacentEdgeIndices = this.getAdjacentEdgeIndicesArray(nodeIndex, true, true, true);
        if (adjacentEdgeIndices == null) {
            return null;
        }
        this.m_hash.empty();
        IntHash neighbors = this.m_hash;
        for (int i = 0; i < adjacentEdgeIndices.length; ++i) {
            int neighborIndex = nodeIndex ^ this.getEdgeSourceIndex(adjacentEdgeIndices[i]) ^ this.getEdgeTargetIndex(adjacentEdgeIndices[i]);
            neighbors.put(~neighborIndex);
        }
        IntEnumerator enumx = neighbors.elements();
        int[] returnThis = new int[enumx.numRemaining()];
        int index = -1;
        while (enumx.numRemaining() > 0) {
            returnThis[++index] = ~enumx.nextInt();
        }
        return returnThis;
    }

    public boolean isNeighbor(Node a, Node b) {
        if (a.getRootGraph() == this.m_root && b.getRootGraph() == this.m_root) {
            return this.isNeighbor(a.getRootGraphIndex(), b.getRootGraphIndex());
        }
        return false;
    }

    public boolean isNeighbor(int nodeInxA, int nodeInxB) {
        int nativeNodeB;
        if (nodeInxA >= 0 || nodeInxB >= 0) {
            return false;
        }
        int nativeNodeA = this.m_rootToNativeNodeInxMap.get(~nodeInxA);
        IntIterator nativeConnEdgeIter = this.m_graph.edgesConnecting(nativeNodeA, nativeNodeB = this.m_rootToNativeNodeInxMap.get(~nodeInxB), true, true, true);
        if (nativeConnEdgeIter == null) {
            return false;
        }
        return nativeConnEdgeIter.hasNext();
    }

    public boolean edgeExists(Node from, Node to) {
        if (from.getRootGraph() == this.m_root && to.getRootGraph() == this.m_root) {
            return this.edgeExists(from.getRootGraphIndex(), to.getRootGraphIndex());
        }
        return false;
    }

    public boolean edgeExists(int fromNodeInx, int toNodeInx) {
        int nativeToNode;
        if (fromNodeInx >= 0 || toNodeInx >= 0) {
            return false;
        }
        int nativeFromNode = this.m_rootToNativeNodeInxMap.get(~fromNodeInx);
        IntIterator nativeConnEdgeIter = this.m_graph.edgesConnecting(nativeFromNode, nativeToNode = this.m_rootToNativeNodeInxMap.get(~toNodeInx), true, false, true);
        if (nativeConnEdgeIter == null) {
            return false;
        }
        return nativeConnEdgeIter.hasNext();
    }

    public int getEdgeCount(Node from, Node to, boolean countUndirectedEdges) {
        if (from.getRootGraph() == this.m_root && to.getRootGraph() == this.m_root) {
            return this.getEdgeCount(from.getRootGraphIndex(), to.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getEdgeCount(int fromNodeInx, int toNodeInx, boolean countUndirectedEdges) {
        int[] edgeIndicesArray = this.getEdgeIndicesArray(fromNodeInx, toNodeInx, countUndirectedEdges);
        if (edgeIndicesArray == null) {
            return -1;
        }
        return edgeIndicesArray.length;
    }

    public List edgesList(Node from, Node to) {
        if (from.getRootGraph() == this.m_root && to.getRootGraph() == this.m_root) {
            return this.edgesList(from.getRootGraphIndex(), to.getRootGraphIndex(), true);
        }
        return null;
    }

    public List edgesList(int fromNodeInx, int toNodeInx, boolean includeUndirectedEdges) {
        int[] edgeInx = this.getEdgeIndicesArray(fromNodeInx, toNodeInx, includeUndirectedEdges);
        if (edgeInx == null) {
            return null;
        }
        ArrayList<Edge> returnList = new ArrayList<Edge>(edgeInx.length);
        for (int i = 0; i < edgeInx.length; ++i) {
            returnList.add(this.getEdge(edgeInx[i]));
        }
        return returnList;
    }

    public int[] getEdgeIndicesArray(int fromNodeInx, int toNodeInx, boolean includeUndirectedEdges) {
        return this.getEdgeIndicesArray(fromNodeInx, toNodeInx, includeUndirectedEdges, false);
    }

    public int getInDegree(Node node) {
        if (node.getRootGraph() == this.m_root) {
            return this.getInDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getInDegree(int nodeInx) {
        return this.getInDegree(nodeInx, true);
    }

    public int getInDegree(Node node, boolean countUndirectedEdges) {
        if (node.getRootGraph() == this.m_root) {
            return this.getInDegree(node.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getInDegree(int nodeInx, boolean countUndirectedEdges) {
        if (nodeInx >= 0) {
            return -1;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~nodeInx);
        IntEnumerator adj = this.m_graph.edgesAdjacent(nativeNodeInx, false, true, countUndirectedEdges);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getOutDegree(Node node) {
        if (node.getRootGraph() == this.m_root) {
            return this.getOutDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getOutDegree(int nodeInx) {
        return this.getOutDegree(nodeInx, true);
    }

    public int getOutDegree(Node node, boolean countUndirectedEdges) {
        if (node.getRootGraph() == this.m_root) {
            return this.getOutDegree(node.getRootGraphIndex(), countUndirectedEdges);
        }
        return -1;
    }

    public int getOutDegree(int nodeInx, boolean countUndirectedEdges) {
        if (nodeInx >= 0) {
            return -1;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~nodeInx);
        IntEnumerator adj = this.m_graph.edgesAdjacent(nativeNodeInx, true, false, countUndirectedEdges);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getDegree(Node node) {
        if (node.getRootGraph() == this.m_root) {
            return this.getDegree(node.getRootGraphIndex());
        }
        return -1;
    }

    public int getDegree(int nodeInx) {
        if (nodeInx >= 0) {
            return -1;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~nodeInx);
        IntEnumerator adj = this.m_graph.edgesAdjacent(nativeNodeInx, true, true, true);
        if (adj == null) {
            return -1;
        }
        return adj.numRemaining();
    }

    public int getIndex(Node node) {
        if (node.getRootGraph() == this.m_root && this.getRootGraphNodeIndex(node.getRootGraphIndex()) == node.getRootGraphIndex()) {
            return node.getRootGraphIndex();
        }
        return 0;
    }

    public int getNodeIndex(int rootGraphNodeInx) {
        return this.getRootGraphNodeIndex(rootGraphNodeInx);
    }

    public int getRootGraphNodeIndex(int rootGraphNodeInx) {
        if (rootGraphNodeInx >= 0) {
            return 0;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeInx);
        if (nativeNodeInx < 0 || nativeNodeInx == Integer.MAX_VALUE) {
            return 0;
        }
        return rootGraphNodeInx;
    }

    public Node getNode(int rootGraphNodeInx) {
        return this.m_root.getNode(this.getRootGraphNodeIndex(rootGraphNodeInx));
    }

    boolean containsNode(int rootGraphNodeInx) {
        if (rootGraphNodeInx >= 0) {
            return false;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeInx);
        return nativeNodeInx >= 0 && nativeNodeInx != Integer.MAX_VALUE;
    }

    public int getIndex(Edge edge) {
        if (edge.getRootGraph() == this.m_root && this.getRootGraphEdgeIndex(edge.getRootGraphIndex()) == edge.getRootGraphIndex()) {
            return edge.getRootGraphIndex();
        }
        return 0;
    }

    public int getEdgeIndex(int rootGraphEdgeInx) {
        return this.getRootGraphEdgeIndex(rootGraphEdgeInx);
    }

    public int getRootGraphEdgeIndex(int rootGraphEdgeInx) {
        if (rootGraphEdgeInx >= 0) {
            return 0;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeInx);
        if (nativeEdgeInx < 0 || nativeEdgeInx == Integer.MAX_VALUE) {
            return 0;
        }
        return rootGraphEdgeInx;
    }

    public Edge getEdge(int rootGraphEdgeInx) {
        return this.m_root.getEdge(this.getRootGraphEdgeIndex(rootGraphEdgeInx));
    }

    boolean containsEdge(int rootGraphEdgeInx) {
        if (rootGraphEdgeInx >= 0) {
            return false;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeInx);
        return nativeEdgeInx >= 0 && nativeEdgeInx != Integer.MAX_VALUE;
    }

    public int getEdgeSourceIndex(int edgeInx) {
        if (edgeInx >= 0) {
            return 0;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(~edgeInx);
        int nativeSrcNodeInx = this.m_graph.edgeSource(nativeEdgeInx);
        if (nativeSrcNodeInx < 0) {
            return 0;
        }
        return this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeSrcNodeInx);
    }

    public int getEdgeTargetIndex(int edgeInx) {
        if (edgeInx >= 0) {
            return 0;
        }
        int nativeEdgeInx = this.m_rootToNativeEdgeInxMap.get(~edgeInx);
        int nativeTrgNodeInx = this.m_graph.edgeTarget(nativeEdgeInx);
        if (nativeTrgNodeInx < 0) {
            return 0;
        }
        return this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeTrgNodeInx);
    }

    public boolean isEdgeDirected(int edgeInx) {
        if (edgeInx >= 0) {
            throw new IllegalArgumentException("edge index is not negative");
        }
        return this.m_graph.edgeType(this.m_rootToNativeEdgeInxMap.get(~edgeInx)) == 1;
    }

    public boolean isMetaParent(Node child, Node parent) {
        if (child.getRootGraph() != this.m_root || parent.getRootGraph() != this.m_root) {
            return false;
        }
        return this.isNodeMetaParent(child.getRootGraphIndex(), parent.getRootGraphIndex());
    }

    public boolean isNodeMetaParent(int childNodeInx, int parentNodeInx) {
        return this.isNodeMetaChild(parentNodeInx, childNodeInx);
    }

    public List metaParentsList(Node node) {
        if (node.getRootGraph() != this.m_root) {
            return null;
        }
        return this.nodeMetaParentsList(node.getRootGraphIndex());
    }

    public List nodeMetaParentsList(int nodeInx) {
        int[] parentInxArr = this.getNodeMetaParentIndicesArray(nodeInx);
        if (parentInxArr == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(parentInxArr.length);
        for (int i = 0; i < parentInxArr.length; ++i) {
            returnThis.add(this.m_root.getNode(parentInxArr[i]));
        }
        return returnThis;
    }

    public int[] getNodeMetaParentIndicesArray(int nodeInx) {
        if (!this.containsNode(nodeInx)) {
            return null;
        }
        int[] allParentInx = this.m_root.getNodeMetaParentIndicesArray(nodeInx);
        this.m_heap.empty();
        MinIntHeap parentsBucket = this.m_heap;
        for (int i = 0; i < allParentInx.length; ++i) {
            if (!this.containsNode(allParentInx[i])) continue;
            parentsBucket.toss(allParentInx[i]);
        }
        int[] returnThis = new int[parentsBucket.size()];
        parentsBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public boolean isMetaChild(Node parent, Node child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isNodeMetaChild(int parentNodeInx, int childNodeInx) {
        return this.containsNode(parentNodeInx) && this.containsNode(childNodeInx) && this.m_root.isNodeMetaChild(parentNodeInx, childNodeInx);
    }

    public List nodeMetaChildrenList(Node node) {
        if (node.getRootGraph() != this.m_root) {
            return null;
        }
        return this.nodeMetaChildrenList(node.getRootGraphIndex());
    }

    public List nodeMetaChildrenList(int parentInx) {
        int[] childrenInxArr = this.getNodeMetaChildIndicesArray(parentInx);
        if (childrenInxArr == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(childrenInxArr.length);
        for (int i = 0; i < childrenInxArr.length; ++i) {
            returnThis.add(this.m_root.getNode(childrenInxArr[i]));
        }
        return returnThis;
    }

    public int[] getNodeMetaChildIndicesArray(int parentInx) {
        if (!this.containsNode(parentInx)) {
            return null;
        }
        int[] allChildrenInx = this.m_root.getNodeMetaChildIndicesArray(parentInx);
        this.m_heap.empty();
        MinIntHeap childrenBucket = this.m_heap;
        for (int i = 0; i < allChildrenInx.length; ++i) {
            if (!this.containsNode(allChildrenInx[i])) continue;
            childrenBucket.toss(allChildrenInx[i]);
        }
        int[] returnThis = new int[childrenBucket.size()];
        childrenBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public boolean isMetaParent(Edge child, Node parent) {
        if (child.getRootGraph() != this.m_root || parent.getRootGraph() != this.m_root) {
            return false;
        }
        return this.isEdgeMetaParent(child.getRootGraphIndex(), parent.getRootGraphIndex());
    }

    public boolean isEdgeMetaParent(int childEdgeInx, int parentNodeInx) {
        return this.isEdgeMetaChild(parentNodeInx, childEdgeInx);
    }

    public List metaParentsList(Edge edge) {
        if (edge.getRootGraph() != this.m_root) {
            return null;
        }
        return this.edgeMetaParentsList(edge.getRootGraphIndex());
    }

    public List edgeMetaParentsList(int edgeInx) {
        int[] parentInxArr = this.getEdgeMetaParentIndicesArray(edgeInx);
        if (parentInxArr == null) {
            return null;
        }
        ArrayList<Node> returnThis = new ArrayList<Node>(parentInxArr.length);
        for (int i = 0; i < parentInxArr.length; ++i) {
            returnThis.add(this.m_root.getNode(parentInxArr[i]));
        }
        return returnThis;
    }

    public int[] getEdgeMetaParentIndicesArray(int edgeInx) {
        if (!this.containsEdge(edgeInx)) {
            return null;
        }
        int[] allParentInx = this.m_root.getEdgeMetaParentIndicesArray(edgeInx);
        this.m_heap.empty();
        MinIntHeap parentsBucket = this.m_heap;
        for (int i = 0; i < allParentInx.length; ++i) {
            if (!this.containsNode(allParentInx[i])) continue;
            parentsBucket.toss(allParentInx[i]);
        }
        int[] returnThis = new int[parentsBucket.size()];
        parentsBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public boolean isMetaChild(Node parent, Edge child) {
        return this.isMetaParent(child, parent);
    }

    public boolean isEdgeMetaChild(int parentNodeInx, int childEdgeInx) {
        return this.containsNode(parentNodeInx) && this.containsEdge(childEdgeInx) && this.m_root.isEdgeMetaChild(parentNodeInx, childEdgeInx);
    }

    public List edgeMetaChildrenList(Node node) {
        if (node.getRootGraph() != this.m_root) {
            return null;
        }
        return this.edgeMetaChildrenList(node.getRootGraphIndex());
    }

    public List edgeMetaChildrenList(int parentNodeInx) {
        int[] childrenInxArr = this.getEdgeMetaChildIndicesArray(parentNodeInx);
        if (childrenInxArr == null) {
            return null;
        }
        ArrayList<Edge> returnThis = new ArrayList<Edge>(childrenInxArr.length);
        for (int i = 0; i < childrenInxArr.length; ++i) {
            returnThis.add(this.m_root.getEdge(childrenInxArr[i]));
        }
        return returnThis;
    }

    public int[] getEdgeMetaChildIndicesArray(int parentNodeInx) {
        if (!this.containsNode(parentNodeInx)) {
            return null;
        }
        int[] allChildrenInx = this.m_root.getEdgeMetaChildIndicesArray(parentNodeInx);
        this.m_heap.empty();
        MinIntHeap childrenBucket = this.m_heap;
        for (int i = 0; i < allChildrenInx.length; ++i) {
            if (!this.containsEdge(allChildrenInx[i])) continue;
            childrenBucket.toss(allChildrenInx[i]);
        }
        int[] returnThis = new int[childrenBucket.size()];
        childrenBucket.copyInto(returnThis, 0);
        return returnThis;
    }

    public List getAdjacentEdgesList(Node node, boolean undirected, boolean incoming, boolean outgoing) {
        if (node.getRootGraph() != this.m_root) {
            return null;
        }
        int[] adjEdgeInx = this.getAdjacentEdgeIndicesArray(node.getRootGraphIndex(), undirected, incoming, outgoing);
        if (adjEdgeInx == null) {
            return null;
        }
        ArrayList<Edge> returnThis = new ArrayList<Edge>(adjEdgeInx.length);
        for (int i = 0; i < adjEdgeInx.length; ++i) {
            returnThis.add(this.getEdge(adjEdgeInx[i]));
        }
        return returnThis;
    }

    public int[] getAdjacentEdgeIndicesArray(int nodeInx, boolean undirected, boolean incomingDirected, boolean outgoingDirected) {
        if (nodeInx >= 0) {
            return null;
        }
        int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~nodeInx);
        IntEnumerator adj = this.m_graph.edgesAdjacent(nativeNodeInx, outgoingDirected, incomingDirected, undirected);
        if (adj == null) {
            return null;
        }
        int[] returnThis = new int[adj.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.m_nativeToRootEdgeInxMap.getIntAtIndex(adj.nextInt());
        }
        return returnThis;
    }

    public List getConnectingEdges(List nodes) {
        this.m_heap.empty();
        MinIntHeap nodeInxBucket = this.m_heap;
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (node.getRootGraph() != this.m_root) {
                return null;
            }
            nodeInxBucket.toss(node.getRootGraphIndex());
        }
        int[] nodeInxArr = new int[nodeInxBucket.size()];
        nodeInxBucket.copyInto(nodeInxArr, 0);
        int[] connEdgeInxArr = this.getConnectingEdgeIndicesArray(nodeInxArr);
        if (connEdgeInxArr == null) {
            return null;
        }
        ArrayList<Edge> returnThis = new ArrayList<Edge>(connEdgeInxArr.length);
        for (int i = 0; i < connEdgeInxArr.length; ++i) {
            returnThis.add(this.getEdge(connEdgeInxArr[i]));
        }
        return returnThis;
    }

    public int[] getConnectingEdgeIndicesArray(int[] nodeInx) {
        IntHash nativeNodeBucket = new IntHash();
        for (int i = 0; i < nodeInx.length; ++i) {
            if (nodeInx[i] >= 0) {
                return null;
            }
            int nativeNodeInx = this.m_rootToNativeNodeInxMap.get(~nodeInx[i]);
            if (!this.m_graph.nodeExists(nativeNodeInx)) {
                return null;
            }
            nativeNodeBucket.put(nativeNodeInx);
        }
        this.m_hash.empty();
        IntHash nativeEdgeBucket = this.m_hash;
        IntEnumerator nativeNodeEnum = nativeNodeBucket.elements();
        while (nativeNodeEnum.numRemaining() > 0) {
            int nativeNodeIndex = nativeNodeEnum.nextInt();
            IntEnumerator nativeAdjEdgeEnum = this.m_graph.edgesAdjacent(nativeNodeIndex, true, false, true);
            while (nativeAdjEdgeEnum.numRemaining() > 0) {
                int nativeCandidateEdge = nativeAdjEdgeEnum.nextInt();
                int nativeOtherEdgeNode = nativeNodeIndex ^ this.m_graph.edgeSource(nativeCandidateEdge) ^ this.m_graph.edgeTarget(nativeCandidateEdge);
                if (nativeOtherEdgeNode != nativeNodeBucket.get(nativeOtherEdgeNode)) continue;
                nativeEdgeBucket.put(nativeCandidateEdge);
            }
        }
        IntEnumerator nativeReturnEdges = nativeEdgeBucket.elements();
        int[] returnThis = new int[nativeReturnEdges.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeReturnEdges.nextInt());
        }
        return returnThis;
    }

    public int[] getConnectingNodeIndicesArray(int[] edgeInx) {
        this.m_hash.empty();
        IntHash nativeNodeBucket = this.m_hash;
        for (int i = 0; i < edgeInx.length; ++i) {
            if (edgeInx[i] >= 0) {
                return null;
            }
            int nativeEdgeIndex = this.m_rootToNativeEdgeInxMap.get(~edgeInx[i]);
            if (this.m_graph.edgeType(nativeEdgeIndex) < 0) {
                return null;
            }
            nativeNodeBucket.put(this.m_graph.edgeSource(nativeEdgeIndex));
            nativeNodeBucket.put(this.m_graph.edgeTarget(nativeEdgeIndex));
        }
        IntEnumerator nativeNodeEnum = nativeNodeBucket.elements();
        int[] returnThis = new int[nativeNodeEnum.numRemaining()];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = this.m_nativeToRootNodeInxMap.getIntAtIndex(nativeNodeEnum.nextInt());
        }
        return returnThis;
    }

    public GraphPerspective createGraphPerspective(int[] nodeInx) {
        return this.createGraphPerspective(nodeInx, this.getConnectingEdgeIndicesArray(nodeInx));
    }

    public void finalize() {
        this.m_root.removeRootGraphChangeListener(this.m_changeSniffer);
    }

    FGraphPerspective(FRootGraph root, IntIterator rootGraphNodeInx, IntIterator rootGraphEdgeInx) throws IllegalArgumentException {
        this.m_root = root;
        this.m_lis = new GraphPerspectiveChangeListener[1];
        this.m_nativeToRootNodeInxMap = new IntArray();
        this.m_nativeToRootEdgeInxMap = new IntArray();
        this.m_rootToNativeNodeInxMap = new IntIntHash();
        this.m_rootToNativeEdgeInxMap = new IntIntHash();
        this.m_heap = new MinIntHeap();
        this.m_hash = new IntHash();
        this.m_weeder = new GraphWeeder(this.m_root, this.m_graph, this.m_nativeToRootNodeInxMap, this.m_nativeToRootEdgeInxMap, this.m_rootToNativeNodeInxMap, this.m_rootToNativeEdgeInxMap, this.m_lis, this.m_heap);
        this.m_changeSniffer = new RootGraphChangeSniffer(this.m_weeder);
        while (rootGraphNodeInx.hasNext()) {
            int rootNodeInx = rootGraphNodeInx.nextInt();
            if (this.m_root.getNode(rootNodeInx) != null) {
                if (this.m_rootToNativeNodeInxMap.get(~rootNodeInx) >= 0) continue;
                int nativeNodeInx = this.m_graph.nodeCreate();
                this.m_rootToNativeNodeInxMap.put(~rootNodeInx, nativeNodeInx);
                this.m_nativeToRootNodeInxMap.setIntAtIndex(rootNodeInx, nativeNodeInx);
                continue;
            }
            throw new IllegalArgumentException("node with index " + rootNodeInx + " not in RootGraph");
        }
        while (rootGraphEdgeInx.hasNext()) {
            int rootEdgeInx = rootGraphEdgeInx.nextInt();
            if (this.m_root.getEdge(rootEdgeInx) != null) {
                int nativeTrgInx;
                if (this.m_rootToNativeEdgeInxMap.get(~rootEdgeInx) >= 0) continue;
                int rootSrcInx = this.m_root.getEdgeSourceIndex(rootEdgeInx);
                int rootTrgInx = this.m_root.getEdgeTargetIndex(rootEdgeInx);
                boolean edgeDirected = this.m_root.isEdgeDirected(rootEdgeInx);
                int nativeSrcInx = this.m_rootToNativeNodeInxMap.get(~rootSrcInx);
                if (nativeSrcInx < 0) {
                    nativeSrcInx = this.m_graph.nodeCreate();
                    this.m_rootToNativeNodeInxMap.put(~rootSrcInx, nativeSrcInx);
                    this.m_nativeToRootNodeInxMap.setIntAtIndex(rootSrcInx, nativeSrcInx);
                }
                if ((nativeTrgInx = this.m_rootToNativeNodeInxMap.get(~rootTrgInx)) < 0) {
                    nativeTrgInx = this.m_graph.nodeCreate();
                    this.m_rootToNativeNodeInxMap.put(~rootTrgInx, nativeTrgInx);
                    this.m_nativeToRootNodeInxMap.setIntAtIndex(rootTrgInx, nativeTrgInx);
                }
                int nativeEdgeInx = this.m_graph.edgeCreate(nativeSrcInx, nativeTrgInx, edgeDirected);
                this.m_rootToNativeEdgeInxMap.put(~rootEdgeInx, nativeEdgeInx);
                this.m_nativeToRootEdgeInxMap.setIntAtIndex(rootEdgeInx, nativeEdgeInx);
                continue;
            }
            throw new IllegalArgumentException("edge with index " + rootEdgeInx + " not in RootGraph");
        }
        this.m_root.addRootGraphChangeListener(this.m_changeSniffer);
    }

    private static final class GraphWeeder {
        private final RootGraph m_root;
        private final DynamicGraph m_graph;
        private final IntArray m_nativeToRootNodeInxMap;
        private final IntArray m_nativeToRootEdgeInxMap;
        private final IntIntHash m_rootToNativeNodeInxMap;
        private final IntIntHash m_rootToNativeEdgeInxMap;
        private final GraphPerspectiveChangeListener[] m_lis;
        private final MinIntHeap m_heap;
        private final MinIntHeap m_heap_hideNodes = new MinIntHeap();

        private GraphWeeder(RootGraph root, DynamicGraph graph, IntArray nativeToRootNodeInxMap, IntArray nativeToRootEdgeInxMap, IntIntHash rootToNativeNodeInxMap, IntIntHash rootToNativeEdgeInxMap, GraphPerspectiveChangeListener[] listener, MinIntHeap heap) {
            this.m_root = root;
            this.m_graph = graph;
            this.m_nativeToRootNodeInxMap = nativeToRootNodeInxMap;
            this.m_nativeToRootEdgeInxMap = nativeToRootEdgeInxMap;
            this.m_rootToNativeNodeInxMap = rootToNativeNodeInxMap;
            this.m_rootToNativeEdgeInxMap = rootToNativeEdgeInxMap;
            this.m_lis = listener;
            this.m_heap = heap;
        }

        private final int hideNode(GraphPerspective source, int rootGraphNodeInx) {
            int returnThis = this.canHideNode(rootGraphNodeInx);
            if (returnThis != 0) {
                GraphPerspectiveChangeListener listener = this.m_lis[0];
                if (listener != null) {
                    Node removedNode = this.m_root.getNode(rootGraphNodeInx);
                    listener.graphPerspectiveChanged(new GraphPerspectiveNodesHiddenEvent(source, new Node[]{removedNode}));
                }
                this.actuallyHideNode(source, rootGraphNodeInx);
            }
            return returnThis;
        }

        private int canHideNode(int rootGraphNodeInx) {
            if (rootGraphNodeInx >= 0) {
                return 0;
            }
            int nativeNodeIndex = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeInx);
            if (nativeNodeIndex < 0) {
                return 0;
            }
            IntEnumerator nativeEdgeInxEnum = this.m_graph.edgesAdjacent(nativeNodeIndex, true, true, true);
            if (nativeEdgeInxEnum == null) {
                return 0;
            }
            return rootGraphNodeInx;
        }

        private void actuallyHideNode(Object source, int rootGraphNodeInx) {
            int nativeNodeIndex = this.m_rootToNativeNodeInxMap.get(~rootGraphNodeInx);
            IntEnumerator nativeEdgeInxEnum = this.m_graph.edgesAdjacent(nativeNodeIndex, true, true, true);
            if (nativeEdgeInxEnum.numRemaining() > 0) {
                Edge[] edgeRemoveArr = new Edge[nativeEdgeInxEnum.numRemaining()];
                for (int i = 0; i < edgeRemoveArr.length; ++i) {
                    int rootGraphEdgeInx = this.m_nativeToRootEdgeInxMap.getIntAtIndex(nativeEdgeInxEnum.nextInt());
                    edgeRemoveArr[i] = this.m_root.getEdge(rootGraphEdgeInx);
                }
                this.hideEdges(source, edgeRemoveArr);
            }
            if (!this.m_graph.nodeRemove(nativeNodeIndex)) {
                throw new IllegalStateException("internal error - node didn't exist, its adjacent edges did");
            }
            this.m_rootToNativeNodeInxMap.put(~rootGraphNodeInx, Integer.MAX_VALUE);
            this.m_nativeToRootNodeInxMap.setIntAtIndex(0, nativeNodeIndex);
        }

        private final int[] hideNodes(GraphPerspective source, int[] rootNodeInx) {
            GraphPerspectiveChangeListener listener;
            this.m_heap_hideNodes.empty();
            MinIntHeap successes = this.m_heap_hideNodes;
            int[] returnThis = new int[rootNodeInx.length];
            for (int i = 0; i < rootNodeInx.length; ++i) {
                returnThis[i] = this.canHideNode(rootNodeInx[i]);
                if (returnThis[i] == 0) continue;
                successes.toss(i);
            }
            if (successes.size() > 0 && (listener = this.m_lis[0]) != null) {
                Node[] successArr = new Node[successes.size()];
                IntEnumerator enumx = successes.elements();
                int index = -1;
                while (enumx.numRemaining() > 0) {
                    successArr[++index] = this.m_root.getNode(rootNodeInx[enumx.nextInt()]);
                }
                listener.graphPerspectiveChanged(new GraphPerspectiveNodesHiddenEvent(source, successArr));
            }
            IntEnumerator successEnum = successes.elements();
            while (successEnum.numRemaining() > 0) {
                this.actuallyHideNode(source, rootNodeInx[successEnum.nextInt()]);
            }
            return returnThis;
        }

        private final void hideNodes(Object source, Node[] nodes) {
            this.m_heap_hideNodes.empty();
            MinIntHeap successes = this.m_heap_hideNodes;
            for (int i = 0; i < nodes.length; ++i) {
                if (this.canHideNode(nodes[i].getRootGraphIndex()) == 0) continue;
                successes.toss(i);
            }
            if (successes.size() > 0) {
                GraphPerspectiveChangeListener listener = this.m_lis[0];
                if (listener != null) {
                    Node[] successArr = new Node[successes.size()];
                    IntEnumerator enumx = successes.elements();
                    int index = -1;
                    while (enumx.numRemaining() > 0) {
                        successArr[++index] = nodes[enumx.nextInt()];
                    }
                    listener.graphPerspectiveChanged(new GraphPerspectiveNodesHiddenEvent(source, successArr));
                }
                IntEnumerator successEnum = successes.elements();
                while (successEnum.numRemaining() > 0) {
                    this.actuallyHideNode(source, nodes[successEnum.nextInt()].getRootGraphIndex());
                }
            }
        }

        private final int hideEdge(GraphPerspective source, int rootGraphEdgeInx) {
            int returnThis = this.canHideEdge(rootGraphEdgeInx);
            if (returnThis != 0) {
                GraphPerspectiveChangeListener listener = this.m_lis[0];
                if (listener != null) {
                    Edge removedEdge = this.m_root.getEdge(rootGraphEdgeInx);
                    listener.graphPerspectiveChanged(new GraphPerspectiveEdgesHiddenEvent(source, new Edge[]{removedEdge}));
                }
                this.actuallyHideEdge(rootGraphEdgeInx);
            }
            return returnThis;
        }

        private int canHideEdge(int rootGraphEdgeInx) {
            if (rootGraphEdgeInx >= 0) {
                return 0;
            }
            int nativeEdgeIndex = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeInx);
            if (nativeEdgeIndex < 0 || nativeEdgeIndex == Integer.MAX_VALUE) {
                return 0;
            }
            return rootGraphEdgeInx;
        }

        private void actuallyHideEdge(int rootGraphEdgeInx) {
            int nativeEdgeIndex = this.m_rootToNativeEdgeInxMap.get(~rootGraphEdgeInx);
            if (!this.m_graph.edgeRemove(nativeEdgeIndex)) {
                throw new IllegalStateException("internal error - couldn't hide edge: " + rootGraphEdgeInx);
            }
            this.m_rootToNativeEdgeInxMap.put(~rootGraphEdgeInx, Integer.MAX_VALUE);
            this.m_nativeToRootEdgeInxMap.setIntAtIndex(0, nativeEdgeIndex);
        }

        private final int[] hideEdges(GraphPerspective source, int[] rootEdgeInx) {
            this.m_heap.empty();
            MinIntHeap successes = this.m_heap;
            int[] returnThis = new int[rootEdgeInx.length];
            for (int i = 0; i < rootEdgeInx.length; ++i) {
                returnThis[i] = this.canHideEdge(rootEdgeInx[i]);
                if (returnThis[i] == 0) continue;
                successes.toss(i);
            }
            if (successes.size() > 0) {
                GraphPerspectiveChangeListener listener = this.m_lis[0];
                if (listener != null) {
                    Edge[] successArr = new Edge[successes.size()];
                    IntEnumerator enumx = successes.elements();
                    int index = -1;
                    while (enumx.numRemaining() > 0) {
                        successArr[++index] = this.m_root.getEdge(rootEdgeInx[enumx.nextInt()]);
                    }
                    listener.graphPerspectiveChanged(new GraphPerspectiveEdgesHiddenEvent(source, successArr));
                }
                IntEnumerator successEnum = successes.elements();
                while (successEnum.numRemaining() > 0) {
                    this.actuallyHideEdge(rootEdgeInx[successEnum.nextInt()]);
                }
            }
            return returnThis;
        }

        private final void hideEdges(Object source, Edge[] edges) {
            this.m_heap.empty();
            MinIntHeap successes = this.m_heap;
            for (int i = 0; i < edges.length; ++i) {
                if (edges[i] == null || this.canHideEdge(edges[i].getRootGraphIndex()) == 0) continue;
                successes.toss(i);
            }
            if (successes.size() > 0) {
                GraphPerspectiveChangeListener listener = this.m_lis[0];
                if (listener != null) {
                    Edge[] successArr = new Edge[successes.size()];
                    IntEnumerator enumx = successes.elements();
                    int index = -1;
                    while (enumx.numRemaining() > 0) {
                        successArr[++index] = edges[enumx.nextInt()];
                    }
                    listener.graphPerspectiveChanged(new GraphPerspectiveEdgesHiddenEvent(source, successArr));
                }
                IntEnumerator successEnum = successes.elements();
                while (successEnum.numRemaining() > 0) {
                    this.actuallyHideEdge(edges[successEnum.nextInt()].getRootGraphIndex());
                }
            }
        }
    }

    private static final class RootGraphChangeSniffer
    implements RootGraphChangeListener {
        private final GraphWeeder m_weeder;

        private RootGraphChangeSniffer(GraphWeeder weeder) {
            this.m_weeder = weeder;
        }

        public final void rootGraphChanged(RootGraphChangeEvent evt) {
            if ((evt.getType() & 4) != 0) {
                this.m_weeder.hideNodes(evt.getSource(), evt.getRemovedNodes());
            }
            if ((evt.getType() & 8) != 0) {
                this.m_weeder.hideEdges(evt.getSource(), evt.getRemovedEdges());
            }
        }
    }
}

