/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.view.EdgeView;
import giny.view.NodeView;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CytoscapeViewTest
extends TestCase {
    CyNetwork network;
    CyNode node1;
    CyNode node2;
    CyEdge edge1;
    CyEdge edge2;
    CyNetworkView view;
    NodeView nodeView1;
    NodeView nodeView2;
    EdgeView edgeView1;
    EdgeView edgeView2;

    public CytoscapeViewTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.node1 = Cytoscape.getCyNode("node1", true);
        this.node2 = Cytoscape.getCyNode("node2", true);
        this.edge1 = Cytoscape.getCyEdge("node1", "node1 (pp) node2", "node2", "pp");
        this.edge2 = Cytoscape.getCyEdge("node2", "node2 (pp) node1", "node1", "pp");
        int[] nodeArray = new int[]{this.node1.getRootGraphIndex(), this.node2.getRootGraphIndex()};
        int[] edgeArray = new int[]{this.edge1.getRootGraphIndex(), this.edge2.getRootGraphIndex()};
        this.network = Cytoscape.createNetwork(nodeArray, edgeArray, null);
        this.view = Cytoscape.createNetworkView(this.network);
        this.nodeView1 = this.view.getNodeView(this.node1);
        this.nodeView2 = this.view.getNodeView(this.node2);
        this.edgeView1 = this.view.getEdgeView(this.edge1);
        this.edgeView2 = this.view.getEdgeView(this.edge2);
    }

    public void testBug925() {
        this.network.unselectAllEdges();
        this.network.unselectAllNodes();
        CytoscapeViewTest.assertEquals("num nodes selected", 0, this.network.getSelectedNodes().size());
        CytoscapeViewTest.assertEquals("num edges selected", 0, this.network.getSelectedEdges().size());
        this.network.setSelectedNodeState(this.node1, true);
        CytoscapeViewTest.assertEquals("num nodes selected", 1, this.network.getSelectedNodes().size());
        CytoscapeViewTest.assertTrue("node1 is selected", this.network.isSelected(this.node1));
        Cytoscape.destroyNetworkView(this.view);
        CytoscapeViewTest.assertEquals("num nodes selected", 1, this.network.getSelectedNodes().size());
        CytoscapeViewTest.assertTrue("node1 is selected", this.network.isSelected(this.node1));
        this.view = Cytoscape.createNetworkView(this.network);
        CytoscapeViewTest.assertEquals("num nodes selected", 1, this.network.getSelectedNodes().size());
        CytoscapeViewTest.assertTrue("node1 is selected", this.network.isSelected(this.node1));
    }

    public void testFilterToViewSelect() throws Exception {
        this.checkState(false, false, false, false);
        this.network.setSelectedNodeState(this.node1, true);
        this.checkState(true, false, false, false);
        this.network.setSelectedEdgeState(this.edge2, true);
        this.checkState(true, false, false, true);
        this.network.selectAllNodes();
        this.checkState(true, true, false, true);
        this.network.selectAllEdges();
        this.checkState(true, true, true, true);
        this.network.setSelectedNodeState(this.node2, false);
        this.checkState(true, false, true, true);
        this.network.setSelectedEdgeState(this.edge1, false);
        this.checkState(true, false, false, true);
        this.network.unselectAllEdges();
        this.checkState(true, false, false, false);
        this.network.unselectAllNodes();
        this.checkState(false, false, false, false);
    }

    public void testViewToFilterSelect() throws Exception {
        this.checkState(false, false, false, false);
        this.nodeView1.setSelected(true);
        this.checkState(true, false, false, false);
        this.edgeView2.setSelected(true);
        this.checkState(true, false, false, true);
        this.nodeView2.setSelected(true);
        this.checkState(true, true, false, true);
        this.edgeView1.setSelected(true);
        this.checkState(true, true, true, true);
        this.nodeView2.setSelected(false);
        this.checkState(true, false, true, true);
        this.edgeView1.setSelected(false);
        this.checkState(true, false, false, true);
        this.edgeView2.setSelected(false);
        this.checkState(true, false, false, false);
        this.nodeView1.setSelected(false);
        this.checkState(false, false, false, false);
    }

    private void checkState(boolean n1, boolean n2, boolean e1, boolean e2) {
        CytoscapeViewTest.assertTrue(this.network.isSelected(this.node1) == n1);
        CytoscapeViewTest.assertTrue(this.network.isSelected(this.node2) == n2);
        CytoscapeViewTest.assertTrue(this.network.isSelected(this.edge1) == e1);
        CytoscapeViewTest.assertTrue(this.network.isSelected(this.edge2) == e2);
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(CytoscapeViewTest.class));
        Cytoscape.exit(0);
    }
}

