/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.giny;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.giny.CytoscapeFingRootGraph;
import giny.model.Edge;
import giny.model.Node;
import junit.framework.TestCase;

public class CytoscapeFingRootGraphTest
extends TestCase {
    CytoscapeFingRootGraph root;

    public void setUp() throws Exception {
        this.root = new CytoscapeFingRootGraph();
    }

    public void tearDown() throws Exception {
        this.root = null;
    }

    public void testCreateNode() throws Exception {
        int n1id = this.root.createNode();
        CytoscapeFingRootGraphTest.assertTrue(n1id < 0);
        Node n1 = this.root.getNode(n1id);
        CytoscapeFingRootGraphTest.assertNotNull(n1);
        CytoscapeFingRootGraphTest.assertEquals(n1id, n1.getRootGraphIndex());
    }

    public void testCreateEdge() throws Exception {
        Node n1 = this.root.getNode(this.root.createNode());
        Node n2 = this.root.getNode(this.root.createNode());
        int e1id = this.root.createEdge(n1.getRootGraphIndex(), n2.getRootGraphIndex());
        CytoscapeFingRootGraphTest.assertTrue(e1id < 0);
        Edge e1 = this.root.getEdge(e1id);
        CytoscapeFingRootGraphTest.assertNotNull(e1);
        CytoscapeFingRootGraphTest.assertEquals(e1id, e1.getRootGraphIndex());
    }

    public void testGetSetNodeIdentifier() throws Exception {
        Node n1 = this.root.getNode(this.root.createNode());
        this.root.setNodeIdentifier("homer", n1.getRootGraphIndex());
        CyNode nx = this.root.getNode("homer");
        CytoscapeFingRootGraphTest.assertNotNull(nx);
        CytoscapeFingRootGraphTest.assertEquals(n1.getRootGraphIndex(), nx.getRootGraphIndex());
    }

    public void testGetSetNodeIdentifierBad() throws Exception {
        this.root.setNodeIdentifier("homer", -73);
        CyNode nx = this.root.getNode("homer");
        CytoscapeFingRootGraphTest.assertNull(nx);
    }

    public void testGetNodeIdentifierNull() throws Exception {
        CyNode nx = this.root.getNode(null);
        CytoscapeFingRootGraphTest.assertNull(nx);
    }

    public void testGetSetEdgeIdentifier() throws Exception {
        Node n1 = this.root.getNode(this.root.createNode());
        Node n2 = this.root.getNode(this.root.createNode());
        Edge e1 = this.root.getEdge(this.root.createEdge(n1.getRootGraphIndex(), n2.getRootGraphIndex()));
        this.root.setEdgeIdentifier("homer", e1.getRootGraphIndex());
        CyEdge ex = this.root.getEdge("homer");
        CytoscapeFingRootGraphTest.assertNotNull(ex);
        CytoscapeFingRootGraphTest.assertEquals(e1.getRootGraphIndex(), ex.getRootGraphIndex());
    }

    public void testGetSetEdgeIdentifierBad() throws Exception {
        this.root.setEdgeIdentifier("homer", -73);
        CyEdge ex = this.root.getEdge("homer");
        CytoscapeFingRootGraphTest.assertNull(ex);
    }

    public void testGetEdgeIdentifierNull() throws Exception {
        CyEdge ex = this.root.getEdge(null);
        CytoscapeFingRootGraphTest.assertNull(ex);
    }
}

