/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NewSlider
extends JPanel {
    private int minimum;
    private int maximum;
    private int current;
    private int sigFigs;
    private JLabel myTitle;
    private JLabel myMin;
    private JLabel myMax;
    private MJTextField myTextbox;
    private String title;
    private MJSlider mySlider;
    String attributeName;

    public NewSlider() {
        this.sigFigs = 0;
        this.minimum = this.returnInt(0.0);
        this.maximum = this.returnInt(100.0);
        this.current = this.returnInt(50.0);
        this.title = new String(" ");
        this.attributeName = "";
        this.setup();
    }

    public NewSlider(String id, double min, double max, double cur) {
        this.sigFigs = 0;
        this.title = new String(id);
        this.minimum = this.returnInt(min);
        this.maximum = this.returnInt(max);
        this.current = this.returnInt(cur);
        this.setup();
    }

    public NewSlider(String id, double min, double max, double cur, int decimal) {
        this.sigFigs = decimal;
        this.title = new String(id);
        this.minimum = this.returnInt(min);
        this.maximum = this.returnInt(max);
        this.current = this.returnInt(cur);
        this.setup();
    }

    public NewSlider(String attribute, String id, double min, double max, double cur) {
        this.sigFigs = 0;
        this.title = new String(id);
        this.minimum = this.returnInt(min);
        this.maximum = this.returnInt(max);
        this.current = this.returnInt(cur);
        this.attributeName = attribute;
        this.setup();
    }

    public NewSlider(String attribute, String id, double min, double max, double cur, int decimal) {
        this.sigFigs = decimal;
        this.title = new String(id);
        this.minimum = this.returnInt(min);
        this.maximum = this.returnInt(max);
        this.current = this.returnInt(cur);
        this.attributeName = attribute;
        this.setup();
    }

    public void setup() {
        if (this.current < this.minimum) {
            this.current = this.minimum;
        }
        if (this.current > this.maximum) {
            this.current = this.maximum;
        }
        this.mySlider = new MJSlider((double)this.minimum, (double)this.maximum, (double)this.current);
        this.myTextbox = this.sigFigs == 0 ? new MJTextField((int)this.returnDouble(this.current).doubleValue(), 6) : new MJTextField(this.returnDouble(this.current), 6);
        if (this.sigFigs == 0) {
            this.myMin = new JLabel(String.valueOf((int)this.returnDouble(this.minimum).doubleValue()), 2);
            this.myMax = new JLabel(String.valueOf((int)this.returnDouble(this.maximum).doubleValue()), 4);
        } else {
            this.myMin = new JLabel(String.valueOf(this.returnDouble(this.minimum)), 2);
            this.myMax = new JLabel(String.valueOf(this.returnDouble(this.maximum)), 4);
        }
        this.myTitle = new JLabel(this.title);
        JLabel myFiller = new JLabel(" ");
        JPanel firstSubPanel = new JPanel();
        firstSubPanel.add((Component)this.myTitle, "Center");
        firstSubPanel.add(this.myTextbox);
        JPanel secondSubPanel = new JPanel();
        secondSubPanel.setLayout(new GridLayout(0, 2));
        secondSubPanel.add(this.myMin);
        secondSubPanel.add(this.myMax);
        JPanel sumOneTwoPanel = new JPanel();
        sumOneTwoPanel.setLayout(new GridLayout(0, 1));
        sumOneTwoPanel.add(firstSubPanel);
        sumOneTwoPanel.add(this.mySlider);
        sumOneTwoPanel.add(secondSubPanel);
        this.add(sumOneTwoPanel);
        Dimension tempDim = this.getPreferredSize();
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
    }

    public double getDoubleValue() {
        return this.returnDouble(this.current);
    }

    public int getIntegerValue() {
        return (int)this.returnDouble(this.current).doubleValue();
    }

    private int returnInt(double original) {
        return (int)(original * Math.pow(10.0, this.sigFigs));
    }

    private Double returnDouble(int original) {
        Double returnVal = new Double((double)original / Math.pow(10.0, this.sigFigs));
        return returnVal;
    }

    public class MJSlider
    extends JSlider
    implements ChangeListener {
        String test;

        MJSlider(double x, double y, double currentValue) {
            super((int)x, (int)y, (int)currentValue);
            this.setMajorTickSpacing((NewSlider.this.maximum - NewSlider.this.minimum) / 4);
            this.setPaintTicks(true);
            this.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            NewSlider.this.current = source.getValue();
            String test2 = NewSlider.this.myTitle.getText();
            if (NewSlider.this.sigFigs == 0) {
                int tempInt = NewSlider.this.returnInt(source.getValue());
                NewSlider.this.myTextbox.setText(String.valueOf(tempInt));
            } else {
                Double tempDub = NewSlider.this.returnDouble(source.getValue());
                NewSlider.this.myTextbox.setText(String.valueOf(tempDub));
            }
        }
    }

    public class MJTextField
    extends JTextField
    implements ActionListener {
        MJTextField(double dub, int columns) {
            super(String.valueOf(dub), columns);
            this.addActionListener(this);
        }

        MJTextField(int tempInt, int columns) {
            super(String.valueOf(tempInt), columns);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            String str = this.getText();
            Double temp = new Double(str);
            int test2 = NewSlider.this.returnInt(temp);
            if (NewSlider.this.minimum <= test2 && test2 <= NewSlider.this.maximum) {
                NewSlider.this.mySlider.setValue(test2);
            } else {
                this.setText(String.valueOf(NewSlider.this.returnDouble(NewSlider.this.mySlider.getValue())));
            }
        }
    }
}

