/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.ding.DingNetworkView;
import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import javax.swing.event.MenuEvent;

public class PrintAction
extends CytoscapeAction {
    public static final String MENU_LABEL = "Print...";

    public PrintAction() {
        super(MENU_LABEL);
        this.setPreferredMenu("File");
        this.setAcceleratorCombo(80, 2);
    }

    public void actionPerformed(ActionEvent e) {
        CyNetworkView curr = Cytoscape.getCurrentNetworkView();
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(curr);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        DingNetworkView theViewToPrint = (DingNetworkView)Cytoscape.getCurrentNetworkView();
        boolean exportTextAsShape = new Boolean(CytoscapeInit.getProperties().getProperty("exportTextAsShape"));
        theViewToPrint.setPrintingTextAsShape(exportTextAsShape);
        printJob.setPrintable(ifc);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception exc) {
                CyLogger.getLogger(PrintAction.class).error("Print job failed", exc);
            }
        }
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetworkAndView();
    }
}

