### R code from vignette source 'DiffBind.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: DiffBind.Rnw:134-138
###################################################
tmp <-  tempfile(as.character(Sys.getpid()))
pdf(tmp)
savewarn <- options("warn")
options(warn=-1)


###################################################
### code chunk number 3: DiffBind.Rnw:142-143
###################################################
library(DiffBind)


###################################################
### code chunk number 4: DiffBind.Rnw:148-153 (eval = FALSE)
###################################################
## tamoxifen <- dba(sampleSheet="tamoxifen.csv")
## tamoxifen <- dba.count(tamoxifen)
## tamoxifen <- dba.contrast(tamoxifen)
## tamoxifen <- dba.analyze(tamoxifen)
## tamoxifen.DB <- dba.report(tamoxifen)


###################################################
### code chunk number 5: sampSheet
###################################################
samples <- read.csv(file.path(system.file("extra", package="DiffBind"),
                                         "tamoxifen.csv"))
names(samples)
samples


###################################################
### code chunk number 6: dbaConstruct
###################################################
tamoxifen <- dba(sampleSheet="tamoxifen.csv",
                 dir=system.file("extra", package="DiffBind"))


###################################################
### code chunk number 7: DiffBind.Rnw:179-180
###################################################
tamoxifen


###################################################
### code chunk number 8: tamox_occ_corhm
###################################################
plot(tamoxifen)


###################################################
### code chunk number 9: DiffBind.Rnw:212-213 (eval = FALSE)
###################################################
## tamoxifen <- dba.count(tamoxifen, summits=250)


###################################################
### code chunk number 10: DiffBind.Rnw:215-216
###################################################
data(tamoxifen_counts)


###################################################
### code chunk number 11: DiffBind.Rnw:221-222
###################################################
tamoxifen


###################################################
### code chunk number 12: tamox_aff_corhm
###################################################
plot(tamoxifen)


###################################################
### code chunk number 13: DiffBind.Rnw:242-243
###################################################
tamoxifen <- dba.contrast(tamoxifen, categories=DBA_CONDITION)


###################################################
### code chunk number 14: DiffBind.Rnw:253-255
###################################################
tamoxifen <- dba.analyze(tamoxifen)
tamoxifen


###################################################
### code chunk number 15: tamox_sdb_corhm
###################################################
plot(tamoxifen, contrast=1)


###################################################
### code chunk number 16: DiffBind.Rnw:287-288
###################################################
tamoxifen.DB <- dba.report(tamoxifen)


###################################################
### code chunk number 17: DiffBind.Rnw:293-294
###################################################
tamoxifen.DB


###################################################
### code chunk number 18: tamox_aff_pca
###################################################
data(tamoxifen_analysis)
dba.plotPCA(tamoxifen,DBA_TISSUE,label=DBA_CONDITION)


###################################################
### code chunk number 19: tamox_sdb_pca
###################################################
dba.plotPCA(tamoxifen, contrast=1,label=DBA_TISSUE)


###################################################
### code chunk number 20: tamox_sdb_ma
###################################################
dba.plotMA(tamoxifen)


###################################################
### code chunk number 21: tamox_sdb_volcano
###################################################
dba.plotVolcano(tamoxifen)


###################################################
### code chunk number 22: DiffBind.Rnw:398-400
###################################################
sum(tamoxifen.DB$Fold<0)
sum(tamoxifen.DB$Fold>0)


###################################################
### code chunk number 23: tamox_sdb_box
###################################################
pvals <- dba.plotBox(tamoxifen)


###################################################
### code chunk number 24: DiffBind.Rnw:426-427
###################################################
pvals


###################################################
### code chunk number 25: DiffBind.Rnw:439-440
###################################################
corvals <- dba.plotHeatmap(tamoxifen)


###################################################
### code chunk number 26: tamox_sdb_hm
###################################################
corvals <- dba.plotHeatmap(tamoxifen, contrast=1, correlations=FALSE)


###################################################
### code chunk number 27: DiffBind.Rnw:491-494
###################################################
data(tamoxifen_counts)
tamoxifen <- dba.contrast(tamoxifen,categories=DBA_CONDITION,
                         block=tamoxifen$masks$MCF7)


###################################################
### code chunk number 28: DiffBind.Rnw:499-501
###################################################
tamoxifen <- dba.analyze(tamoxifen)
tamoxifen


###################################################
### code chunk number 29: tamox_block_ma
###################################################
dba.plotMA(tamoxifen,method=DBA_DESEQ2_BLOCK)


###################################################
### code chunk number 30: DiffBind.Rnw:542-544
###################################################
tamoxifen <- dba.analyze(tamoxifen,method=DBA_ALL_METHODS)
dba.show(tamoxifen,bContrasts=T)[9:12]


###################################################
### code chunk number 31: tamox_block_venn
###################################################
tam.block <- dba.report(tamoxifen,method=DBA_ALL_METHODS_BLOCK,bDB=TRUE,bAll=TRUE)
tam.block
dba.plotVenn(tam.block,1:4,label1="edgeR",label2="DESeq2",
                           label3="edgeR Blocked", label4="DESeq2 Blocked")


###################################################
### code chunk number 32: DiffBind.Rnw:572-573
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 33: DiffBind.Rnw:594-596
###################################################
olap.rate <- dba.overlap(tamoxifen,mode=DBA_OLAP_RATE)
olap.rate


###################################################
### code chunk number 34: tamox_rate
###################################################
plot(olap.rate,type='b',ylab='# peaks', xlab='Overlap at least this many peaksets') 


###################################################
### code chunk number 35: DiffBind.Rnw:616-617
###################################################
names(tamoxifen$masks)


###################################################
### code chunk number 36: DiffBind.Rnw:622-624
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive,
            mode=DBA_OLAP_RATE)


###################################################
### code chunk number 37: tamox_mcf7_venn
###################################################
dba.plotVenn(tamoxifen, tamoxifen$masks$MCF7 & tamoxifen$masks$Responsive)


###################################################
### code chunk number 38: DiffBind.Rnw:646-648
###################################################
tamoxifen_consensus <- dba.peakset(tamoxifen, consensus=c(DBA_TISSUE,DBA_CONDITION),
                                   minOverlap=0.66)


###################################################
### code chunk number 39: DiffBind.Rnw:656-659
###################################################
tamoxifen_consensus <- dba(tamoxifen_consensus, mask=tamoxifen_consensus$masks$Consensus,
                           minOverlap=1)
tamoxifen_consensus


###################################################
### code chunk number 40: DiffBind.Rnw:664-665
###################################################
consensus_peaks <- dba.peakset(tamoxifen_consensus, bRetrieve=TRUE)


###################################################
### code chunk number 41: tamox_lines_venn
###################################################
data(tamoxifen_peaks)
tamoxifen <- dba.peakset(tamoxifen, consensus=DBA_TISSUE, minOverlap=0.66)
dba.plotVenn(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 42: DiffBind.Rnw:689-690
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 43: DiffBind.Rnw:695-697
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$Resistant,mode=DBA_OLAP_RATE)
dba.overlap(tamoxifen,tamoxifen$masks$Responsive,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 44: tamox_cons_venn
###################################################
tamoxifen <- dba.peakset(tamoxifen, consensus=DBA_CONDITION, minOverlap=0.33)
dba.plotVenn(tamoxifen,tamoxifen$masks$Consensus)


###################################################
### code chunk number 45: DiffBind.Rnw:726-727
###################################################
tamoxifen.OL <- dba.overlap(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 46: DiffBind.Rnw:732-734
###################################################
tamoxifen.OL$onlyA
tamoxifen.OL$onlyB


###################################################
### code chunk number 47: tamox_compare_venn
###################################################
tamoxifen <- dba.peakset(tamoxifen,tamoxifen$masks$Consensus, 
            minOverlap=1,sampID="OL Consensus")
tamoxifen <- dba.peakset(tamoxifen,!tamoxifen$masks$Consensus,
            minOverlap=3,sampID="Consensus_3") 
dba.plotVenn(tamoxifen,14:15)


###################################################
### code chunk number 48: DiffBind.Rnw:761-762
###################################################
data(tamoxifen_analysis)


###################################################
### code chunk number 49: DiffBind.Rnw:767-768
###################################################
tamoxifen.rep <- dba.report(tamoxifen,bCalled=TRUE,th=1)


###################################################
### code chunk number 50: DiffBind.Rnw:773-779
###################################################
onlyResistant <- tamoxifen.rep$Called1>=2 & tamoxifen.rep$Called2<3
sum(onlyResistant )
onlyResponsive <- tamoxifen.rep$Called2>=3 &  tamoxifen.rep$Called1<2
sum(onlyResponsive)
bothGroups <- tamoxifen.rep$Called1>= 2 & tamoxifen.rep$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 51: DiffBind.Rnw:791-798
###################################################
tamoxifen.DB <- dba.report(tamoxifen,bCalled=T)
onlyResistant.DB <- tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2<3
sum(onlyResistant.DB)
onlyResponsive.DB <- tamoxifen.DB$Called2>=3 & tamoxifen.DB$Called1<2
sum(onlyResponsive.DB)
bothGroups.DB <- tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2>=3
sum(bothGroups.DB)


###################################################
### code chunk number 52: sessionInfo
###################################################
toLatex(sessionInfo())


