/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendMessage;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.cluster.JobSchedulerProxy;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonPjJobFrontend
implements Runnable,
JobFrontendRef {
    private String username;
    private int jobnum;
    private int Np;
    private TimerThread myLeaseTimerThread;
    private Timer mySchedulerRenewTimer;
    private Timer mySchedulerExpireTimer;
    private Timer myJobTimer;
    private ChannelGroup myMiddlewareChannelGroup;
    private JobSchedulerRef myJobScheduler;
    private boolean continueRun = true;
    private State myState = State.RUNNING;
    private String myCancelMessage = "User canceled job";
    private LinkedList<String> myBackendNames = new LinkedList();

    public NonPjJobFrontend(String string, int n) throws IOException {
        this.username = string;
        this.Np = n;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                NonPjJobFrontend.this.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.mySchedulerRenewTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    NonPjJobFrontend.this.schedulerRenewTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.mySchedulerExpireTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    NonPjJobFrontend.this.schedulerExpireTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myJobTimer = this.myLeaseTimerThread.createTimer(new TimerTask(){

            public void action(Timer timer) {
                try {
                    NonPjJobFrontend.this.jobTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myMiddlewareChannelGroup = new ChannelGroup();
        InetSocketAddress inetSocketAddress = null;
        Channel channel = null;
        try {
            inetSocketAddress = new InetSocketAddress(PJProperties.getPjHost(), PJProperties.getPjPort());
            channel = this.myMiddlewareChannelGroup.connect(inetSocketAddress);
        }
        catch (IOException iOException) {
            throw new JobSchedulerException("JobFrontend(): Cannot contact Job Scheduler Daemon at " + inetSocketAddress, iOException);
        }
        this.myJobScheduler = new JobSchedulerProxy(this.myMiddlewareChannelGroup, channel);
        this.mySchedulerRenewTimer.start(60000L, 60000L);
        this.mySchedulerExpireTimer.start(150000L);
        this.myJobScheduler.requestJob(this, string, n, n, 0);
    }

    public synchronized int getJobNumber() throws InterruptedException {
        while (this.myBackendNames.size() < this.Np) {
            this.wait();
        }
        return this.jobnum;
    }

    public synchronized List<String> getBackendNames() throws InterruptedException {
        while (this.myBackendNames.size() < this.Np) {
            this.wait();
        }
        return Collections.unmodifiableList(this.myBackendNames);
    }

    @Override
    public void run() {
        ObjectItemBuf<JobFrontendMessage> objectItemBuf = ObjectBuf.buffer((JobFrontendMessage)null);
        Status status = null;
        JobFrontendMessage jobFrontendMessage = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, objectItemBuf);
                jobFrontendMessage = (JobFrontendMessage)objectItemBuf.item;
                if (status.tag == 4) {
                    jobFrontendMessage.invoke((JobFrontendRef)this, this.myJobScheduler);
                }
                objectItemBuf.item = null;
                status = null;
                jobFrontendMessage = null;
            }
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
        }
        catch (Throwable throwable) {
            this.terminateCancelJob(throwable);
        }
        switch (this.myState) {
            case TERMINATE_CANCEL_JOB: {
                System.exit(1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateJobFinished(int n) {
        boolean bl = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = null;
                bl = true;
            }
        }
        if (bl) {
            System.exit(n);
        }
    }

    @Override
    public synchronized void assignBackend(JobSchedulerRef jobSchedulerRef, String string, String string2, String string3, String string4, String[] stringArray, String string5, int n) throws IOException {
        int n2;
        this.myBackendNames.add(string);
        if (this.myBackendNames.size() == this.Np && (n2 = PJProperties.getPjJobTime()) > 0) {
            this.myJobTimer.start((long)n2 * 1000L);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void assignJobNumber(JobSchedulerRef jobSchedulerRef, int n, String string) throws IOException {
        this.jobnum = n;
        this.notifyAll();
    }

    @Override
    public synchronized void cancelJob(JobSchedulerRef jobSchedulerRef, String string) throws IOException {
        this.terminateCancelJob(string);
    }

    @Override
    public synchronized void renewLease(JobSchedulerRef jobSchedulerRef) throws IOException {
        this.mySchedulerExpireTimer.start(150000L);
    }

    @Override
    public synchronized void backendFinished(JobBackendRef jobBackendRef) throws IOException {
    }

    @Override
    public synchronized void backendReady(JobBackendRef jobBackendRef, int n, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3) throws IOException {
    }

    @Override
    public synchronized void cancelJob(JobBackendRef jobBackendRef, String string) throws IOException {
    }

    @Override
    public synchronized void renewLease(JobBackendRef jobBackendRef) throws IOException {
    }

    @Override
    public synchronized void requestResource(JobBackendRef jobBackendRef, String string) throws IOException {
    }

    @Override
    public synchronized void outputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) throws IOException {
    }

    @Override
    public synchronized void outputFileWrite(JobBackendRef jobBackendRef, int n, byte[] byArray, int n2, int n3) throws IOException {
    }

    @Override
    public synchronized void outputFileFlush(JobBackendRef jobBackendRef, int n) throws IOException {
    }

    @Override
    public synchronized void outputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
    }

    @Override
    public synchronized void inputFileOpen(JobBackendRef jobBackendRef, int n, File file) throws IOException {
    }

    @Override
    public synchronized void inputFileRead(JobBackendRef jobBackendRef, int n, int n2) throws IOException {
    }

    @Override
    public synchronized void inputFileSkip(JobBackendRef jobBackendRef, int n, long l) throws IOException {
    }

    @Override
    public synchronized void inputFileClose(JobBackendRef jobBackendRef, int n) throws IOException {
    }

    @Override
    public synchronized void reportComment(JobBackendRef jobBackendRef, int n, String string) throws IOException {
        this.myJobScheduler.reportComment(this, n, string);
    }

    @Override
    public void close() {
    }

    private synchronized void schedulerRenewTimeout() throws IOException {
        if (this.mySchedulerRenewTimer.isTriggered()) {
            this.myJobScheduler.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulerExpireTimeout() throws IOException {
        boolean bl = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            if (this.mySchedulerExpireTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job Scheduler failed";
                    System.err.println(this.myCancelMessage);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobTimeout() throws IOException {
        boolean bl = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            if (this.myJobTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job exceeded maximum running time";
                    System.err.println(this.myCancelMessage);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    private void terminateCancelJob(String string) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = string;
            System.err.println(this.myCancelMessage);
        }
    }

    private void terminateCancelJob(Throwable throwable) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myCancelMessage = throwable.getClass().getName();
            String string = throwable.getMessage();
            if (string != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + string;
            }
            System.err.println(this.myCancelMessage);
            throwable.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCancelJobOther(Throwable throwable) {
        boolean bl = false;
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = throwable.getClass().getName();
                String string = throwable.getMessage();
                if (string != null) {
                    this.myCancelMessage = this.myCancelMessage + ": " + string;
                }
                System.err.println(this.myCancelMessage);
                throwable.printStackTrace(System.err);
                bl = true;
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        NonPjJobFrontend nonPjJobFrontend = this;
        synchronized (nonPjJobFrontend) {
            this.mySchedulerRenewTimer.stop();
            this.mySchedulerExpireTimer.stop();
            if (this.myState == State.RUNNING && this.myCancelMessage != null) {
                this.myState = State.TERMINATE_CANCEL_JOB;
            }
            switch (this.myState) {
                case RUNNING: {
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.jobFinished(this);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case TERMINATE_CANCEL_JOB: {
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.cancelJob(this, this.myCancelMessage);
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            this.myState = State.TERMINATING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATING;

    }
}

