/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class JobSchedulerMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = -7379945472003527741L;

    public JobSchedulerMessage() {
    }

    public JobSchedulerMessage(int n) {
        super(n);
    }

    public static JobSchedulerMessage backendFailed(JobFrontendRef jobFrontendRef, String string) {
        return new BackendFailedMessage(jobFrontendRef, string);
    }

    public static JobSchedulerMessage cancelJob(JobFrontendRef jobFrontendRef, String string) {
        return new CancelJobMessage(jobFrontendRef, string);
    }

    public static JobSchedulerMessage jobFinished(JobFrontendRef jobFrontendRef) {
        return new JobFinishedMessage(jobFrontendRef);
    }

    public static JobSchedulerMessage renewLease(JobFrontendRef jobFrontendRef) {
        return new RenewLeaseMessage(jobFrontendRef);
    }

    public static JobSchedulerMessage reportComment(JobFrontendRef jobFrontendRef, int n, String string) {
        return new ReportCommentMessage(jobFrontendRef, n, string);
    }

    public static JobSchedulerMessage requestJob(JobFrontendRef jobFrontendRef, String string, int n, int n2, int n3) {
        return new RequestJobMessage(jobFrontendRef, string, n, n2, n3);
    }

    public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
    }

    private static class RequestJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -6712799261136980645L;
        private String username;
        private int Nn;
        private int Np;
        private int Nt;

        public RequestJobMessage() {
        }

        public RequestJobMessage(JobFrontendRef jobFrontendRef, String string, int n, int n2, int n3) {
            super(2);
            this.username = string;
            this.Nn = n;
            this.Np = n2;
            this.Nt = n3;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.requestJob(jobFrontendRef, this.username, this.Nn, this.Np, this.Nt);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.username);
            objectOutput.writeInt(this.Nn);
            objectOutput.writeInt(this.Np);
            objectOutput.writeInt(this.Nt);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.username = objectInput.readUTF();
            this.Nn = objectInput.readInt();
            this.Np = objectInput.readInt();
            this.Nt = objectInput.readInt();
        }
    }

    private static class ReportCommentMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -7431990305653172900L;
        private int rank;
        private String comment;

        public ReportCommentMessage() {
        }

        public ReportCommentMessage(JobFrontendRef jobFrontendRef, int n, String string) {
            super(2);
            this.rank = n;
            this.comment = string == null ? "" : string;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.reportComment(jobFrontendRef, this.rank, this.comment);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.rank);
            objectOutput.writeUTF(this.comment);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.rank = objectInput.readInt();
            this.comment = objectInput.readUTF();
        }
    }

    private static class RenewLeaseMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 8547605668292095227L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.renewLease(jobFrontendRef);
        }
    }

    private static class JobFinishedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -1179228962545666153L;

        public JobFinishedMessage() {
        }

        public JobFinishedMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.jobFinished(jobFrontendRef);
        }
    }

    private static class CancelJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 2902818757044365344L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobFrontendRef jobFrontendRef, String string) {
            super(2);
            this.errmsg = string;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.cancelJob(jobFrontendRef, this.errmsg);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.errmsg);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.errmsg = objectInput.readUTF();
        }
    }

    private static class BackendFailedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 6495614788809259018L;
        private String name;

        public BackendFailedMessage() {
        }

        public BackendFailedMessage(JobFrontendRef jobFrontendRef, String string) {
            super(2);
            this.name = string;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.backendFailed(jobFrontendRef, this.name);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.name);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.name = objectInput.readUTF();
        }
    }
}

