/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DomainException;
import edu.rit.numeric.Tridiagonal;
import java.util.Arrays;

public class CurveSmoothing {
    private CurveSmoothing() {
    }

    public static void computeBezierClosed(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        Arrays.fill(dArray4, 4.0);
        Arrays.fill(dArray5, 1.0);
        for (n3 = 0; n3 < n2; ++n3) {
            dArray7[n3] = 6.0 * dArray[n + (n3 + n2 - 1) % n2] - 12.0 * dArray[n + n3] + 6.0 * dArray[n + (n3 + 1) % n2];
        }
        Tridiagonal.solveSymmetricCyclic(dArray4, dArray5, dArray7, dArray6);
        for (n3 = 0; n3 < n2; ++n3) {
            dArray2[n + n3] = 2.0 * dArray[n + n3] / 3.0 + dArray[n + (n3 + 1) % n2] / 3.0 - dArray6[n3] / 9.0 - dArray6[(n3 + 1) % n2] / 18.0;
            dArray3[n + n3] = dArray[n + n3] / 3.0 + 2.0 * dArray[n + (n3 + 1) % n2] / 3.0 - dArray6[n3] / 18.0 - dArray6[(n3 + 1) % n2] / 9.0;
        }
    }

    public static void computeBezierOpen(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        double[] dArray4 = new double[n2 - 1];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2 - 1];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        Arrays.fill(dArray4, 0, n2 - 2, 1.0);
        dArray5[0] = 1.0;
        Arrays.fill(dArray5, 1, n2 - 1, 4.0);
        dArray5[n2 - 1] = 1.0;
        Arrays.fill(dArray6, 1, n2 - 1, 1.0);
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * dArray[n + n3 + 1];
        }
        Tridiagonal.solve(dArray5, dArray6, dArray4, dArray8, dArray7);
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            dArray2[n + n3] = 2.0 * dArray[n + n3] / 3.0 + dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 9.0 - dArray7[n3 + 1] / 18.0;
            dArray3[n + n3] = dArray[n + n3] / 3.0 + 2.0 * dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 18.0 - dArray7[n3 + 1] / 9.0;
        }
    }

    public static void computeBezierOpen(double d, double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        double[] dArray4 = new double[n2 - 1];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2 - 1];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        Arrays.fill(dArray4, 0, n2 - 2, 1.0);
        dArray5[0] = 2.0;
        Arrays.fill(dArray5, 1, n2 - 1, 4.0);
        dArray5[n2 - 1] = 1.0;
        Arrays.fill(dArray6, 0, n2 - 1, 1.0);
        dArray8[0] = 6.0 * d - 12.0 * dArray[n] + 6.0 * dArray[n + 1];
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * dArray[n + n3 + 1];
        }
        Tridiagonal.solve(dArray5, dArray6, dArray4, dArray8, dArray7);
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            dArray2[n + n3] = 2.0 * dArray[n + n3] / 3.0 + dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 9.0 - dArray7[n3 + 1] / 18.0;
            dArray3[n + n3] = dArray[n + n3] / 3.0 + 2.0 * dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 18.0 - dArray7[n3 + 1] / 9.0;
        }
    }

    public static void computeBezierOpen(double[] dArray, double d, double[] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        double[] dArray4 = new double[n2 - 1];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2 - 1];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        Arrays.fill(dArray4, 0, n2 - 1, 1.0);
        dArray5[0] = 1.0;
        Arrays.fill(dArray5, 1, n2 - 1, 4.0);
        dArray5[n2 - 1] = 2.0;
        Arrays.fill(dArray6, 1, n2 - 1, 1.0);
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * dArray[n + n3 + 1];
        }
        dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * d;
        Tridiagonal.solve(dArray5, dArray6, dArray4, dArray8, dArray7);
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            dArray2[n + n3] = 2.0 * dArray[n + n3] / 3.0 + dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 9.0 - dArray7[n3 + 1] / 18.0;
            dArray3[n + n3] = dArray[n + n3] / 3.0 + 2.0 * dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 18.0 - dArray7[n3 + 1] / 9.0;
        }
    }

    public static void computeBezierOpen(double d, double[] dArray, double d2, double[] dArray2, double[] dArray3, int n, int n2) throws DomainException {
        int n3;
        double[] dArray4 = new double[n2 - 1];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2 - 1];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        Arrays.fill(dArray4, 1.0);
        dArray5[0] = 2.0;
        Arrays.fill(dArray5, 1, n2 - 1, 4.0);
        dArray5[n2 - 1] = 2.0;
        Arrays.fill(dArray6, 1.0);
        dArray8[0] = 6.0 * d - 12.0 * dArray[n] + 6.0 * dArray[n + 1];
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * dArray[n + n3 + 1];
        }
        dArray8[n3] = 6.0 * dArray[n + n3 - 1] - 12.0 * dArray[n + n3] + 6.0 * d2;
        Tridiagonal.solve(dArray5, dArray6, dArray4, dArray8, dArray7);
        for (n3 = 0; n3 < n2 - 1; ++n3) {
            dArray2[n + n3] = 2.0 * dArray[n + n3] / 3.0 + dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 9.0 - dArray7[n3 + 1] / 18.0;
            dArray3[n + n3] = dArray[n + n3] / 3.0 + 2.0 * dArray[n + n3 + 1] / 3.0 - dArray7[n3] / 18.0 - dArray7[n3 + 1] / 9.0;
        }
    }
}

