/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyShortBuf;
import edu.rit.mp.buf.SharedShortArrayBuf;
import edu.rit.mp.buf.SharedShortArrayBuf_1;
import edu.rit.mp.buf.SharedShortBuf;
import edu.rit.mp.buf.ShortArrayBuf;
import edu.rit.mp.buf.ShortArrayBuf_1;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.mp.buf.ShortMatrixBuf;
import edu.rit.mp.buf.ShortMatrixBuf_1;
import edu.rit.pj.reduction.SharedShort;
import edu.rit.pj.reduction.SharedShortArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class ShortBuf
extends Buf {
    protected ShortBuf(int n) {
        super((byte)3, n);
    }

    public static ShortBuf emptyBuffer() {
        return new EmptyShortBuf();
    }

    public static ShortItemBuf buffer() {
        return new ShortItemBuf();
    }

    public static ShortItemBuf buffer(short s) {
        return new ShortItemBuf(s);
    }

    public static ShortBuf buffer(short[] sArray) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.buffer(): theArray is null");
        }
        int n = Arrays.length(sArray);
        return new ShortArrayBuf_1(sArray, new Range(0, n - 1));
    }

    public static ShortBuf sliceBuffer(short[] sArray, Range range) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.sliceBuffer(): theArray is null");
        }
        int n = Arrays.length(sArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ShortBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new ShortArrayBuf_1(sArray, range);
        }
        return new ShortArrayBuf(sArray, range);
    }

    public static ShortBuf[] sliceBuffers(short[] sArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ShortBuf[] shortBufArray = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            shortBufArray[i] = ShortBuf.sliceBuffer(sArray, rangeArray[i]);
        }
        return shortBufArray;
    }

    public static ShortBuf buffer(short[][] sArray) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.buffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(sArray);
        int n2 = Arrays.colLength(sArray, 0);
        return new ShortMatrixBuf_1(sArray, new Range(0, n - 1), new Range(0, n2 - 1));
    }

    public static ShortBuf rowSliceBuffer(short[][] sArray, Range range) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.rowSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(sArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ShortBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(sArray, range.lb());
        if (range.stride() == 1) {
            return new ShortMatrixBuf_1(sArray, range, new Range(0, n2 - 1));
        }
        return new ShortMatrixBuf(sArray, range, new Range(0, n2 - 1));
    }

    public static ShortBuf[] rowSliceBuffers(short[][] sArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ShortBuf[] shortBufArray = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            shortBufArray[i] = ShortBuf.rowSliceBuffer(sArray, rangeArray[i]);
        }
        return shortBufArray;
    }

    public static ShortBuf colSliceBuffer(short[][] sArray, Range range) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.colSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(sArray);
        int n2 = Arrays.colLength(sArray, 0);
        if (0 > range.lb() || range.ub() >= n2) {
            throw new IndexOutOfBoundsException("ShortBuf.colSliceBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range);
        }
        if (range.stride() == 1) {
            return new ShortMatrixBuf_1(sArray, new Range(0, n - 1), range);
        }
        return new ShortMatrixBuf(sArray, new Range(0, n - 1), range);
    }

    public static ShortBuf[] colSliceBuffers(short[][] sArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ShortBuf[] shortBufArray = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            shortBufArray[i] = ShortBuf.colSliceBuffer(sArray, rangeArray[i]);
        }
        return shortBufArray;
    }

    public static ShortBuf patchBuffer(short[][] sArray, Range range, Range range2) {
        if (sArray == null) {
            throw new NullPointerException("ShortBuf.patchBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(sArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ShortBuf.patchBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(sArray, range.lb());
        if (0 > range2.lb() || range2.ub() >= n2) {
            throw new IndexOutOfBoundsException("ShortBuf.patchBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range2);
        }
        if (range.stride() == 1 && range2.stride() == 1) {
            return new ShortMatrixBuf_1(sArray, range, range2);
        }
        return new ShortMatrixBuf(sArray, range, range2);
    }

    public static ShortBuf[] patchBuffers(short[][] sArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        ShortBuf[] shortBufArray = new ShortBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                shortBufArray[n3++] = ShortBuf.patchBuffer(sArray, range, rangeArray2[j]);
            }
        }
        return shortBufArray;
    }

    public static ShortBuf buffer(SharedShort sharedShort) {
        if (sharedShort == null) {
            throw new NullPointerException("ShortBuf.buffer(): item is null");
        }
        return new SharedShortBuf(sharedShort);
    }

    public static ShortBuf buffer(SharedShortArray sharedShortArray) {
        if (sharedShortArray == null) {
            throw new NullPointerException("ShortBuf.buffer(): theArray is null");
        }
        int n = sharedShortArray.length();
        return new SharedShortArrayBuf_1(sharedShortArray, new Range(0, n - 1));
    }

    public static ShortBuf sliceBuffer(SharedShortArray sharedShortArray, Range range) {
        if (sharedShortArray == null) {
            throw new NullPointerException("ShortBuf.sliceBuffer(): theArray is null");
        }
        int n = sharedShortArray.length();
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ShortBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new SharedShortArrayBuf_1(sharedShortArray, range);
        }
        return new SharedShortArrayBuf(sharedShortArray, range);
    }

    public static ShortBuf[] sliceBuffers(SharedShortArray sharedShortArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ShortBuf[] shortBufArray = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            shortBufArray[i] = ShortBuf.sliceBuffer(sharedShortArray, rangeArray[i]);
        }
        return shortBufArray;
    }

    public abstract short get(int var1);

    public abstract void put(int var1, short var2);

    public void copy(Buf buf) {
        if (buf != this) {
            ShortBuf.defaultCopy((ShortBuf)buf, this);
        }
    }

    public void fill(Object object) {
        short s = object == null ? (short)0 : (Short)object;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, s);
        }
    }

    public Buf getTemporaryBuf() {
        return ShortBuf.buffer(new short[this.myLength]);
    }

    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining() / 2);
        byteBuffer.position(byteBuffer.position() + 2 * n2);
        return n2;
    }

    protected static void defaultCopy(ShortBuf shortBuf, ShortBuf shortBuf2) {
        int n = Math.min(shortBuf.myLength, shortBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            shortBuf2.put(i, shortBuf.get(i));
        }
    }
}

