/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import edu.rit.mp.NetworkChannel;
import edu.rit.mp.Status;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

class NetworkChannelReceiveThread
extends Thread {
    private NetworkChannel myNetworkChannel;
    private ChannelGroup myChannelGroup;
    private SocketChannel mySocketChannel;
    private IORequestList myIORequestList;
    private ByteBuffer myByteBuffer;

    NetworkChannelReceiveThread(NetworkChannel networkChannel, SocketChannel socketChannel) {
        this.myNetworkChannel = networkChannel;
        this.myChannelGroup = networkChannel.myChannelGroup;
        this.mySocketChannel = socketChannel;
        this.myIORequestList = networkChannel.myIORequestList;
        this.myByteBuffer = ByteBuffer.allocateDirect(29200);
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        block17: {
            IORequest iORequest = null;
            Buf buf = null;
            this.myByteBuffer.position(0);
            this.myByteBuffer.limit(0);
            try {
                while (true) {
                    if (this.myByteBuffer.remaining() < 13) {
                        this.myByteBuffer.compact();
                        if (this.mySocketChannel.read(this.myByteBuffer) != -1) {
                            this.myByteBuffer.flip();
                            continue;
                        }
                        break;
                    }
                    int n = this.myByteBuffer.getInt();
                    int n2 = this.myByteBuffer.getInt();
                    byte by = this.myByteBuffer.get();
                    int n3 = this.myByteBuffer.getInt();
                    if (n != 30144596) {
                        this.myChannelGroup.myLogger.log("edu.rit.mp.NetworkChannelReceiveThread: Invalid magic number received");
                        this.myNetworkChannel.close();
                        break;
                    }
                    iORequest = this.myIORequestList.waitForMatch(this.myNetworkChannel, n2, by);
                    buf = iORequest.myBuf;
                    buf.preReceive(n3);
                    int n4 = buf.myMessageLength;
                    int n5 = 0;
                    int n6 = Math.min(n3, n4);
                    int n7 = buf.receiveItems(n5, n6, this.myByteBuffer);
                    n5 += n7;
                    n6 -= n7;
                    while (n6 > 0) {
                        this.myByteBuffer.compact();
                        if (this.mySocketChannel.read(this.myByteBuffer) == -1) {
                            throw new EOFException("Unexpected end-of-stream while receiving message");
                        }
                        this.myByteBuffer.flip();
                        n7 = buf.receiveItems(n5, n6, this.myByteBuffer);
                        n5 += n7;
                        n6 -= n7;
                    }
                    n6 = n3 - n4;
                    if (n6 > 0) {
                        n6 -= buf.skipItems(n6, this.myByteBuffer);
                        while (n6 > 0) {
                            this.myByteBuffer.compact();
                            if (this.mySocketChannel.read(this.myByteBuffer) == -1) {
                                throw new EOFException("Unexpected end-of-stream while receiving message");
                            }
                            this.myByteBuffer.flip();
                            n6 -= buf.skipItems(n6, this.myByteBuffer);
                        }
                    }
                    Status status = new Status(this.myNetworkChannel, n2, n3);
                    buf.postReceive(status, this.myChannelGroup.myClassLoader);
                    iORequest.myStatus = status;
                    iORequest.reportSuccess();
                    iORequest = null;
                    buf = null;
                }
            }
            catch (IOException iOException) {
                if (iORequest != null) {
                    iORequest.reportFailure(iOException);
                }
            }
            catch (InterruptedException interruptedException) {
                if (iORequest != null) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    interruptedIOException.initCause(interruptedException);
                    iORequest.reportFailure(interruptedIOException);
                }
            }
            catch (RuntimeException runtimeException) {
                if (iORequest != null) {
                    iORequest.reportFailure(runtimeException);
                }
            }
            catch (Error error) {
                if (iORequest == null) break block17;
                iORequest.reportFailure(error);
            }
        }
        this.myNetworkChannel.shutdownInput();
        this.myNetworkChannel = null;
        this.myChannelGroup = null;
        this.mySocketChannel = null;
        this.myIORequestList = null;
        this.myByteBuffer = null;
    }
}

