/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.swing.Displayable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

class GrayDisplayable
implements Displayable {
    private int myHeight;
    private int myWidth;
    private byte[][] myMatrix;

    public GrayDisplayable(int n, int n2, byte[][] byArray) {
        this.myWidth = n2;
        this.myHeight = n;
        this.myMatrix = byArray;
    }

    public Rectangle2D getBoundingBox() {
        return new Rectangle2D.Double(0.0, 0.0, this.myWidth, this.myHeight);
    }

    public Paint getBackgroundPaint() {
        return Color.LIGHT_GRAY;
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.myMatrix == null) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            n4 = 0;
            n3 = this.myHeight;
            n2 = 0;
            n = this.myWidth;
        } else {
            n4 = Math.max(rectangle.y, 0);
            n3 = Math.min(rectangle.y + rectangle.height, this.myHeight);
            n2 = Math.max(rectangle.x, 0);
            n = Math.min(rectangle.x + rectangle.width, this.myWidth);
        }
        Rectangle rectangle2 = new Rectangle();
        for (int i = n4; i < n3; ++i) {
            int n5;
            int n6;
            byte[] byArray = this.myMatrix[i];
            if (byArray == null || (n6 = Math.min(byArray.length, n2)) >= (n5 = Math.min(byArray.length, n))) continue;
            int n7 = n6;
            int n8 = 1;
            int n9 = byArray[n7] & 0xFF;
            for (int j = n6 + 1; j < n5; ++j) {
                int n10 = byArray[j] & 0xFF;
                if (n9 != n10) {
                    rectangle2.setBounds(n7, i, n8, 1);
                    graphics2D.setColor(new Color(n9, n9, n9));
                    graphics2D.fill(rectangle2);
                    n7 = j;
                    n8 = 1;
                    n9 = n10;
                    continue;
                }
                ++n8;
            }
            rectangle2.setBounds(n7, i, n8, 1);
            graphics2D.setColor(new Color(n9, n9, n9));
            graphics2D.fill(rectangle2);
        }
        graphics2D.setPaint(paint);
    }
}

