/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.Distance;
import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.LeastSquaresBranchLengths;
import java.io.File;
import java.text.DecimalFormat;

public class Upgma {
    private static DecimalFormat FMT = new DecimalFormat("0.00");

    private Upgma() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            Upgma.usage();
        }
        JukesCantorDistance jukesCantorDistance = new JukesCantorDistance();
        DnaSequenceTree dnaSequenceTree = Upgma.buildTree(DnaSequenceList.read(new File(stringArray[0])), jukesCantorDistance);
        System.out.println(dnaSequenceTree);
        System.out.println("Squared error = " + LeastSquaresBranchLengths.squaredError(dnaSequenceTree, jukesCantorDistance));
    }

    public static DnaSequenceTree buildTree(DnaSequenceList dnaSequenceList, Distance distance) {
        int n;
        int n2 = dnaSequenceList.length();
        DnaSequenceTree[] dnaSequenceTreeArray = new DnaSequenceTree[n2 + 1];
        for (int i = 0; i < n2; ++i) {
            dnaSequenceTreeArray[i] = new DnaSequenceTree(1);
            dnaSequenceTreeArray[i].add(0, dnaSequenceList.seq(i));
        }
        double[][] dArray = new double[n2 + 1][n2 + 1];
        for (int i = 0; i < n2 - 1; ++i) {
            DnaSequence dnaSequence = dnaSequenceList.seq(i);
            double[] dArray2 = dArray[i];
            for (n = i + 1; n < n2; ++n) {
                double d;
                DnaSequence dnaSequence2 = dnaSequenceList.seq(n);
                dArray2[n] = d = distance.distance(dnaSequence, dnaSequence2);
                dArray[n][i] = d;
            }
        }
        int[] nArray = new int[n2 + 1];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = 1;
        }
        while (n2 > 1) {
            Object object;
            int n3;
            Object object2;
            double d = Double.POSITIVE_INFINITY;
            n = 0;
            int n4 = 0;
            for (int i = 0; i < n2 - 1; ++i) {
                object2 = dArray[i];
                for (int j = i + 1; j < n2; ++j) {
                    double d2 = object2[j];
                    if (!(d2 < d)) continue;
                    d = d2;
                    n = i;
                    n4 = j;
                }
            }
            DnaSequenceTree dnaSequenceTree = dnaSequenceTreeArray[n];
            dnaSequenceTree.branchLength(dnaSequenceTree.root(), 0.5 * d);
            object2 = dnaSequenceTreeArray[n4];
            ((DnaSequenceTree)object2).branchLength(((DnaSequenceTree)object2).root(), 0.5 * d);
            DnaSequenceTree dnaSequenceTree2 = new DnaSequenceTree(dnaSequenceTree.length() + ((DnaSequenceTree)object2).length() + 1);
            dnaSequenceTree2.join(dnaSequenceTree, (DnaSequenceTree)object2);
            dnaSequenceTreeArray[n2] = dnaSequenceTree2;
            nArray[n2] = n3 = nArray[n] + nArray[n4];
            double d3 = (double)nArray[n] / (double)n3;
            double d4 = (double)nArray[n4] / (double)n3;
            double[] dArray3 = dArray[n2];
            for (int i = 0; i < n2; ++i) {
                double d5;
                object = dArray[i];
                dArray3[i] = d5 = d3 * object[n] + d4 * object[n4];
                object[n2] = d5;
            }
            double[] dArray4 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = dArray4;
            dArray4 = dArray[n4];
            dArray[n4] = dArray[n2 - 1];
            dArray[n2 - 1] = dArray4;
            object = dnaSequenceTreeArray[n];
            dnaSequenceTreeArray[n] = dnaSequenceTreeArray[n2];
            dnaSequenceTreeArray[n2] = object;
            object = dnaSequenceTreeArray[n4];
            dnaSequenceTreeArray[n4] = dnaSequenceTreeArray[n2 - 1];
            dnaSequenceTreeArray[n2 - 1] = object;
            int n5 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n5;
            n5 = nArray[n4];
            nArray[n4] = nArray[n2 - 1];
            nArray[n2 - 1] = n5;
            for (int i = 0; i <= n2; ++i) {
                double[] dArray5 = dArray[i];
                double d6 = dArray5[n];
                dArray5[n] = dArray5[n2];
                dArray5[n2] = d6;
                d6 = dArray5[n4];
                dArray5[n4] = dArray5[n2 - 1];
                dArray5[n2 - 1] = d6;
            }
            dArray[n2] = null;
            dnaSequenceTreeArray[n2] = null;
            --n2;
        }
        Upgma.computeBranchLengths(dnaSequenceTreeArray[0], dnaSequenceTreeArray[0].root());
        return dnaSequenceTreeArray[0];
    }

    private static double computeBranchLengths(DnaSequenceTree dnaSequenceTree, int n) {
        if (n == -1) {
            return 0.0;
        }
        double d = Upgma.computeBranchLengths(dnaSequenceTree, dnaSequenceTree.child1(n));
        Upgma.computeBranchLengths(dnaSequenceTree, dnaSequenceTree.child2(n));
        Double d2 = dnaSequenceTree.branchLength(n);
        if (d2 == null) {
            return 0.0;
        }
        dnaSequenceTree.branchLength(n, d2 - d);
        return d2;
    }

    private static void dump(String string, double[][] dArray, int[] nArray, int n) {
        int n2;
        System.out.println(string);
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("\t" + n2);
        }
        System.out.println("\tn");
        for (n2 = 0; n2 < n; ++n2) {
            double[] dArray2 = dArray[n2];
            System.out.print(n2);
            for (int i = 0; i < n; ++i) {
                System.out.print("\t" + FMT.format(dArray2[i]));
            }
            System.out.println("\t" + nArray[n2]);
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.phyl.Upgma <file>");
        System.exit(1);
    }
}

